/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.viewers;

import com.fusesource.zk.jmx.JmxActivator;
import com.fusesource.zk.jmx.data.MBean;
import com.fusesource.zk.jmx.data.ObjectNameKeyValue;
import com.fusesource.zk.jmx.model.MBeanModel;
import com.fusesource.zk.jmx.viewers.AbstractObjectNameKeyValueModelElementType;
import java.util.Set;
import javax.management.MBeanInfo;
import org.eclipse.swt.graphics.Image;

public class MBeanModelElementType
extends AbstractObjectNameKeyValueModelElementType {
    public static final String COLUMN_TITLE_CLASS_NAME = "Class Name";
    public static final String COLUMN_TITLE_DESCRIPTION = "Description";
    public static final String COLUMN_TITLE_OBJECT_NAME = "ObjectName";
    private static final int[] COLUMN_ALIGNMENTS = new int[]{16384, 16384, 16384};
    private static final String[] COLUMN_TITLES = new String[]{"ObjectName", "Class Name", "Description"};
    private static final int[] COLUMN_WIDTHS = new int[]{-1, 150, 150};

    @Override
    public int getChildCount(Object parent) {
        Set<String> operationNames;
        int childCount = super.getChildCount(parent);
        MBeanModel model = (MBeanModel)((Object)parent);
        Set<String> attributeNames = model.getAttributeNames();
        if (attributeNames != null && attributeNames.size() > 0) {
            ++childCount;
        }
        if ((operationNames = model.getOperationNames()) != null && operationNames.size() > 0) {
            ++childCount;
        }
        return childCount;
    }

    @Override
    public Object getChildElement(Object parent, int index) {
        int baseChildCount = super.getChildCount(parent);
        if (index < baseChildCount) {
            return super.getChildElement(parent, index);
        }
        MBeanModel model = (MBeanModel)((Object)parent);
        int baseIndex = baseChildCount;
        int attributeIndex = -1;
        int attributeCount = 0;
        Set<String> attributeNames = model.getAttributeNames();
        if (attributeNames != null) {
            attributeCount = attributeNames.size();
        }
        if (attributeCount > 0 && index == (attributeIndex = baseIndex)) {
            return model.getAttributesModelCategory();
        }
        int operationsIndex = -1;
        int operationCount = 0;
        Set<String> operationNames = model.getOperationNames();
        if (operationNames != null) {
            operationCount = operationNames.size();
        }
        if (operationCount > 0) {
            operationsIndex = baseIndex;
            if (attributeCount > 0) {
                ++operationsIndex;
            }
            if (index == operationsIndex) {
                return model.getOperationsModelCategory();
            }
        }
        return null;
    }

    public int[] getColumnAlignments() {
        return COLUMN_ALIGNMENTS;
    }

    public String getColumnText(Object element, int columnIndex) {
        MBeanModel model = (MBeanModel)((Object)element);
        MBean mbean = (MBean)model.getData();
        MBeanInfo info = mbean.getInfo();
        switch (columnIndex) {
            case 0: {
                return mbean.getObjectName().toString();
            }
            case 1: {
                return info.getClassName();
            }
            case 2: {
                return info.getDescription();
            }
        }
        return null;
    }

    public String[] getColumnTitles() {
        return COLUMN_TITLES;
    }

    public int[] getColumnWidths() {
        return COLUMN_WIDTHS;
    }

    public Image getImage(Object element) {
        return JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_MBEAN");
    }

    public Image getLargeImage(Object element) {
        return JmxActivator.getManagedImage("IMAGE_KEY_OBJECT_MBEAN_LARGE");
    }

    @Override
    protected ObjectNameKeyValue getObjectNameKeyValue(Object element) {
        MBeanModel model = (MBeanModel)((Object)element);
        return model.getObjectNameKeyValue();
    }
}

