/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.views.explorer;

import com.fusesource.zk.core.actions.BaseAction;
import com.fusesource.zk.core.actions.RefreshAction;
import com.fusesource.zk.core.model.DataModelManager;
import com.fusesource.zk.core.viewers.DataModelManagerElementType;
import com.fusesource.zk.core.viewers.ElementTypes;
import com.fusesource.zk.core.viewers.IElementType;
import com.fusesource.zk.core.viewers.ViewerFactory;
import com.fusesource.zk.jmx.JmxActivator;
import com.fusesource.zk.jmx.actions.JmxDeleteAction;
import com.fusesource.zk.jmx.actions.JmxOpenAction;
import com.fusesource.zk.jmx.actions.NewJmxConnectionAction;
import com.fusesource.zk.jmx.data.JmxConnection;
import com.fusesource.zk.jmx.data.JmxConnectionDescriptor;
import com.fusesource.zk.jmx.model.DomainModel;
import com.fusesource.zk.jmx.model.JmxConnectionModel;
import com.fusesource.zk.jmx.model.MBeanAttributeModel;
import com.fusesource.zk.jmx.model.MBeanAttributesModelCategory;
import com.fusesource.zk.jmx.model.MBeanModel;
import com.fusesource.zk.jmx.model.MBeanOperationModel;
import com.fusesource.zk.jmx.model.MBeanOperationsModelCategory;
import com.fusesource.zk.jmx.model.ObjectNameKeyValueModel;
import com.fusesource.zk.jmx.viewers.DomainModelElementType;
import com.fusesource.zk.jmx.viewers.JmxConnectionModelElementType;
import com.fusesource.zk.jmx.viewers.MBeanAttributeModelElementType;
import com.fusesource.zk.jmx.viewers.MBeanAttributesModelCategoryElementType;
import com.fusesource.zk.jmx.viewers.MBeanModelElementType;
import com.fusesource.zk.jmx.viewers.MBeanOperationModelElementType;
import com.fusesource.zk.jmx.viewers.MBeanOperationsModelCategoryElementType;
import com.fusesource.zk.jmx.viewers.ObjectNameKeyValueModelElementType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;

public class JmxExplorerView
extends ViewPart {
    public static final String ID = JmxExplorerView.class.getName();
    private JmxDeleteAction _DeleteAction;
    private NewJmxConnectionAction _NewJmxConnectionAction;
    private JmxOpenAction _OpenAction;
    private RefreshAction _RefreshAction;
    private TreeViewer _TreeViewer;
    private DrillDownAdapter _DrillDownAdapter;

    public void createPartControl(Composite parent) {
        DataModelManager<JmxConnectionModel, JmxConnectionDescriptor, JmxConnection> jmxConnectionModelManager = JmxActivator.getDefault().getJmxConnectionModelManager();
        ElementTypes elementTypes = new ElementTypes();
        elementTypes.add(jmxConnectionModelManager.getClass(), (IElementType)new DataModelManagerElementType());
        elementTypes.add(JmxConnectionModel.class, (IElementType)new JmxConnectionModelElementType());
        elementTypes.add(DomainModel.class, (IElementType)new DomainModelElementType());
        elementTypes.add(ObjectNameKeyValueModel.class, (IElementType)new ObjectNameKeyValueModelElementType());
        elementTypes.add(MBeanModel.class, (IElementType)new MBeanModelElementType());
        elementTypes.add(MBeanAttributesModelCategory.class, (IElementType)new MBeanAttributesModelCategoryElementType());
        elementTypes.add(MBeanAttributeModel.class, (IElementType)new MBeanAttributeModelElementType());
        elementTypes.add(MBeanOperationsModelCategory.class, (IElementType)new MBeanOperationsModelCategoryElementType());
        elementTypes.add(MBeanOperationModel.class, (IElementType)new MBeanOperationModelElementType());
        this._TreeViewer = ViewerFactory.createDataModelTreeViewer((Composite)parent, (int)268436226, (ElementTypes)elementTypes, jmxConnectionModelManager);
        this._TreeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                JmxExplorerView.this.getSite().getWorkbenchWindow().getActivePage().activate((IWorkbenchPart)JmxExplorerView.this);
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._DrillDownAdapter = new DrillDownAdapter(this._TreeViewer);
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        JmxActivator plugin = JmxActivator.getDefault();
        plugin.getJmxConnectionModelManager().getModels();
    }

    public void setFocus() {
        this._TreeViewer.getControl().setFocus();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection structuredSelection = (IStructuredSelection)this._TreeViewer.getSelection();
        boolean emptySelection = structuredSelection == null || structuredSelection.isEmpty();
        manager.add((IAction)this._NewJmxConnectionAction);
        if (emptySelection) {
            return;
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this._OpenAction);
        manager.add((IContributionItem)new Separator());
        if (this._DeleteAction.isEnabled()) {
            manager.add((IAction)this._DeleteAction);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this._RefreshAction);
        manager.add((IContributionItem)new Separator());
        this._DrillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this._NewJmxConnectionAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this._NewJmxConnectionAction);
        manager.add((IContributionItem)new Separator());
        this._DrillDownAdapter.addNavigationActions(manager);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JmxExplorerView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this._TreeViewer.getControl());
        this._TreeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._TreeViewer);
    }

    private void makeActions() {
        this._DeleteAction = new JmxDeleteAction();
        this._DeleteAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._NewJmxConnectionAction = new NewJmxConnectionAction();
        this._NewJmxConnectionAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._OpenAction = new JmxOpenAction();
        this._OpenAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
        this._RefreshAction = new RefreshAction(BaseAction.InputType.STRUCTURED_SELECTION);
        this._RefreshAction.setSelectionProvider((ISelectionProvider)this._TreeViewer);
    }
}

