/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.zk.jmx.wizards.newjmxconnection;

import com.fusesource.zk.core.widgets.grid.GridComposite;
import com.fusesource.zk.core.widgets.grid.GridCompositeStatus;
import com.fusesource.zk.core.widgets.grid.GridTextInput;
import com.fusesource.zk.core.wizards.AbstractWizard;
import com.fusesource.zk.core.wizards.GridWizardPage;
import com.fusesource.zk.jmx.JmxActivator;
import com.fusesource.zk.jmx.runtime.JmxConnectionDescriptorFiles;
import com.fusesource.zk.jmx.wizards.newjmxconnection.JmxConnectionNewWizard;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import javax.management.remote.JMXServiceURL;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class JmxConnectionNewWizardPage1
extends GridWizardPage {
    public static final String CONTROL_NAME_NAME_TEXT = "Name";
    public static final String CONTROL_NAME_JMX_URL_TEXT = "JMX URL";
    public static final String CONTROL_NAME_USER_NAME_TEXT = "User Name";
    public static final String CONTROL_NAME_PASSWORD_TEXT = "Password";
    private final Set<String> _JmxConnectionNames;

    public JmxConnectionNewWizardPage1(JmxConnectionNewWizard wizard) {
        super((AbstractWizard)wizard);
        JmxConnectionDescriptorFiles files = JmxActivator.getDefault().getJmxConnectionDescriptorFiles();
        this._JmxConnectionNames = new HashSet<String>(files.getNames());
    }

    public String getConnectionName() {
        Text nameText = (Text)this.getGridComposite().getControl(CONTROL_NAME_NAME_TEXT);
        String name = nameText.getText().trim();
        return name;
    }

    public JMXServiceURL getServiceUrl() {
        Text jmxUrlText = (Text)this.getGridComposite().getControl(CONTROL_NAME_JMX_URL_TEXT);
        String jmxServiceUrlString = jmxUrlText.getText();
        try {
            return new JMXServiceURL(jmxServiceUrlString);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getUserName() {
        Text userNameText = (Text)this.getGridComposite().getControl(CONTROL_NAME_USER_NAME_TEXT);
        String userName = userNameText.getText().trim();
        if (userName.isEmpty()) {
            return null;
        }
        return userName;
    }

    public String getPassword() {
        Text passwordText = (Text)this.getGridComposite().getControl(CONTROL_NAME_PASSWORD_TEXT);
        String password = passwordText.getText();
        if (password.isEmpty()) {
            return null;
        }
        return password;
    }

    protected GridComposite createGridComposite(Composite parent) {
        GridComposite gridComposite = new GridComposite(parent){

            protected void createContents() {
                GridTextInput nameGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, JmxConnectionNewWizardPage1.CONTROL_NAME_NAME_TEXT, "&Name:", "My JMX Connection");
                this.addGridTextInput(nameGridTextInput);
                Text nameText = nameGridTextInput.getText();
                nameText.selectAll();
                nameText.setTextLimit(100);
                GridTextInput jmxUrlGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.VALUE_REQUIRED, JmxConnectionNewWizardPage1.CONTROL_NAME_JMX_URL_TEXT, "&Service URL:", null);
                this.addGridTextInput(jmxUrlGridTextInput);
                GridTextInput userNameGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.DEFAULT, JmxConnectionNewWizardPage1.CONTROL_NAME_USER_NAME_TEXT, "&User Name:", null);
                this.addGridTextInput(userNameGridTextInput);
                GridTextInput passwordGridTextInput = new GridTextInput((Composite)this, GridTextInput.Type.DEFAULT, JmxConnectionNewWizardPage1.CONTROL_NAME_PASSWORD_TEXT, "&Password:           ", null);
                this.addGridTextInput(passwordGridTextInput);
                passwordGridTextInput.getText().setEchoChar('*');
                Label passwordLabel = new Label((Composite)this, 16448);
                passwordLabel.setText("NOTE:  Password will be stored unencrypted in a file.");
                passwordLabel.setLayoutData((Object)new GridData(1, 1, false, false, 2, 1));
            }

            protected GridCompositeStatus updateStatus(Object source) {
                GridCompositeStatus status = super.updateStatus(source);
                if (status.getType().isError()) {
                    return status;
                }
                if (source instanceof GridTextInput) {
                    GridTextInput gridTextInput = (GridTextInput)source;
                    if (gridTextInput.getName().equals(JmxConnectionNewWizardPage1.CONTROL_NAME_NAME_TEXT)) {
                        Text nameText = gridTextInput.getText();
                        String name = nameText.getText();
                        if (JmxConnectionNewWizardPage1.this._JmxConnectionNames.contains(name)) {
                            String message = "Name must be unique.";
                            return new GridCompositeStatus(JmxConnectionNewWizardPage1.CONTROL_NAME_NAME_TEXT, message, GridCompositeStatus.Type.ERROR_INVALID);
                        }
                    } else if (gridTextInput.getName().equals(JmxConnectionNewWizardPage1.CONTROL_NAME_JMX_URL_TEXT)) {
                        String jmxUrlString = gridTextInput.getText().getText().trim();
                        try {
                            new JMXServiceURL(jmxUrlString);
                        }
                        catch (MalformedURLException e) {
                            String message = e.getMessage();
                            return new GridCompositeStatus(JmxConnectionNewWizardPage1.CONTROL_NAME_JMX_URL_TEXT, message, GridCompositeStatus.Type.ERROR_INVALID);
                        }
                    }
                }
                return GridCompositeStatus.OK_STATUS;
            }
        };
        return gridComposite;
    }
}

