/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.util;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FormatNumberPattern;

public class FormatPercentNumPattern
extends FormatNumberPattern {
    private int decPlaces = 0;
    private boolean useSep = false;
    private boolean useBracket = false;
    private String symPos = "";

    public static String getDefaultSymbolPosition(ULocale locale) {
        NumberFormat formater;
        String result;
        if (locale == null) {
            locale = ULocale.getDefault();
        }
        if ((result = (formater = NumberFormat.getPercentInstance((ULocale)locale)).format(1L)).endsWith("%")) {
            return FormatNumberPattern.SYMBOL_POSITION_AFTER;
        }
        return FormatNumberPattern.SYMBOL_POSITION_BEFORE;
    }

    public FormatPercentNumPattern(String category) {
        super(category);
        this.setType('P');
    }

    public String getPattern() {
        String numStr = "###0";
        String decStr = "";
        String positivePatt = numStr;
        String negativePatt = null;
        if (this.useSep) {
            positivePatt = "#,##0";
        }
        if ((decStr = DEUtil.getDecmalStr(this.decPlaces)) != "") {
            positivePatt = String.valueOf(positivePatt) + "." + decStr;
        }
        if (this.useBracket) {
            negativePatt = "(" + positivePatt + ")";
        }
        if (this.symPos.equalsIgnoreCase(FormatNumberPattern.SYMBOL_POSITION_BEFORE)) {
            positivePatt = "%" + positivePatt;
            if (negativePatt != null) {
                negativePatt = "%" + negativePatt;
            }
        } else if (this.symPos.equalsIgnoreCase(FormatNumberPattern.SYMBOL_POSITION_AFTER)) {
            positivePatt = String.valueOf(positivePatt) + "%";
            if (negativePatt != null) {
                negativePatt = String.valueOf(negativePatt) + "%";
            }
        }
        String pattern = negativePatt != null ? String.valueOf(positivePatt) + ";" + negativePatt : positivePatt;
        if ((pattern = this.applyRoundingMode(pattern)).equals(this.DEFAULT_PERCENT_PATTERN)) {
            return this.getCategory();
        }
        return pattern;
    }

    public void setPattern(String patternStr) {
        String patt = this.valPattern(patternStr);
        this.useSep = (patt = this.checkRoundingMode(patt)).indexOf(",") != -1;
        boolean bl = this.useBracket = patt.indexOf("(") != -1 && patt.indexOf(")") != -1;
        if (patt.indexOf(".") != -1) {
            this.decPlaces = patt.lastIndexOf("0") - patt.lastIndexOf(".");
        }
        if (patt.indexOf("%") != -1) {
            this.symPos = patt.indexOf("%") == 0 ? FormatNumberPattern.SYMBOL_POSITION_BEFORE : FormatNumberPattern.SYMBOL_POSITION_AFTER;
        }
    }

    protected String getDefaultPatt() {
        return this.DEFAULT_PERCENT_PATTERN;
    }

    public int getDecPlaces() {
        return this.decPlaces;
    }

    public void setDecPlaces(int decPlaces) {
        this.decPlaces = decPlaces;
    }

    public boolean getUseSep() {
        return this.useSep;
    }

    public void setUseSep(boolean useSep) {
        this.useSep = useSep;
    }

    public boolean getUseBracket() {
        return this.useBracket;
    }

    public void setUseBracket(boolean useBracket) {
        this.useBracket = useBracket;
    }

    public String getSymPos() {
        return this.symPos;
    }

    public void setSymPos(String symPos) {
        this.symPos = symPos;
    }

    public String getRoundingMode() {
        return this.rounding;
    }

    public void setRoundingMode(String mode) {
        this.rounding = mode;
    }
}

