/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.dataset;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetBasePageHelper;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetTypeElement;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetTypesProvider;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSourceType;
import org.eclipse.birt.report.designer.data.ui.dataset.OdaDataSetTypeElement;
import org.eclipse.birt.report.designer.data.ui.dataset.WizardFilter;
import org.eclipse.birt.report.designer.data.ui.util.DTPUtil;
import org.eclipse.birt.report.designer.data.ui.util.DataSetProvider;
import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.odadatasource.wizards.AbstractDataSetWizard;
import org.eclipse.birt.report.model.adapter.oda.ModelOdaAdapter;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSourceHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DataSetDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class DataSetBasePage
extends WizardPage {
    private transient Text nameEditor = null;
    private transient ComboViewer dataSetTypeChooser = null;
    private transient boolean useTransaction = true;
    private static final String EMPTY_NAME = Messages.getString((String)"error.DataSet.emptyName");
    private static final String DUPLICATE_NAME = Messages.getString((String)"error.duplicateName");
    private static final String CREATE_PROMPT = Messages.getString((String)"dataset.message.create");
    private transient DataSourceHandle newDataSource = null;
    private Hashtable htDataSetWizards = new Hashtable(10);
    private static final String SCRIPT_DATASET_NAME = Messages.getString((String)"DataSetBasePage.ScriptedDataSet.name");
    private static final String SCRIPT_DATASOURCE_NAME = Messages.getString((String)"DataSetBasePage.ScriptedDataSource.name");
    private ISelection dateSetTypeSelection = null;
    private transient DataSetDesignSession m_designSession = null;
    private boolean useODAV3 = false;
    private WizardFilter wizardFilter = null;
    private FilteredTree dataSourceFilteredTree;
    private DataSetBasePageHelper helper;
    private IWizardPage nextPage;

    public DataSetBasePage(boolean useTransaction) {
        super("DataSet Base Page");
        this.setTitle(Messages.getString((String)"dataset.new"));
        this.setMessage(Messages.getString((String)"AbstractDataSetWizard.ModelTrans.Create"));
        this.useTransaction = useTransaction;
        this.setImage();
    }

    private void setImage() {
        URL url = null;
        try {
            url = new URL(ReportPlugin.getDefault().getBundle().getEntry("/"), "icons/wizban/dataset_wizard.gif");
        }
        catch (MalformedURLException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL(url);
        this.setImageDescriptor(desc);
    }

    public void createControl(Composite parent) {
        this.helper = new DataSetBasePageHelper();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.getString((String)"DataSetBasePage.Group.DataSourceSelection"));
        group.setLayoutData((Object)new GridData(4, 4, true, true, 1, 8));
        this.wizardFilter = new WizardFilter();
        this.dataSourceFilteredTree = new FilteredTree((Composite)group, 68352, (PatternFilter)this.wizardFilter, true);
        GridData treeData = new GridData(1808);
        treeData.grabExcessHorizontalSpace = true;
        treeData.grabExcessVerticalSpace = true;
        treeData.heightHint = 300;
        treeData.widthHint = 600;
        this.dataSourceFilteredTree.setLayoutData((Object)treeData);
        SelectionListener listener = new SelectionListener(){
            TreeItem parent = null;

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent event) {
                if (event.item.getData() instanceof DataSourceHandle) {
                    DataSetBasePage.this.dataSetTypeChooser.getCombo().setEnabled(true);
                    if (this.parent == null || this.parent != ((TreeItem)event.item).getParentItem()) {
                        this.parent = ((TreeItem)event.item).getParentItem();
                        DataSetBasePage.this.doDataSourceSelectionChanged(this.parent.getData());
                    }
                    DataSetBasePage.this.setPageComplete(!DataSetBasePage.this.hasWizard() && DataSetBasePage.this.getMessageType() != 3);
                } else {
                    DataSetBasePage.this.dataSetTypeChooser.getCombo().clearSelection();
                    DataSetBasePage.this.dataSetTypeChooser.getCombo().setEnabled(false);
                    DataSetBasePage.this.setPageComplete(false);
                }
            }
        };
        this.dataSourceFilteredTree.getViewer().getTree().addSelectionListener(listener);
        this.createDataSetTypeViewer(composite);
        this.setDataSourceTreeViewer();
        this.setPageStatus();
        new Label(composite, 131072).setText(Messages.getString((String)"dataset.wizard.label.datasetName"));
        this.nameEditor = new Text(composite, 2048);
        String name = ReportPlugin.getDefault().getCustomName("DataSet");
        if (name != null) {
            this.nameEditor.setText(Utility.getUniqueDataSetName((String)name));
        } else {
            this.nameEditor.setText(Utility.getUniqueDataSetName((String)Messages.getString((String)"dataset.new.defaultName")));
        }
        this.nameEditor.setLayoutData((Object)new GridData(768));
        this.nameEditor.setToolTipText(Messages.getString((String)"DataSetBasePage.tooltip"));
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (StringUtil.isBlank((String)DataSetBasePage.this.nameEditor.getText().trim())) {
                    DataSetBasePage.this.setMessage(EMPTY_NAME, 3);
                } else if (DataSetBasePage.this.isDuplicateName()) {
                    DataSetBasePage.this.setMessage(DUPLICATE_NAME, 3);
                } else if (DataSetBasePage.this.containInvalidCharactor(DataSetBasePage.this.nameEditor.getText())) {
                    String msg = Messages.getFormattedString((String)"error.invalidName", (Object[])new Object[]{DataSetBasePage.this.nameEditor.getText()});
                    DataSetBasePage.this.setMessage(msg, 3);
                } else {
                    DataSetBasePage.this.setMessage(CREATE_PROMPT);
                }
                DataSetBasePage.this.setPageComplete(!DataSetBasePage.this.hasWizard() && DataSetBasePage.this.getMessageType() != 3 && DataSetBasePage.this.getSelectedDataSource() != null);
            }
        });
        this.setControl((Control)composite);
        Utility.setSystemHelp((Control)this.getControl(), (String)"org.eclipse.birt.cshelp.Wizard_Dataset_ID");
    }

    private void setDataSourceTreeViewer() {
        this.dataSourceFilteredTree.getViewer().setContentProvider((IContentProvider)new ITreeContentProvider(){
            DataSourceType[] types = null;

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                this.types = new DataSourceType[((Collection)inputElement).size()];
                Iterator iter = ((Collection)inputElement).iterator();
                int i = 0;
                while (iter.hasNext()) {
                    this.types[i] = (DataSourceType)iter.next();
                    ++i;
                }
                return this.types;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof DataSourceType) {
                    return ((DataSourceType)parentElement).getDataSourceList().toArray();
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (this.types != null) {
                    int i = 0;
                    while (i < this.types.length) {
                        if (this.types[i].getDataSourceList().contains(element)) {
                            return this.types[i];
                        }
                        ++i;
                    }
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                if (element instanceof DataSourceType) {
                    return true;
                }
                if (element instanceof DataSourceHandle) {
                    return false;
                }
                return false;
            }
        });
        this.dataSourceFilteredTree.getViewer().setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof DataSourceType) {
                    return ((DataSourceType)element).getDataSourceDisplayName();
                }
                if (element instanceof DataSourceHandle) {
                    return ((DataSourceHandle)element).getName();
                }
                return element.toString();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.dataSourceFilteredTree.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataSetBasePage.this.setPageStatus();
            }
        });
        this.dataSourceFilteredTree.getViewer().setComparator(new ViewerComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        }));
        Map sourceMap = this.getDataSourceMap();
        this.dataSourceFilteredTree.getViewer().setInput(sourceMap.values());
        this.dataSourceFilteredTree.getViewer().expandAll();
        if (this.dataSourceFilteredTree.getViewer().getTree().getItems().length > 0) {
            this.dataSourceFilteredTree.getViewer().getTree().select(this.dataSourceFilteredTree.getViewer().getTree().getItem(0).getItem(0));
            this.doDataSourceSelectionChanged(this.dataSourceFilteredTree.getViewer().getTree().getItem(0).getData());
            this.dataSetTypeChooser.getCombo().setEnabled(true);
        }
        this.setPageComplete(!this.hasWizard() && this.getMessageType() != 3);
    }

    private void setPageStatus() {
        if (this.dataSourceFilteredTree == null || this.dataSourceFilteredTree.getViewer().getTree().getSelectionCount() <= 0) {
            this.setPageComplete(false);
        }
    }

    private Map getDataSourceMap() {
        List dataSources = Utility.getDataSources();
        HashMap<String, DataSourceType> sourceTypeMap = new HashMap<String, DataSourceType>();
        int i = 0;
        while (i < dataSources.size()) {
            DataSourceHandle handle = (DataSourceHandle)dataSources.get(i);
            if (handle instanceof OdaDataSourceHandle) {
                String type = ((OdaDataSourceHandle)handle).getExtensionID();
                if (!sourceTypeMap.containsKey(type)) {
                    try {
                        ExtensionManifest extMF = ManifestExplorer.getInstance().getExtensionManifest(type);
                        if (extMF != null) {
                            DataSetType[] dataSetTypes = extMF.getDataSetTypes();
                            DataSetTypeElement[] element = new OdaDataSetTypeElement[dataSetTypes.length];
                            int n = 0;
                            while (n < dataSetTypes.length) {
                                if (!dataSetTypes[n].isDeprecated()) {
                                    element[n] = new OdaDataSetTypeElement(dataSetTypes[n], DataSetProvider.findDataSetElement((String)dataSetTypes[n].getID(), (String)type));
                                }
                                ++n;
                            }
                            DataSourceType dataSourceType = new DataSourceType(type, extMF.getDataSourceDisplayName(), element);
                            sourceTypeMap.put(type, dataSourceType);
                            dataSourceType.addDataSource(handle);
                        }
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle((Throwable)ex);
                    }
                } else {
                    DataSourceType sourceType = (DataSourceType)sourceTypeMap.get(type);
                    sourceType.addDataSource(handle);
                }
            } else if (handle instanceof ScriptDataSourceHandle) {
                this.useODAV3 = false;
                if (!sourceTypeMap.containsKey(SCRIPT_DATASOURCE_NAME)) {
                    DataSetTypeElement[] element = new DataSetTypeElement[]{new DataSetTypeElement(SCRIPT_DATASET_NAME)};
                    DataSourceType dataSourceType = new DataSourceType(SCRIPT_DATASOURCE_NAME, SCRIPT_DATASOURCE_NAME, element);
                    sourceTypeMap.put(SCRIPT_DATASOURCE_NAME, dataSourceType);
                    dataSourceType.addDataSource(handle);
                } else {
                    DataSourceType sourceType = (DataSourceType)sourceTypeMap.get(SCRIPT_DATASOURCE_NAME);
                    sourceType.addDataSource(handle);
                }
            } else {
                this.useODAV3 = false;
                this.helper.addExternalDataSource(sourceTypeMap, handle);
            }
            ++i;
        }
        return sourceTypeMap;
    }

    private void createDataSetTypeViewer(Composite composite) {
        new Label(composite, 131072).setText(Messages.getString((String)"dataset.wizard.label.datasetType"));
        this.dataSetTypeChooser = new ComboViewer(composite, 12);
        this.dataSetTypeChooser.getControl().setLayoutData((Object)new GridData(768));
        DataSetTypesProvider dataSetTypes = new DataSetTypesProvider();
        this.dataSetTypeChooser.setContentProvider((IContentProvider)dataSetTypes);
        this.dataSetTypeChooser.setLabelProvider((IBaseLabelProvider)dataSetTypes);
        this.dataSetTypeChooser.getCombo().setEnabled(false);
    }

    private boolean isDuplicateName() {
        String name = this.nameEditor.getText().trim();
        return Utility.checkDataSetName((String)name);
    }

    private String getDataSetName() {
        return this.nameEditor.getText();
    }

    private boolean containInvalidCharactor(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(".") > -1 || name.indexOf("\\") > -1 || name.indexOf("/") > -1 || name.indexOf("!") > -1 || name.indexOf(";") > -1 || name.indexOf(",") > -1;
    }

    protected final DataSourceHandle getSelectedDataSource() {
        if (((IStructuredSelection)this.dataSourceFilteredTree.getViewer().getSelection()).getFirstElement() instanceof DataSourceHandle) {
            return (DataSourceHandle)((IStructuredSelection)this.dataSourceFilteredTree.getViewer().getSelection()).getFirstElement();
        }
        return null;
    }

    final DataSourceHandle getNewDataSource() {
        return this.newDataSource;
    }

    final void setNewDataSource(DataSourceHandle newDataSourceHandle) {
        this.newDataSource = newDataSourceHandle;
    }

    public IWizardPage getNextPage() {
        this.setPageComplete(true);
        if (((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement() instanceof DataSetTypeElement) {
            if (this.useODAV3) {
                this.nextPage = this.getNextPageODAV3();
                return this.nextPage;
            }
            this.nextPage = this.getNextPageODAV2();
            return this.nextPage;
        }
        return super.getNextPage();
    }

    private IWizardPage getNextPageODAV3() {
        DataSourceDesign dataSourceDesign = new ModelOdaAdapter().createDataSourceDesign((OdaDataSourceHandle)this.getSelectedDataSource());
        OdaDataSetTypeElement dataSetElement = (OdaDataSetTypeElement)this.getSelectedDataSet();
        String dataSetID = dataSetElement.getDataSetType().getID();
        try {
            DTPUtil.getInstance().supplementDesignAttributes(dataSourceDesign);
            if (this.m_designSession == null) {
                this.m_designSession = DataSetDesignSession.startNewDesign((String)this.nameEditor.getText().trim(), (String)dataSetID, (DataSourceDesign)dataSourceDesign);
            } else {
                this.m_designSession.restartNewDesign(this.nameEditor.getText().trim(), dataSetID, dataSourceDesign);
            }
            return this.m_designSession.getWizardStartingPage();
        }
        catch (OdaException odaException) {
            return null;
        }
        catch (URISyntaxException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public boolean canFinish() {
        if (!this.validStatus()) {
            return false;
        }
        try {
            if (this.m_designSession != null) {
                return this.m_designSession.getNewWizard().canFinish();
            }
            if (this.nextPage != null) {
                return this.nextPage.isPageComplete();
            }
            return this.isPageComplete();
        }
        catch (OdaException odaException) {
            return false;
        }
    }

    private IWizardPage getNextPageODAV2() {
        DataSetTypeElement dataSetElement = (DataSetTypeElement)((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement();
        if (this.m_designSession != null) {
            this.m_designSession = null;
        }
        if (dataSetElement instanceof OdaDataSetTypeElement) {
            IConfigurationElement[] elements;
            OdaDataSetTypeElement dElement = (OdaDataSetTypeElement)dataSetElement;
            IConfigurationElement element = dElement.getIConfigurationElement();
            AbstractDataSetWizard newWizard = (AbstractDataSetWizard)this.htDataSetWizards.get(element.getAttribute("id"));
            if (newWizard == null && (elements = element.getChildren("newDataSetWizard")).length > 0) {
                try {
                    Object wizard = elements[0].createExecutableExtension("class");
                    if (wizard instanceof AbstractDataSetWizard) {
                        newWizard = (AbstractDataSetWizard)wizard;
                        newWizard.setConfigurationElement(element);
                        newWizard.addPages();
                        newWizard.setUseTransaction(this.useTransaction);
                        this.htDataSetWizards.put(element.getAttribute("id"), newWizard);
                    }
                }
                catch (CoreException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
            if (newWizard != null) {
                newWizard.setDataSource(this.getSelectedDataSource());
                newWizard.setDataSetName(this.nameEditor.getText().trim());
                if (newWizard.getDataSet() != null) {
                    try {
                        newWizard.getDataSet().setDataSource(newWizard.getDataSource().getName());
                        newWizard.getDataSet().setName(newWizard.getDataSetName());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle((Throwable)e);
                    }
                }
                return newWizard.getStartingPage();
            }
        } else {
            IWizardPage page = this.helper.getNextPage(this.getSelectedDataSource(), dataSetElement);
            if (page == null) {
                return super.getNextPage();
            }
            return page;
        }
        return super.getNextPage();
    }

    public boolean canFlipToNextPage() {
        return this.validStatus();
    }

    public boolean validStatus() {
        return this.getMessageType() != 3 && !StringUtil.isBlank((String)this.nameEditor.getText()) && this.getSelectedDataSource() != null && this.getSelectedDataSet() != null;
    }

    private void doDataSourceSelectionChanged(Object data) {
        if (data instanceof DataSourceType) {
            DataSetTypeElement[] types = ((DataSourceType)data).getDataSetTypes();
            this.dataSetTypeChooser.setInput((Object)types);
            this.dateSetTypeSelection = new StructuredSelection((Object)types[0]);
            this.dataSetTypeChooser.setSelection(this.dateSetTypeSelection);
            if (SCRIPT_DATASOURCE_NAME.equals(((DataSourceType)data).getDataSourceID())) {
                this.useODAV3 = false;
            } else {
                String type = ((DataSourceType)data).getDataSourceID();
                this.useODAV3 = DesignSessionUtil.hasValidOdaDesignUIExtension((String)type);
            }
        }
    }

    private Object getSelectedDataSet() {
        return ((IStructuredSelection)this.dataSetTypeChooser.getSelection()).getFirstElement();
    }

    private boolean hasWizard() {
        DataSetTypeElement dTypeElement = (DataSetTypeElement)this.getSelectedDataSet();
        if (dTypeElement == null) {
            return false;
        }
        if (dTypeElement instanceof OdaDataSetTypeElement) {
            IConfigurationElement element = ((OdaDataSetTypeElement)dTypeElement).getIConfigurationElement();
            if (element != null) {
                AbstractDataSetWizard newWizard = (AbstractDataSetWizard)this.htDataSetWizards.get(element.getAttribute("id"));
                if (newWizard != null) {
                    return true;
                }
                IConfigurationElement[] v3elements = element.getChildren("dataSetWizard");
                IConfigurationElement[] v2elements = element.getChildren("newDataSetWizard");
                if (v3elements.length > 0 || v2elements.length > 0) {
                    return true;
                }
            }
        } else {
            if (SCRIPT_DATASET_NAME.equals(dTypeElement.getDataSetTypeName())) {
                return true;
            }
            return this.helper.hasWizard(this.getSelectedDataSource());
        }
        return false;
    }

    DataSetHandle createSelectedDataSet() {
        DataSetHandle dataSetHandle = null;
        try {
            dataSetHandle = this.useODAV3 ? this.createDataSetODAV3() : this.createDataSetODAV2();
            if (this.nameEditor != null && !this.nameEditor.isDisposed()) {
                dataSetHandle.setName(this.nameEditor.getText());
            }
            return dataSetHandle;
        }
        catch (SemanticException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (IllegalStateException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        catch (OdaException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private DataSetHandle createDataSetODAV3() throws OdaException, SemanticException, IllegalStateException {
        ModuleHandle parentHandle = Utility.getReportModuleHandle();
        OdaDataSetHandle dataSetHandle = DTPUtil.getInstance().createOdaDataSetHandle(this.m_designSession.finish().getResponse(), parentHandle);
        this.m_designSession = null;
        return dataSetHandle;
    }

    private DataSetHandle createDataSetODAV2() throws SemanticException {
        String dataSetTypeName = null;
        if (this.getSelectedDataSet() instanceof Object[]) {
            DataSetType dataSetElement = (DataSetType)((Object[])this.getSelectedDataSet())[0];
            dataSetTypeName = dataSetElement.getID();
        } else if (this.getSelectedDataSet() instanceof DataSetTypeElement) {
            dataSetTypeName = ((DataSetTypeElement)this.getSelectedDataSet()).getDataSetTypeName();
        }
        return this.createDataSet(dataSetTypeName);
    }

    private DataSetHandle createDataSet(String dataSetType) throws SemanticException {
        DataSourceHandle source = this.getSelectedDataSource();
        if (source instanceof OdaDataSourceHandle) {
            OdaDataSetHandle dsHandle = Utility.newOdaDataSet((String)this.getDataSetName().trim(), (String)dataSetType);
            dsHandle.setDataSource(source.getQualifiedName());
            dsHandle.setQueryText("");
            return dsHandle;
        }
        if (source instanceof ScriptDataSourceHandle) {
            ScriptDataSetHandle dsHandle = Utility.newScriptDataSet((String)this.getDataSetName());
            dsHandle.setDataSource(source.getName());
            return dsHandle;
        }
        return this.helper.createDataSet(this.getDataSetName().trim(), dataSetType);
    }
}

