/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportElementDragTracker;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;

public abstract class AbstractGuideHandle
extends AbstractHandle
implements MouseMotionListener {
    private boolean isInGuideHandle = false;
    private boolean canDeleteGuide = true;

    public AbstractGuideHandle(GraphicalEditPart owner, Locator loc) {
        super(owner, loc);
        this.addMouseMotionListener(this);
        this.getLocator().relocate((IFigure)this);
    }

    public void mouseEntered(MouseEvent me) {
        this.isInGuideHandle = true;
        this.getReportElementEditPart().addGuideFeedBack();
    }

    public void mouseExited(MouseEvent me) {
        this.isInGuideHandle = false;
        this.getReportElementEditPart().delayRemoveGuideFeedBack();
    }

    public void mouseHover(MouseEvent me) {
        this.isInGuideHandle = true;
        this.getReportElementEditPart().addGuideFeedBack();
    }

    public void mouseMoved(MouseEvent me) {
        this.isInGuideHandle = true;
    }

    public void mouseDragged(MouseEvent me) {
    }

    protected DragTracker createDragTracker() {
        return new ReportElementDragTracker((EditPart)this.getOwner());
    }

    protected ReportElementEditPart getReportElementEditPart() {
        return (ReportElementEditPart)this.getOwner();
    }

    public boolean isInGuideHandle() {
        return this.isInGuideHandle;
    }

    public IFigure findFigureAt(int x, int y, TreeSearch search) {
        return super.findFigureAt(x, y, search);
    }

    public boolean isCanDeleteGuide() {
        return this.canDeleteGuide;
    }

    public void setCanDeleteGuide(boolean canDeleteGuide) {
        this.canDeleteGuide = canDeleteGuide;
    }
}

