/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.core;

import com.fusesource.ide.jvmmonitor.core.Activator;
import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IAgentLoadHandler;
import com.fusesource.ide.jvmmonitor.core.IHeapDumpHandler;
import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.IJvmAttachHandler;
import com.fusesource.ide.jvmmonitor.core.IJvmModelChangeListener;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.core.Messages;
import com.fusesource.ide.jvmmonitor.internal.core.ActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.core.Host;
import com.fusesource.ide.jvmmonitor.internal.core.Util;
import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class JvmModel {
    private static final String JVM_ATTACH_HANDLER_EXTENSION_ID = "com.fusesource.ide.jvmmonitor.core.jvmAttachHandler";
    private static final String HEAP_DUMP_HANDLER_EXTENSION_ID = "com.fusesource.ide.jvmmonitor.core.heapDumpHandler";
    private static final String AGENT_LOAD_HANDLER_EXTENSION_ID = "com.fusesource.ide.jvmmonitor.core.agentLoadHandler";
    private static final String CLASS = "class";
    private static final String HANDLER = "handler";
    private static JvmModel jvmModel;
    private List<IHost> hosts = new CopyOnWriteArrayList<IHost>();
    private List<IJvmModelChangeListener> listeners = new CopyOnWriteArrayList<IJvmModelChangeListener>();
    private IJvmAttachHandler jvmAttachHandler;
    private IHeapDumpHandler heapDumpHandler;
    private IAgentLoadHandler agentLoadHandler;

    private JvmModel() {
        try {
            this.jvmAttachHandler = (IJvmAttachHandler)this.loadHandler(JVM_ATTACH_HANDLER_EXTENSION_ID);
            this.heapDumpHandler = (IHeapDumpHandler)this.loadHandler(HEAP_DUMP_HANDLER_EXTENSION_ID);
            this.agentLoadHandler = (IAgentLoadHandler)this.loadHandler(AGENT_LOAD_HANDLER_EXTENSION_ID);
        }
        catch (CoreException e) {
            Activator.log(4, e.getMessage(), e);
        }
        this.restoreHosts();
    }

    public static synchronized JvmModel getInstance() {
        if (jvmModel == null) {
            jvmModel = new JvmModel();
        }
        return jvmModel;
    }

    public IHeapDumpHandler getHeapDumpHandler() {
        return this.heapDumpHandler;
    }

    public IAgentLoadHandler getAgentLoadHandler() {
        return this.agentLoadHandler;
    }

    public List<IHost> getHosts() {
        return this.hosts;
    }

    public IHost getHost(String hostname) {
        for (IHost host : this.hosts) {
            if (!host.getName().equals(hostname)) continue;
            return host;
        }
        return null;
    }

    public IHost addHost(String hostname) {
        IHost host = this.getHost(hostname);
        if (host != null) {
            return host;
        }
        host = new Host(hostname);
        this.hosts.add(host);
        this.fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.HostAdded, null));
        return host;
    }

    public IActiveJvm addHostAndJvm(String url, String userName, String password, int updatePeriod) throws JvmCoreException {
        ActiveJvm jvm = new ActiveJvm(url, userName, password, updatePeriod);
        IHost host = jvm.getHost();
        if (host == null) {
            return jvm;
        }
        if (!this.hosts.contains(host)) {
            this.hosts.add(host);
            this.fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.HostAdded, null));
        }
        return jvm;
    }

    public void removeHost(IHost host) {
        this.hosts.remove(host);
        try {
            IPath hostDir = ((Host)host).getHostDir();
            Util.deleteDir(hostDir.toFile());
        }
        catch (JvmCoreException e) {
            Activator.log(4, NLS.bind((String)Messages.removeHostFailedMsg, (Object)host.getName()), (Throwable)((Object)e));
        }
        this.fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.HostRemoved, null));
    }

    public void addJvmModelChangeListener(IJvmModelChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeJvmModelChangeListener(IJvmModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    public List<IJvmModelChangeListener> getJvmModelChangeListeners() {
        return this.listeners;
    }

    public boolean hasValidJdk() {
        return this.jvmAttachHandler.hasValidJdk();
    }

    public void fireJvmModelChangeEvent(JvmModelEvent e) {
        for (IJvmModelChangeListener listener : this.listeners) {
            listener.jvmModelChanged(e);
        }
    }

    private void restoreHosts() {
        IPath baseDir;
        File[] files;
        IHost localhost = this.addHost("localhost");
        if (this.jvmAttachHandler != null) {
            this.jvmAttachHandler.setHost(localhost);
        }
        if ((files = (baseDir = Activator.getDefault().getStateLocation()).toFile().listFiles()) == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String hostDir;
            File dir = fileArray[n2];
            if (dir.isDirectory() && (hostDir = dir.getName()).endsWith(".host")) {
                IPath filePath = baseDir.append(String.valueOf(File.separator) + hostDir + File.separator + "properties.xml");
                if (!filePath.toFile().exists()) {
                    Util.deleteDir(dir);
                } else {
                    Properties props = Util.loadProperties(filePath);
                    if (props == null) {
                        Util.deleteDir(dir);
                    } else {
                        String hostname = props.getProperty("Host");
                        if (hostname != null) {
                            this.addHost(hostname);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    private Object loadHandler(String extensionPoint) throws CoreException {
        IExtension[] extensions;
        IExtension[] iExtensionArray = extensions = Platform.getExtensionRegistry().getExtensionPoint(extensionPoint).getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals(HANDLER)) {
                    return element.createExecutableExtension(CLASS);
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }
}

