/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core;

import com.fusesource.ide.jvmmonitor.core.Activator;
import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.IJvm;
import com.fusesource.ide.jvmmonitor.core.ISnapshot;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.JvmModel;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.internal.core.Messages;
import com.fusesource.ide.jvmmonitor.internal.core.Snapshot;
import com.fusesource.ide.jvmmonitor.internal.core.Util;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractJvm
implements IJvm {
    private int pid;
    private int port;
    private String userName;
    private String password;
    private String mainClass;
    private IHost host;
    protected List<ISnapshot> snapshots;

    public AbstractJvm(int pid, int port, String userName, String password, IHost host) {
        this.pid = pid;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.host = host;
        if (pid != -1) {
            this.refreshSnapshots();
        }
    }

    public AbstractJvm(int pid, IHost host) {
        this(pid, -1, null, null, host);
    }

    public AbstractJvm(int port, String userName, String password, IHost host) {
        this(-1, port, userName, password, host);
    }

    public AbstractJvm(String userName, String password) {
        this(-1, -1, userName, password, null);
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getMainClass() {
        if (this.mainClass == null) {
            return "";
        }
        return this.mainClass;
    }

    @Override
    public IHost getHost() {
        return this.host;
    }

    @Override
    public List<ISnapshot> getShapshots() {
        return this.snapshots;
    }

    @Override
    public void deleteSnapshot(ISnapshot snapshot) {
        this.snapshots.remove(snapshot);
        try {
            snapshot.getFileStore().delete(0, null);
        }
        catch (CoreException e) {
            Activator.log(4, NLS.bind((String)Messages.deleteFileFailedMsg, (Object)snapshot.getFileStore().getName()), e);
        }
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.ShapshotRemoved, this));
    }

    public void addSnapshot(ISnapshot snapshot) {
        this.snapshots.add(snapshot);
    }

    public IPath getBaseDirectory() throws JvmCoreException {
        IPath stateLocation = Activator.getDefault().getStateLocation();
        IPath dirPath = stateLocation.append(String.valueOf(File.separator) + this.host.getName() + ".host" + File.separator + this.pid + ".jvm");
        if (!dirPath.toFile().exists() && !dirPath.toFile().mkdir()) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.createDirectoryFailedMsg, (Object)dirPath.toFile().getName()), null);
        }
        return dirPath;
    }

    protected String getUserName() {
        return this.userName;
    }

    protected String getPassword() {
        return this.password;
    }

    protected void setPid(int pid) {
        this.pid = pid;
    }

    protected void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    protected void setHost(IHost host) {
        this.host = host;
    }

    protected void refreshSnapshots() {
        IPath baseDirectory;
        this.snapshots = new ArrayList<ISnapshot>();
        try {
            baseDirectory = this.getBaseDirectory();
        }
        catch (JvmCoreException jvmCoreException) {
            return;
        }
        File[] files = baseDirectory.toFile().listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String fileName = file.getName();
            if (Snapshot.isValidFile(fileName)) {
                Snapshot snapshot = new Snapshot(Util.getFileStore(fileName, baseDirectory), this);
                this.snapshots.add(snapshot);
            }
            ++n2;
        }
    }
}

