/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core;

import com.fusesource.ide.jvmmonitor.core.IHeapElement;

public class HeapElement
implements IHeapElement {
    private String className;
    private long size;
    private long count;
    private long baseSize;

    public HeapElement(String className, long size, long count, long baseSize) {
        this.className = className;
        this.size = size;
        this.count = count;
        this.baseSize = baseSize;
    }

    public HeapElement(String className, long size, long count) {
        this(className, size, count, 0L);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long getBaseSize() {
        return this.baseSize;
    }

    public void resetBaseSize() {
        this.baseSize = this.size;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.className).append('\t');
        buffer.append(this.size).append('\t');
        buffer.append(this.count);
        return buffer.toString();
    }

    public void setSizeAndCount(long size, long count) {
        this.size = size;
        this.count = count;
    }

    public void dump(StringBuffer buffer) {
        buffer.append("\t<class ");
        buffer.append("name=\"").append(this.className).append("\" ");
        buffer.append("size=\"").append(this.size).append("\" ");
        buffer.append("count=\"").append(this.count).append("\" ");
        buffer.append("baseSize=\"").append(this.baseSize).append("\"/>\n");
    }
}

