/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core;

import com.fusesource.ide.jvmmonitor.core.Activator;
import com.fusesource.ide.jvmmonitor.core.IActiveJvm;
import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.IJvm;
import com.fusesource.ide.jvmmonitor.core.ITerminatedJvm;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.JvmModel;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.internal.core.AbstractJvm;
import com.fusesource.ide.jvmmonitor.internal.core.ActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.core.Messages;
import com.fusesource.ide.jvmmonitor.internal.core.TerminatedJvm;
import com.fusesource.ide.jvmmonitor.internal.core.Util;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class Host
implements IHost {
    public static final String DIR_SUFFIX = ".host";
    public static final String PROPERTIES_FILE = "properties.xml";
    public static final String HOST_PROP_KEY = "Host";
    private String hostName;
    private List<ITerminatedJvm> terminatedJvms;
    private List<IActiveJvm> activeJvms;

    public Host(String hostname) {
        this.hostName = hostname;
        this.terminatedJvms = new CopyOnWriteArrayList<ITerminatedJvm>();
        this.activeJvms = new CopyOnWriteArrayList<IActiveJvm>();
        this.saveHostProperties();
        this.refreshSnapshots();
    }

    @Override
    public String getName() {
        return this.hostName;
    }

    @Override
    public List<IJvm> getJvms() {
        CopyOnWriteArrayList<IJvm> jvms = new CopyOnWriteArrayList<IJvm>();
        jvms.addAll(this.activeJvms);
        jvms.addAll(this.terminatedJvms);
        return jvms;
    }

    @Override
    public List<ITerminatedJvm> getTerminatedJvms() {
        return this.terminatedJvms;
    }

    @Override
    public List<IActiveJvm> getActiveJvms() {
        return this.activeJvms;
    }

    @Override
    public IActiveJvm addRemoteActiveJvm(int port, String userName, String password, int updatePeriod) throws JvmCoreException {
        IActiveJvm jvm2;
        for (IActiveJvm jvm2 : this.getActiveJvms()) {
            if (jvm2.getPort() != port) continue;
            return jvm2;
        }
        jvm2 = new ActiveJvm(port, userName, password, this, updatePeriod);
        return this.addActiveJvm(jvm2);
    }

    @Override
    public IActiveJvm addLocalActiveJvm(int pid, String mainClass, String url, String errorStateMessage) throws JvmCoreException {
        IActiveJvm jvm2;
        for (IActiveJvm jvm2 : this.getActiveJvms()) {
            if (jvm2.getPid() != pid) continue;
            return jvm2;
        }
        jvm2 = new ActiveJvm(pid, url, this);
        ((AbstractJvm)((Object)jvm2)).setMainClass(mainClass);
        ((ActiveJvm)jvm2).setErrorStateMessage(errorStateMessage);
        return this.addActiveJvm(jvm2);
    }

    @Override
    public void removeJvm(int pid) {
        IPath dirPath;
        int id;
        IPath hostDir = null;
        try {
            hostDir = this.getHostDir();
        }
        catch (JvmCoreException jvmCoreException) {
            Activator.log(4, NLS.bind((String)Messages.removeJvmFailedMsg, (Object)pid), (Throwable)((Object)jvmCoreException));
            return;
        }
        for (ITerminatedJvm iTerminatedJvm : this.terminatedJvms) {
            if (iTerminatedJvm.getPid() != pid) continue;
            this.terminatedJvms.remove(iTerminatedJvm);
            id = iTerminatedJvm.getPid() != -1 ? iTerminatedJvm.getPid() : iTerminatedJvm.getPort();
            dirPath = hostDir.append(String.valueOf(File.separator) + id + ".jvm");
            Util.deleteDir(dirPath.toFile());
            JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmRemoved, null));
            break;
        }
        for (IActiveJvm iActiveJvm : this.activeJvms) {
            if (iActiveJvm.getPid() != pid) continue;
            if (iActiveJvm.isConnected()) {
                iActiveJvm.disconnect();
            }
            if (iActiveJvm.getShapshots().size() > 0) {
                this.addTerminatedJvm(iActiveJvm.getPid(), -1, iActiveJvm.getMainClass());
            } else {
                id = iActiveJvm.getPid() != -1 ? iActiveJvm.getPid() : iActiveJvm.getPort();
                dirPath = hostDir.append(String.valueOf(File.separator) + id + ".jvm");
                Util.deleteDir(dirPath.toFile());
            }
            this.activeJvms.remove(iActiveJvm);
            JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmRemoved, null));
            break;
        }
    }

    @Override
    public boolean isLocalHost() {
        return "localhost".equals(this.hostName);
    }

    public String toString() {
        return this.hostName;
    }

    public IPath getHostDir() throws JvmCoreException {
        IPath hostDir = Activator.getDefault().getStateLocation().append(String.valueOf(File.separator) + this.hostName + DIR_SUFFIX);
        if (!hostDir.toFile().exists() && !hostDir.toFile().mkdir()) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.createDirectoryFailedMsg, (Object)hostDir.toFile().getName()), null);
        }
        return hostDir;
    }

    public ITerminatedJvm addTerminatedJvm(int pid, int port, String mainClass) {
        for (ITerminatedJvm jvm : this.terminatedJvms) {
            if (jvm.getPid() != pid) continue;
            return jvm;
        }
        TerminatedJvm terminatedJvm = new TerminatedJvm(pid, port, mainClass, (IHost)this);
        this.terminatedJvms.add(terminatedJvm);
        return terminatedJvm;
    }

    protected IActiveJvm addActiveJvm(IActiveJvm jvm) {
        for (IActiveJvm activeJvm : this.activeJvms) {
            if (activeJvm.getPid() != jvm.getPid()) continue;
            return jvm;
        }
        this.activeJvms.add(jvm);
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmAdded, jvm));
        return jvm;
    }

    private void refreshSnapshots() {
        IPath hostDir;
        try {
            hostDir = this.getHostDir();
        }
        catch (JvmCoreException jvmCoreException) {
            return;
        }
        File[] files = hostDir.toFile().listFiles();
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String jvmDir;
            File file = fileArray[n2];
            if (file.isDirectory() && (jvmDir = file.getName()).endsWith(".jvm")) {
                IPath filePath = hostDir.append(String.valueOf(File.separator) + jvmDir + File.separator + PROPERTIES_FILE);
                if (!filePath.toFile().exists() || file.list().length == 1) {
                    Util.deleteDir(file);
                } else {
                    Properties props = Util.loadProperties(filePath);
                    if (props == null) {
                        Util.deleteDir(file);
                    } else {
                        String host = props.getProperty(HOST_PROP_KEY);
                        if (!this.hostName.equals(host)) {
                            Util.deleteDir(file);
                        } else {
                            String pidString = props.getProperty("Pid");
                            int pid = pidString == null ? -1 : Integer.valueOf(pidString);
                            String portString = props.getProperty("Port");
                            int port = portString == null ? -1 : Integer.valueOf(portString);
                            String mainClass = props.getProperty("MainClass");
                            this.addTerminatedJvm(pid, port, mainClass);
                        }
                    }
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveHostProperties() {
        IPath hostDir;
        Properties props = new Properties();
        try {
            hostDir = this.getHostDir();
        }
        catch (JvmCoreException e) {
            Activator.log(4, Messages.savePropertiesFileFailedMsg, (Throwable)((Object)e));
            return;
        }
        IFileStore fileStore = Util.getFileStore(PROPERTIES_FILE, hostDir);
        OutputStream os = null;
        try {
            os = fileStore.openOutputStream(0, null);
            props.setProperty(HOST_PROP_KEY, this.hostName);
            props.storeToXML(os, "Host Properties");
        }
        catch (CoreException e) {
            Activator.log(4, NLS.bind((String)Messages.openOutputStreamFailedMsg, (Object)fileStore.toURI().getPath()), e);
            if (os == null) return;
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        catch (IOException e) {
            try {
                try {
                    fileStore.delete(0, null);
                }
                catch (CoreException coreException) {}
                Activator.log(4, NLS.bind((String)Messages.writePropertiesFileFailedMsg, (Object)fileStore.toURI().getPath()), e);
                if (os == null) return;
            }
            catch (Throwable throwable) {
                if (os == null) throw throwable;
                try {
                    os.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.close();
                return;
            }
            catch (IOException iOException) {}
            return;
        }
        if (os == null) return;
        try {
            os.close();
            return;
        }
        catch (IOException iOException) {}
    }
}

