/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core;

import com.fusesource.ide.jvmmonitor.core.Activator;
import com.fusesource.ide.jvmmonitor.core.IHeapDumpHandler;
import com.fusesource.ide.jvmmonitor.core.IHeapElement;
import com.fusesource.ide.jvmmonitor.core.IHost;
import com.fusesource.ide.jvmmonitor.core.ISnapshot;
import com.fusesource.ide.jvmmonitor.core.IThreadElement;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.JvmModel;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import com.fusesource.ide.jvmmonitor.core.mbean.IMBeanNotification;
import com.fusesource.ide.jvmmonitor.core.mbean.IMBeanServer;
import com.fusesource.ide.jvmmonitor.core.mbean.IMBeanServerChangeListener;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanAttribute;
import com.fusesource.ide.jvmmonitor.core.mbean.IMonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.core.mbean.MBeanServerEvent;
import com.fusesource.ide.jvmmonitor.internal.core.AbstractJvm;
import com.fusesource.ide.jvmmonitor.internal.core.ActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.core.HeapElement;
import com.fusesource.ide.jvmmonitor.internal.core.Host;
import com.fusesource.ide.jvmmonitor.internal.core.MBeanNotification;
import com.fusesource.ide.jvmmonitor.internal.core.Messages;
import com.fusesource.ide.jvmmonitor.internal.core.MonitoredMXBeanAttribute;
import com.fusesource.ide.jvmmonitor.internal.core.MonitoredMXBeanGroup;
import com.fusesource.ide.jvmmonitor.internal.core.Snapshot;
import com.fusesource.ide.jvmmonitor.internal.core.ThreadElement;
import com.fusesource.ide.jvmmonitor.internal.core.Util;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.CallTreeNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.CpuModel;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.MethodNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.ThreadNode;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Signature;
import org.eclipse.osgi.util.NLS;

public class MBeanServer
implements IMBeanServer {
    private static final String DATA_TRANSFER_MXBEAN_NAME = "com.fusesource.ide.jvmmonitor:type=Data Transfer";
    private MBeanServerConnection connection;
    private JMXConnector connector;
    private ActiveJvm jvm;
    private IMBeanNotification mBeanNotification;
    private List<IMonitoredMXBeanGroup> monitoredAttributeGroups;
    private long previousProcessCpuTime;
    private Map<Class, Object> mxBeans;
    private Map<String, HeapElement> heapListElements;
    private Map<String, ThreadElement> threadListElements;
    Timer timer;
    Timer samplingTimer;
    private Integer samplingPeriod;
    private long previousSamplingTime;
    private Map<Long, Long> previousThreadProcessCpuTime;
    private boolean isLive;
    private boolean isJvmReachable;
    private List<IMBeanServerChangeListener> listeners;
    private Map<String, StackTraceElement[]> previousStackTraces;
    private JMXServiceURL jmxUrl;

    protected MBeanServer(JMXServiceURL jmxUrl, ActiveJvm jvm) {
        this.jmxUrl = jmxUrl;
        this.jvm = jvm;
        this.mxBeans = new HashMap<Class, Object>();
        this.mBeanNotification = new MBeanNotification(jvm);
        this.previousThreadProcessCpuTime = new HashMap<Long, Long>();
        this.heapListElements = new LinkedHashMap<String, HeapElement>();
        this.threadListElements = new LinkedHashMap<String, ThreadElement>();
        this.isLive = true;
        this.isJvmReachable = false;
        this.listeners = new CopyOnWriteArrayList<IMBeanServerChangeListener>();
        this.previousSamplingTime = 0L;
        this.samplingPeriod = 50;
        this.previousStackTraces = new HashMap<String, StackTraceElement[]>();
        this.monitoredAttributeGroups = new CopyOnWriteArrayList<IMonitoredMXBeanGroup>();
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName) throws JvmCoreException {
        if (!this.checkReachability()) {
            return new HashSet<ObjectName>();
        }
        try {
            return this.connection.queryNames(objectName, null);
        }
        catch (IOException e) {
            throw new JvmCoreException(4, Messages.queryObjectNameFailedMsg, e);
        }
    }

    @Override
    public Object getAttribute(ObjectName objectName, String qualifiedAttributeName) throws JvmCoreException {
        Assert.isNotNull((Object)objectName);
        Assert.isNotNull((Object)qualifiedAttributeName);
        if (!this.checkReachability()) {
            return null;
        }
        String attributeName = qualifiedAttributeName;
        if (attributeName.contains(".")) {
            attributeName = attributeName.split("\\.")[0];
        }
        try {
            return this.connection.getAttribute(objectName, attributeName);
        }
        catch (JMException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getAttributeFailedMsg, (Object)attributeName), e);
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getAttributeFailedMsg, (Object)attributeName), e);
        }
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws JvmCoreException {
        Assert.isNotNull((Object)objectName);
        Assert.isNotNull((Object)attribute);
        if (!this.checkReachability()) {
            return;
        }
        try {
            this.connection.setAttribute(objectName, attribute);
        }
        catch (JMException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.setAttributeFailedMsg, (Object)attribute.getName()), e);
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.setAttributeFailedMsg, (Object)attribute.getName()), e);
        }
    }

    @Override
    public List<IMonitoredMXBeanGroup> getMonitoredAttributeGroups() {
        return this.monitoredAttributeGroups;
    }

    @Override
    public IMonitoredMXBeanGroup addMonitoredAttributeGroup(String name, IMonitoredMXBeanGroup.AxisUnit axisUnit) {
        IMonitoredMXBeanGroup group2;
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)((Object)axisUnit));
        for (IMonitoredMXBeanGroup group2 : this.monitoredAttributeGroups) {
            if (!group2.getName().equals(name)) continue;
            group2.setAxisUnit(axisUnit);
            group2.clearAttributes();
            return group2;
        }
        group2 = new MonitoredMXBeanGroup(this, name, axisUnit);
        this.monitoredAttributeGroups.add(group2);
        this.fireMBeanServerChangeEvent(new MBeanServerEvent(MBeanServerEvent.MBeanServerState.MonitoredAttributeGroupAdded, group2));
        return group2;
    }

    @Override
    public void removeMonitoredAttributeGroup(String name) {
        Assert.isNotNull((Object)name);
        IMonitoredMXBeanGroup targetGroup = null;
        for (IMonitoredMXBeanGroup group : this.monitoredAttributeGroups) {
            if (!group.getName().equals(name)) continue;
            targetGroup = group;
            break;
        }
        if (targetGroup != null) {
            this.monitoredAttributeGroups.remove(targetGroup);
            this.fireMBeanServerChangeEvent(new MBeanServerEvent(MBeanServerEvent.MBeanServerState.MonitoredAttributeGroupRemoved, targetGroup));
        }
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws JvmCoreException {
        Assert.isNotNull((Object)objectName);
        if (!this.checkReachability()) {
            return null;
        }
        try {
            return this.connection.getMBeanInfo(objectName);
        }
        catch (JMException e) {
            throw new JvmCoreException(4, Messages.getMBeanInfoFailedMsg, e);
        }
        catch (IOException e) {
            throw new JvmCoreException(4, Messages.getMBeanInfoFailedMsg, e);
        }
    }

    @Override
    public IMBeanNotification getMBeanNotification() {
        return this.mBeanNotification;
    }

    @Override
    public void runGarbageCollector() throws JvmCoreException {
        MemoryMXBean memoryMXBean;
        if (!this.checkReachability()) {
            return;
        }
        try {
            memoryMXBean = (MemoryMXBean)this.getMXBean(MemoryMXBean.class, "java.lang:type=Memory");
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getMBeanFailedMsg, (Object)"java.lang:type=Memory"), e);
        }
        if (memoryMXBean != null) {
            memoryMXBean.gc();
        }
    }

    @Override
    public Object invoke(ObjectName objectName, String method, Object[] params, String[] signatures) throws JvmCoreException {
        Assert.isNotNull((Object)objectName);
        Assert.isNotNull((Object)method);
        if (!this.checkReachability()) {
            return null;
        }
        try {
            return this.connection.invoke(objectName, method, params, signatures);
        }
        catch (JMException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.mBeanOperationFailedMsg, (Object)method), e);
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.mBeanOperationFailedMsg, (Object)method), e);
        }
    }

    @Override
    public String[] getThreadNames() throws JvmCoreException {
        IThreadElement[] threads = this.getThreadCache();
        ArrayList<String> threadNames = new ArrayList<String>();
        IThreadElement[] iThreadElementArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            IThreadElement thread = iThreadElementArray[n2];
            threadNames.add(thread.getThreadName());
            ++n2;
        }
        return threadNames.toArray(new String[0]);
    }

    @Override
    public JMXServiceURL getJmxUrl() {
        return this.jmxUrl;
    }

    @Override
    public MBeanServerConnection getConnection() {
        return this.connection;
    }

    @Override
    public JMXConnector getConnector() {
        return this.connector;
    }

    @Override
    public IThreadElement[] getThreadCache() {
        Collection<ThreadElement> values = this.threadListElements.values();
        return values.toArray(new IThreadElement[values.size()]);
    }

    @Override
    public void refreshThreadCache() throws JvmCoreException {
        ThreadMXBean threadMXBean;
        if (!this.checkReachability()) {
            return;
        }
        try {
            threadMXBean = (ThreadMXBean)this.getMXBean(ThreadMXBean.class, "java.lang:type=Threading");
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getMBeanFailedMsg, (Object)"java.lang:type=Threading"), e);
        }
        if (threadMXBean == null) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getMBeanFailedMsg, (Object)"java.lang:type=Threading"), null);
        }
        long[] ids = threadMXBean.findDeadlockedThreads();
        LinkedHashMap<String, ThreadElement> newThreadListElements = new LinkedHashMap<String, ThreadElement>();
        List<ThreadInfo> allThreads = Arrays.asList(threadMXBean.dumpAllThreads(true, false));
        Collections.reverse(allThreads);
        for (ThreadInfo threadInfo : allThreads) {
            String threadName = threadInfo.getThreadName();
            long threadId = threadInfo.getThreadId();
            if (threadInfo.getStackTrace().length == 0 || threadName.startsWith("RMI ") || threadName.startsWith("JMX ")) continue;
            boolean isDeadlocked = false;
            if (ids != null) {
                Arrays.sort(ids);
                if (Arrays.binarySearch(ids, threadId) >= 0) {
                    isDeadlocked = true;
                }
            }
            ThreadElement oldElement = this.threadListElements.get(threadName);
            long processCpuTime = threadMXBean.getThreadCpuTime(threadId);
            Long previousCpuTime = this.previousThreadProcessCpuTime.get(threadId);
            double cpuUsage = 0.0;
            this.previousThreadProcessCpuTime.put(threadId, processCpuTime);
            if (previousCpuTime != null) {
                cpuUsage = Math.min((double)(processCpuTime - previousCpuTime) / 1.0E7, 100.0);
            }
            this.previousThreadProcessCpuTime.put(threadId, processCpuTime);
            if (oldElement == null) {
                newThreadListElements.put(threadName, new ThreadElement(threadInfo, isDeadlocked, cpuUsage));
                continue;
            }
            oldElement.setThreadInfo(threadInfo);
            oldElement.setDeadlocked(isDeadlocked);
            oldElement.setCpuUsage(cpuUsage);
            newThreadListElements.put(threadName, oldElement);
        }
        this.threadListElements = newThreadListElements;
    }

    @Override
    public IHeapElement[] getHeapCache() {
        IHeapElement[] result = new IHeapElement[this.heapListElements.size()];
        int i = 0;
        Iterator<HeapElement> iterator = this.heapListElements.values().iterator();
        while (iterator.hasNext()) {
            result[i++] = iterator.next();
        }
        return result;
    }

    @Override
    public void refreshHeapCache() throws JvmCoreException {
        if (!this.checkReachability()) {
            return;
        }
        IHeapDumpHandler heapDumpHandler = JvmModel.getInstance().getHeapDumpHandler();
        if (heapDumpHandler != null) {
            String heap = heapDumpHandler.dumpHeap(this.jvm.getPid(), this.isLive);
            int maxNumberOfClasses = JvmModel.getInstance().getHeapDumpHandler().getMaxClassesNumber();
            this.parseHeap(heap, maxNumberOfClasses);
        }
    }

    @Override
    public void clearHeapDelta() {
        for (HeapElement element : this.heapListElements.values()) {
            element.resetBaseSize();
        }
    }

    @Override
    public IFileStore dumpHprof(String hprofFileName, boolean transfer, IProgressMonitor monitor) throws JvmCoreException {
        String fileName;
        if (!this.checkReachability()) {
            throw new JvmCoreException(2, Messages.jvmNotReachableMsg, null);
        }
        IFileStore fileStore = null;
        if (this.jvm.isRemote()) {
            fileName = hprofFileName;
        } else {
            fileStore = this.dump(ISnapshot.SnapshotType.Hprof, null, null);
            fileName = fileStore.toString();
        }
        if (monitor.isCanceled()) {
            return null;
        }
        ObjectName objectName = this.jvm.getMBeanServer().getObjectName("com.sun.management:type=HotSpotDiagnostic");
        this.invoke(objectName, "dumpHeap", new Object[]{fileName, Boolean.TRUE}, new String[]{String.class.getCanonicalName(), "boolean"});
        if (this.jvm.isRemote() && transfer) {
            fileStore = this.dump(ISnapshot.SnapshotType.Hprof, hprofFileName, monitor);
        }
        return fileStore;
    }

    @Override
    public IFileStore dumpHeap() throws JvmCoreException {
        return this.dump(ISnapshot.SnapshotType.Heap, null, null);
    }

    @Override
    public IFileStore dumpThreads() throws JvmCoreException {
        return this.dump(ISnapshot.SnapshotType.Thread, null, null);
    }

    @Override
    public void setUpdatePeriod(Integer updatePeriod) {
        this.startUpdateTimer(updatePeriod);
    }

    @Override
    public void addServerChangeListener(IMBeanServerChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeServerChangeListener(IMBeanServerChangeListener listener) {
        this.listeners.remove(listener);
    }

    public ObjectName getObjectName(String name) throws JvmCoreException {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getObjectNameFailedMsg, (Object)name), e);
        }
        catch (NullPointerException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getObjectNameFailedMsg, (Object)name), e);
        }
    }

    public void unregisterMBean(ObjectName objectName) {
        if (this.isJvmReachable) {
            try {
                this.connection.unregisterMBean(objectName);
            }
            catch (JMException jMException) {
            }
            catch (IOException iOException) {}
        }
    }

    public void resumeSampling() {
        if (this.samplingTimer != null) {
            this.samplingTimer.cancel();
        }
        this.samplingTimer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MBeanServer.this.sampleProfilingData();
                }
                catch (JvmCoreException e) {
                    Activator.log(4, e.getMessage(), (Throwable)((Object)e));
                    MBeanServer.this.suspendSampling();
                }
                catch (Throwable throwable) {
                    MBeanServer.this.suspendSampling();
                }
            }
        };
        this.samplingTimer.schedule(timerTask, 0L, (long)this.samplingPeriod.intValue());
    }

    public void suspendSampling() {
        if (this.samplingTimer != null) {
            this.samplingTimer.cancel();
            this.samplingTimer = null;
        }
    }

    public ICpuProfiler.ProfilerState getProfilerState() {
        return this.samplingTimer == null ? ICpuProfiler.ProfilerState.READY : ICpuProfiler.ProfilerState.RUNNING;
    }

    public Integer getSamplingPeriod() {
        return this.samplingPeriod;
    }

    public void setSamplingPeriod(Integer samplingPeriod) {
        this.samplingPeriod = samplingPeriod;
        if (this.jvm.getCpuProfiler().getState() == ICpuProfiler.ProfilerState.RUNNING && this.jvm.getCpuProfiler().getProfilerType() == ICpuProfiler.ProfilerType.SAMPLING) {
            this.resumeSampling();
        }
    }

    public String getJvmArguments() {
        List<String> arguments;
        if (!this.checkReachability()) {
            return "";
        }
        try {
            RuntimeMXBean runtimeMXBean = (RuntimeMXBean)this.getMXBean(RuntimeMXBean.class, "java.lang:type=Runtime");
            arguments = runtimeMXBean.getInputArguments();
        }
        catch (IOException e) {
            Activator.log(4, NLS.bind((String)Messages.getAttributeFailedMsg, (Object)"InputArguments"), e);
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String argument : arguments) {
            if (buffer.length() > 0) {
                buffer.append(" ");
            }
            buffer.append(argument);
        }
        return buffer.toString();
    }

    protected void addNotificationListener(ObjectName objectName, NotificationListener listener) throws JvmCoreException {
        if (this.isJvmReachable) {
            try {
                this.connection.addNotificationListener(objectName, listener, null, null);
            }
            catch (InstanceNotFoundException e) {
                throw new JvmCoreException(4, Messages.subscribeMBeanNotificationFailedMsg, e);
            }
            catch (IOException e) {
                throw new JvmCoreException(4, Messages.subscribeMBeanNotificationFailedMsg, e);
            }
        }
    }

    protected void removeNotificationListener(ObjectName objectName, NotificationListener listener) throws JvmCoreException {
        if (this.isJvmReachable) {
            try {
                this.connection.removeNotificationListener(objectName, listener);
            }
            catch (JMException e) {
                throw new JvmCoreException(4, Messages.unsubscribeMBeanNotificationFailedMsg, e);
            }
            catch (IOException e) {
                throw new JvmCoreException(4, Messages.unsubscribeMBeanNotificationFailedMsg, e);
            }
        }
    }

    protected void fireMBeanServerChangeEvent(MBeanServerEvent e) {
        for (IMBeanServerChangeListener listener : this.listeners) {
            listener.serverChanged(e);
        }
    }

    protected String getRuntimeName() throws JvmCoreException {
        if (!this.checkReachability()) {
            return null;
        }
        try {
            RuntimeMXBean runtimeMXBean = (RuntimeMXBean)this.getMXBean(RuntimeMXBean.class, "java.lang:type=Runtime");
            if (runtimeMXBean == null) {
                throw new JvmCoreException(4, NLS.bind((String)Messages.getMBeanFailedMsg, (Object)"java.lang:type=Runtime"), new Exception());
            }
            return runtimeMXBean.getName();
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getMBeanFailedMsg, (Object)"java.lang:type=Runtime"), e);
        }
    }

    protected void connect(int updatePeriod) throws JvmCoreException {
        this.connection = this.connectToMBeanServer(this.jmxUrl);
        this.enableThreadContentionMonitoring();
        this.mxBeans.clear();
        this.previousThreadProcessCpuTime.clear();
        this.heapListElements.clear();
        this.threadListElements.clear();
        this.isJvmReachable = true;
        this.listeners.clear();
        this.previousSamplingTime = 0L;
        this.previousStackTraces.clear();
        this.monitoredAttributeGroups.clear();
        this.startUpdateTimer(updatePeriod);
    }

    protected void refresh() throws JvmCoreException {
        if (!this.checkReachability()) {
            return;
        }
        for (IMonitoredMXBeanGroup group : this.monitoredAttributeGroups) {
            for (IMonitoredMXBeanAttribute attribute : group.getAttributes()) {
                String attributeName = attribute.getAttributeName();
                Object attributeObject = this.getAttribute(attribute.getObjectName(), attributeName);
                Number value = this.getAttributeValue(attributeObject, attributeName);
                if (value == null) continue;
                if ("ProcessCpuTime".equals(attribute.getAttributeName())) {
                    if (this.previousProcessCpuTime == 0L) {
                        this.previousProcessCpuTime = (Long)value;
                        continue;
                    }
                    Double percent = (double)((Long)value - this.previousProcessCpuTime) / 1.0E9;
                    this.previousProcessCpuTime = (Long)value;
                    value = percent > 1.0 ? 1.0 : percent;
                }
                ((MonitoredMXBeanAttribute)attribute).add(value, new Date());
            }
        }
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.JvmModified, this.jvm));
    }

    protected void dispose() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.samplingTimer != null) {
            this.samplingTimer.cancel();
        }
        ((MBeanNotification)this.mBeanNotification).dispose();
    }

    private Number getAttributeValue(Object attributeObject, String attributeName) {
        if (attributeObject instanceof Number) {
            return (Number)attributeObject;
        }
        if (attributeObject instanceof CompositeData) {
            CompositeData compositeData = (CompositeData)attributeObject;
            if (attributeName.contains(".")) {
                Object value = compositeData.get(attributeName.split("\\.")[1]);
                return this.getAttributeValue(value, attributeName.substring(attributeName.indexOf(".") + 1));
            }
        } else if (attributeObject instanceof TabularData) {
            TabularData tabularData = (TabularData)attributeObject;
            String key = attributeName.split("\\.")[1];
            for (Object keyList : tabularData.keySet()) {
                Object[] keys = ((List)keyList).toArray(new Object[0]);
                if (!String.valueOf(keys[0]).equals(key)) continue;
                return this.getAttributeValue(tabularData.get(keys), attributeName.substring(attributeName.indexOf(".") + 1));
            }
        }
        return null;
    }

    private MBeanServerConnection connectToMBeanServer(JMXServiceURL url) throws JvmCoreException {
        try {
            if (this.jvm.getUserName() != null && this.jvm.getPassword() != null) {
                HashMap<String, String[]> env = new HashMap<String, String[]>();
                env.put("jmx.remote.credentials", new String[]{this.jvm.getUserName(), this.jvm.getPassword()});
                this.connector = JMXConnectorFactory.connect(url, env);
            } else {
                this.connector = JMXConnectorFactory.connect(url);
            }
            return this.connector.getMBeanServerConnection();
        }
        catch (IOException e) {
            IHost host = this.jvm.getHost();
            if (host != null && host.getActiveJvms().contains(this.jvm)) {
                host.removeJvm(this.jvm.getPid());
            }
            throw new JvmCoreException(1, Messages.connectToMBeanServerFailedMsg, e);
        }
    }

    private void enableThreadContentionMonitoring() throws JvmCoreException {
        try {
            ThreadMXBean threadMXBean = (ThreadMXBean)this.getMXBean(ThreadMXBean.class, "java.lang:type=Threading");
            if (threadMXBean != null) {
                threadMXBean.setThreadContentionMonitoringEnabled(true);
            }
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getMBeanFailedMsg, (Object)"java.lang:type=Threading"), e);
        }
    }

    private Object getMXBean(Class mxBeanClass, String mxBeanName) throws IOException {
        Object mxBean = this.mxBeans.get(mxBeanClass);
        if (mxBean == null && this.connection != null) {
            mxBean = ManagementFactory.newPlatformMXBeanProxy(this.connection, mxBeanName, mxBeanClass);
            this.mxBeans.put(mxBeanClass, mxBean);
        }
        return mxBean;
    }

    private void parseHeap(String heap, int maxNumberOfClasses) {
        String[] lines;
        LinkedHashMap<String, HeapElement> newHeapElements = new LinkedHashMap<String, HeapElement>();
        String[] stringArray = lines = heap.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            Scanner scanner = new Scanner(line);
            if (scanner.hasNext()) {
                scanner.next();
                if (scanner.hasNextLong()) {
                    long count = scanner.nextLong();
                    if (scanner.hasNextLong()) {
                        String className;
                        long size = scanner.nextLong();
                        if (scanner.hasNext() && !(className = scanner.next()).startsWith("<")) {
                            HeapElement oldElement = this.heapListElements.get(className = this.convertClassName(className));
                            if (oldElement == null) {
                                newHeapElements.put(className, new HeapElement(className, size, count));
                            } else if (!newHeapElements.containsKey(className)) {
                                oldElement.setSizeAndCount(size, count);
                                newHeapElements.put(className, oldElement);
                            }
                            if (newHeapElements.size() >= maxNumberOfClasses) break;
                        }
                    }
                }
            }
            ++n2;
        }
        this.heapListElements = newHeapElements;
    }

    private String convertClassName(String className) {
        if (className.startsWith("[")) {
            return Signature.toString((String)className);
        }
        return className;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFileStore dump(ISnapshot.SnapshotType type, String dumpFileName, IProgressMonitor monitor) throws JvmCoreException {
        if (dumpFileName == null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(new Date().getTime()).append('.').append(type.getExtension());
            simpleFileName = stringBuffer.toString();
        } else {
            simpleFileName = new File(dumpFileName).getName();
        }
        fileStore = Util.getFileStore(simpleFileName, this.jvm.getBaseDirectory());
        abstractJvm = this.jvm;
        if (!((Host)this.jvm.getHost()).getJvms().contains(this.jvm)) {
            this.jvm.saveJvmProperties();
            abstractJvm = (AbstractJvm)((Host)this.jvm.getHost()).addTerminatedJvm(this.jvm.getPid(), this.jvm.getPort(), this.jvm.getMainClass());
        }
        os = null;
        try {
            block18: {
                if (type != ISnapshot.SnapshotType.Heap && type != ISnapshot.SnapshotType.Thread) break block18;
                dump = this.getDumpString(type);
                os = fileStore.openOutputStream(0, null);
                os.write(dump.getBytes());
                ** GOTO lbl55
            }
            if (type != ISnapshot.SnapshotType.Hprof || !this.jvm.isRemote()) ** GOTO lbl55
            objectName = this.getObjectName("com.fusesource.ide.jvmmonitor:type=Data Transfer");
            os = fileStore.openOutputStream(0, null);
            bytes = new byte[]{};
            offset = 0;
            SIGNATURES = new String[]{String.class.getCanonicalName(), "int", "int"};
            while (true) {
                bytes = (byte[])this.invoke(objectName, "read", new Object[]{dumpFileName, offset, 4096}, SIGNATURES);
                os.write(bytes);
                offset += 4096;
                if (monitor == null || !monitor.isCanceled()) continue;
                if (os == null) return null;
                ** GOTO lbl49
                break;
            }
        }
        catch (CoreException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.openOutputStreamFailedMsg, (Object)fileStore.toURI().getPath()), e);
        }
        catch (IOException e) {
            try {
                fileStore.delete(0, null);
                throw new JvmCoreException(4, NLS.bind((String)Messages.dumpFailedMsg, (Object)fileStore.toURI().getPath()), e);
            }
            catch (CoreException v0) {}
            throw new JvmCoreException(4, NLS.bind((String)Messages.dumpFailedMsg, (Object)fileStore.toURI().getPath()), e);
            catch (Throwable var12_14) {
                if (os == null) throw var12_14;
                try {
                    os.close();
                    throw var12_14;
                }
                catch (IOException v1) {}
                throw var12_14;
            }
lbl49:
            // 1 sources

            try {
                os.close();
                return null;
            }
            catch (IOException v2) {}
            return null;
            {
                if (bytes.length > 0) ** continue;
lbl55:
                // 3 sources

                snapshot = new Snapshot(fileStore, abstractJvm);
                abstractJvm.addSnapshot(snapshot);
                JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.ShapshotTaken, abstractJvm, snapshot));
            }
        }
        if (os == null) return fileStore;
        try {
            os.close();
            return fileStore;
        }
        catch (IOException v3) {}
        return fileStore;
    }

    private String getDumpString(ISnapshot.SnapshotType type) {
        Date currentDate = new Date();
        String date = new SimpleDateFormat("yyyy/MM/dd").format(currentDate);
        String time = new SimpleDateFormat("HH:mm:ss").format(currentDate);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<?JvmMonitor version=\"");
        buffer.append(Activator.getDefault().getBundle().getVersion().toString());
        buffer.append("\"?>\n");
        if (type == ISnapshot.SnapshotType.Heap) {
            buffer.append("<heap-profile date=\"");
        } else if (type == ISnapshot.SnapshotType.Thread) {
            buffer.append("<thread-profile date=\"");
        }
        buffer.append(date).append(' ').append(time).append("\" ");
        buffer.append("runtime=\"").append(this.jvm.getPid()).append("@").append(this.jvm.getHost().getName()).append("\" ");
        buffer.append("mainClass=\"").append(this.jvm.getMainClass()).append("\" ");
        buffer.append("arguments=\"").append(this.getJvmArguments()).append("\">\n");
        if (type == ISnapshot.SnapshotType.Heap) {
            for (HeapElement element : this.heapListElements.values()) {
                element.dump(buffer);
            }
            buffer.append("</heap-profile>");
        } else if (type == ISnapshot.SnapshotType.Thread) {
            for (ThreadElement element : this.threadListElements.values()) {
                element.dump(buffer);
            }
            buffer.append("</thread-profile>");
        }
        return buffer.toString();
    }

    private synchronized boolean checkReachability() {
        if (!this.isJvmReachable) {
            return false;
        }
        try {
            this.connection.getDefaultDomain();
        }
        catch (IOException iOException) {
            this.isJvmReachable = false;
            this.timer.cancel();
            if (this.samplingTimer != null) {
                this.samplingTimer.cancel();
                this.samplingTimer = null;
            }
            if (this.jvm.getHost().getActiveJvms().contains(this.jvm)) {
                this.jvm.getHost().removeJvm(this.jvm.getPid());
            }
            return false;
        }
        return true;
    }

    void sampleProfilingData() throws JvmCoreException {
        ThreadMXBean threadMXBean;
        if (!this.checkReachability()) {
            return;
        }
        try {
            threadMXBean = (ThreadMXBean)this.getMXBean(ThreadMXBean.class, "java.lang:type=Threading");
        }
        catch (IOException e) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getMBeanFailedMsg, (Object)"java.lang:type=Threading"), e);
        }
        if (threadMXBean == null) {
            throw new JvmCoreException(4, NLS.bind((String)Messages.getMBeanFailedMsg, (Object)"java.lang:type=Threading"), null);
        }
        CpuModel cpuModel = (CpuModel)this.jvm.getCpuProfiler().getCpuModel();
        long samplingTime = System.currentTimeMillis();
        long actualSamplingPeriodInMilliSeconds = this.previousSamplingTime == 0L ? (long)this.samplingPeriod.intValue() : samplingTime - this.previousSamplingTime;
        Set<String> profiledPackages = this.jvm.getCpuProfiler().getProfiledPackages();
        ThreadInfo[] threadInfoArray = threadMXBean.dumpAllThreads(true, false);
        int n = threadInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo threadInfo = threadInfoArray[n2];
            StackTraceElement[] stackTrace = threadInfo.getStackTrace();
            String threadName = threadInfo.getThreadName();
            if (stackTrace.length > 0 && !threadName.startsWith("JMX ") && !threadName.startsWith("RMI ")) {
                ThreadNode<CallTreeNode> callTreeThreadNode = cpuModel.getCallTreeThread(threadName);
                ThreadNode<MethodNode> hotSpotThreadNode = cpuModel.getHotSpotThread(threadName);
                if (callTreeThreadNode == null) {
                    callTreeThreadNode = new ThreadNode(threadName);
                }
                if (hotSpotThreadNode == null) {
                    hotSpotThreadNode = new ThreadNode(threadName);
                }
                this.updateCpuModel(callTreeThreadNode, hotSpotThreadNode, profiledPackages, this.invertStackTrace(stackTrace), actualSamplingPeriodInMilliSeconds);
                if (callTreeThreadNode.hasChildren()) {
                    cpuModel.addCallTreeThread(callTreeThreadNode);
                }
                if (hotSpotThreadNode.hasChildren()) {
                    cpuModel.addHotSpotThread(hotSpotThreadNode);
                }
            }
            ++n2;
        }
        this.previousSamplingTime = samplingTime;
    }

    private StackTraceElement[] invertStackTrace(StackTraceElement[] stackTrace) {
        StackTraceElement[] invertedStackTrace = new StackTraceElement[stackTrace.length];
        int i = 0;
        while (i < stackTrace.length) {
            invertedStackTrace[i] = stackTrace[stackTrace.length - 1 - i];
            ++i;
        }
        return invertedStackTrace;
    }

    private void updateCpuModel(ThreadNode<CallTreeNode> callTreeThreadNode, ThreadNode<MethodNode> hotSpotThreadNode, Set<String> profiledPackages, StackTraceElement[] stackTrace, long period) {
        String threadName = callTreeThreadNode.getName();
        StackTraceElement[] previousStackTrace = this.previousStackTraces.get(threadName);
        boolean isNewStack = false;
        CallTreeNode currentFrameNode = null;
        boolean isRootStack = true;
        int i = 0;
        while (i < stackTrace.length) {
            if (this.isProfiledPackage(stackTrace[i].getClassName(), profiledPackages)) {
                String methodName = String.valueOf(stackTrace[i].getClassName()) + "." + stackTrace[i].getMethodName() + "()";
                if (previousStackTrace == null || i >= previousStackTrace.length || !stackTrace[i].equals(previousStackTrace[i])) {
                    isNewStack = true;
                }
                this.updateMethodNode(hotSpotThreadNode, methodName, isNewStack, period);
                currentFrameNode = this.updateFrameNode(callTreeThreadNode, currentFrameNode, methodName, isNewStack, period, i == stackTrace.length - 1);
                hotSpotThreadNode.setTotalTime(hotSpotThreadNode.getTotalTime() + period);
                if (isRootStack) {
                    callTreeThreadNode.setTotalTime(callTreeThreadNode.getTotalTime() + period);
                }
                isRootStack = false;
            }
            ++i;
        }
        this.previousStackTraces.put(threadName, stackTrace);
    }

    private CallTreeNode updateFrameNode(ThreadNode<CallTreeNode> callTreeThreadNode, CallTreeNode currentFrameNode, String methodName, boolean isNewStack, long period, boolean isLeaf) {
        CallTreeNode frameNode = currentFrameNode == null ? (CallTreeNode)callTreeThreadNode.getChild(methodName) : currentFrameNode.getChild(methodName);
        if (frameNode == null) {
            if (currentFrameNode == null) {
                frameNode = new CallTreeNode(this.jvm.getCpuProfiler().getCpuModel(), methodName, period, 1, callTreeThreadNode);
                callTreeThreadNode.addChild(frameNode);
            } else {
                frameNode = new CallTreeNode(this.jvm.getCpuProfiler().getCpuModel(), methodName, period, 1, currentFrameNode, callTreeThreadNode);
                currentFrameNode.addChild(frameNode);
            }
        } else {
            if (isNewStack) {
                frameNode.setInvocationCount(frameNode.getInvocationCount() + 1);
            }
            frameNode.setTotalTime(frameNode.getTotalTime() + period);
        }
        if (isLeaf) {
            frameNode.setSelfTime(frameNode.getSelfTime() + period);
        }
        return frameNode;
    }

    private void updateMethodNode(ThreadNode<MethodNode> hotSpotThreadNode, String methodName, boolean isNewStack, long period) {
        MethodNode methodNode = (MethodNode)hotSpotThreadNode.getChild(methodName);
        if (methodNode == null) {
            methodNode = new MethodNode(this.jvm.getCpuProfiler().getCpuModel(), methodName, hotSpotThreadNode);
            hotSpotThreadNode.addChild(methodNode);
        }
        if (isNewStack) {
            methodNode.incrementCount(1);
        }
        methodNode.incrementTime(period);
    }

    private boolean isProfiledPackage(String className, Set<String> packages) {
        String packageName;
        if (packages.isEmpty()) {
            return false;
        }
        if (className.contains(".")) {
            packageName = className.substring(0, className.lastIndexOf(46));
        } else {
            if (className.startsWith("$")) {
                return false;
            }
            packageName = "<default>";
        }
        for (String pkg : packages) {
            if (!(pkg.endsWith("*") ? packageName.concat(".").startsWith(pkg.substring(0, pkg.length() - 1)) : packageName.equals(pkg))) continue;
            return true;
        }
        return false;
    }

    private void startUpdateTimer(int updatePeriod) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    MBeanServer.this.refresh();
                }
                catch (JvmCoreException e) {
                    Activator.log(4, e.getMessage(), (Throwable)((Object)e));
                    MBeanServer.this.timer.cancel();
                }
                catch (Throwable throwable) {
                    MBeanServer.this.timer.cancel();
                }
            }
        };
        this.timer.schedule(timerTask, 0L, (long)updatePeriod);
    }
}

