/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core;

import com.fusesource.ide.jvmmonitor.core.IThreadElement;
import java.lang.management.ThreadInfo;

public class ThreadElement
implements IThreadElement {
    private String threadName;
    private Thread.State threadState;
    private long blockedTime;
    private long blockedCount;
    private long waitedTime;
    private long waitedCount;
    private String lockName;
    private String lockOwnerName;
    private StackTraceElement[] stackTraceElements;
    private boolean isSuspended;
    private boolean isDeadlocked;
    private double cpuUsage;

    public ThreadElement(ThreadInfo threadInfo, boolean isDeadlocked, double cpuUsage) {
        this.isDeadlocked = isDeadlocked;
        this.cpuUsage = cpuUsage;
        this.setThreadInfo(threadInfo);
    }

    public ThreadElement(String threadName, Thread.State threadState, long blockedTime, long blockedCount, long waitedTime, long waitedCount, String lockName, String lockOwnerName, boolean isSuspended, boolean isDeadlocked, double cpuUsage) {
        this.threadName = threadName;
        this.threadState = threadState;
        this.blockedTime = blockedTime;
        this.blockedCount = blockedCount;
        this.waitedTime = waitedTime;
        this.waitedCount = waitedCount;
        this.lockName = lockName;
        this.lockOwnerName = lockOwnerName;
        this.isSuspended = isSuspended;
        this.isDeadlocked = isDeadlocked;
        this.cpuUsage = cpuUsage;
    }

    @Override
    public String getThreadName() {
        return this.threadName;
    }

    @Override
    public Thread.State getThreadState() {
        return this.threadState;
    }

    @Override
    public long getBlockedTime() {
        return this.blockedTime;
    }

    @Override
    public long getBlockedCount() {
        return this.blockedCount;
    }

    @Override
    public long getWaitedTime() {
        return this.waitedTime;
    }

    @Override
    public long getWaitedCount() {
        return this.waitedCount;
    }

    @Override
    public String getLockName() {
        return this.lockName == null ? "" : this.lockName;
    }

    @Override
    public String getLockOwnerName() {
        return this.lockOwnerName == null ? "" : this.lockOwnerName;
    }

    @Override
    public StackTraceElement[] getStackTraceElements() {
        return this.stackTraceElements;
    }

    @Override
    public boolean isSuspended() {
        return this.isSuspended;
    }

    @Override
    public boolean isDeadlocked() {
        return this.isDeadlocked;
    }

    @Override
    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public void setThreadInfo(ThreadInfo threadInfo) {
        this.threadName = threadInfo.getThreadName();
        this.threadState = threadInfo.getThreadState();
        this.blockedTime = threadInfo.getBlockedTime();
        this.blockedCount = threadInfo.getBlockedCount();
        this.waitedTime = threadInfo.getWaitedTime();
        this.waitedCount = threadInfo.getWaitedCount();
        this.lockName = threadInfo.getLockName();
        this.lockOwnerName = threadInfo.getLockOwnerName();
        this.stackTraceElements = threadInfo.getStackTrace();
        this.isSuspended = threadInfo.isSuspended();
    }

    public void setStackTrace(StackTraceElement[] stackTraceElements) {
        this.stackTraceElements = stackTraceElements;
    }

    public void setDeadlocked(boolean deadlocked) {
        this.isDeadlocked = deadlocked;
    }

    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public void dump(StringBuffer buffer) {
        buffer.append("\t<thread ");
        buffer.append("name=\"").append(this.threadName).append("\" ");
        buffer.append("state=\"").append((Object)this.threadState).append("\" ");
        buffer.append("blockedTime=\"").append(this.blockedTime).append("\" ");
        buffer.append("blockedCount=\"").append(this.blockedCount).append("\" ");
        buffer.append("waitedTime=\"").append(this.waitedTime).append("\" ");
        buffer.append("waitedCount=\"").append(this.waitedCount).append("\" ");
        buffer.append("lock=\"").append(this.getLockName()).append("\" ");
        buffer.append("lockOwner=\"").append(this.getLockOwnerName()).append("\" ");
        buffer.append("suspended=\"").append(this.isSuspended).append("\" ");
        buffer.append("deadlocked=\"").append(this.isDeadlocked).append("\" ");
        buffer.append("cpuUsage=\"").append(this.cpuUsage).append("\">\n");
        StackTraceElement[] stackTraceElementArray = this.stackTraceElements;
        int n = this.stackTraceElements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            buffer.append("\t\t<frame ");
            buffer.append("class=\"").append(element.getClassName()).append("\" ");
            String method = element.getMethodName().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            buffer.append("method=\"").append(method).append("\" ");
            buffer.append("file=\"").append(element.getFileName()).append("\" ");
            buffer.append("line=\"").append(element.getLineNumber()).append("\"/>\n");
            ++n2;
        }
        buffer.append("\t</thread>\n");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.threadName).append('\t');
        buffer.append(this.getThreadState().toString()).append('\t');
        buffer.append(this.getCpuUsage()).append('\t');
        buffer.append(this.getBlockedTime()).append('\t');
        buffer.append(this.getBlockedCount()).append('\t');
        buffer.append(this.getWaitedTime()).append('\t');
        buffer.append(this.getWaitedCount()).append('\t');
        buffer.append(this.getLockName()).append('\t');
        buffer.append(this.getLockOwnerName() != null ? this.getLockOwnerName() : "");
        return buffer.toString();
    }
}

