/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core.cpu;

import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.CallTreeNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.ThreadNode;

public abstract class AbstractMethodNode
implements IMethodNode {
    protected long selfTime;
    protected ICpuModel cpuModel;
    protected String qualifiedMethodName;
    private String methodName;
    protected ThreadNode<? extends IMethodNode> threadNode;
    protected int invocationCount;

    public AbstractMethodNode(ICpuModel cpuModel, String name, ThreadNode<? extends IMethodNode> thread) {
        this.cpuModel = cpuModel;
        this.qualifiedMethodName = name;
        this.threadNode = thread;
        int index = this.qualifiedMethodName.indexOf(40);
        String methodNameWithoutArguments = index != -1 ? this.qualifiedMethodName.substring(0, index) : this.qualifiedMethodName;
        index = methodNameWithoutArguments.lastIndexOf(46);
        this.methodName = methodNameWithoutArguments.substring(index + 1);
    }

    @Override
    public String getName() {
        return this.qualifiedMethodName;
    }

    @Override
    public String getNonqualifiedName() {
        return this.methodName;
    }

    @Override
    public String getThread() {
        return this.threadNode.getName();
    }

    @Override
    public double getSelfTimeInPercentage() {
        double rootTotalTime = this.getRootTotalTime();
        if (rootTotalTime == 0.0) {
            return 0.0;
        }
        return (double)this.selfTime / this.getRootTotalTime() * 100.0;
    }

    @Override
    public long getSelfTime() {
        return this.selfTime;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    public int hashCode() {
        return super.hashCode() | this.qualifiedMethodName.hashCode();
    }

    public String toString() {
        return this.qualifiedMethodName;
    }

    public abstract void clear();

    protected double getRootTotalTime() {
        CallTreeNode focusedNode = (CallTreeNode)this.cpuModel.getFocusTarget();
        if (focusedNode != null) {
            return focusedNode.getTotalTime();
        }
        return this.threadNode.getTotalTime();
    }
}

