/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core.cpu;

import com.fusesource.ide.jvmmonitor.core.cpu.ICallTreeNode;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.ITreeNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.AbstractMethodNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.ThreadNode;
import java.util.ArrayList;
import java.util.List;

public class CallTreeNode
extends AbstractMethodNode
implements ICallTreeNode {
    private List<CallTreeNode> frames;
    private long totalTime;
    private CallTreeNode parentFrameNode;

    public CallTreeNode(ICpuModel cpuModel, String name, long time, int count, CallTreeNode parent, ThreadNode<CallTreeNode> thread) {
        this(cpuModel, name, time, count, thread);
        this.parentFrameNode = parent;
    }

    public CallTreeNode(ICpuModel cpuModel, String name, long time, int count, ThreadNode<CallTreeNode> thread) {
        super(cpuModel, name, thread);
        this.totalTime = time;
        this.invocationCount = count;
        this.frames = new ArrayList<CallTreeNode>();
    }

    public List<CallTreeNode> getChildren() {
        return this.frames;
    }

    @Override
    public CallTreeNode getChild(String name) {
        for (CallTreeNode frameNode : this.frames) {
            if (!frameNode.getName().equals(name)) continue;
            return frameNode;
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.frames.size() > 0;
    }

    @Override
    public ITreeNode getParent() {
        return this.parentFrameNode != null ? this.parentFrameNode : this.threadNode;
    }

    @Override
    public void clear() {
        for (CallTreeNode frameNode : this.frames) {
            this.selfTime = 0L;
            this.totalTime = 0L;
            this.invocationCount = 0;
            frameNode.clear();
        }
    }

    @Override
    public double getTotalTimeInPercentage() {
        double rootTotalTime = this.getRootTotalTime();
        if (rootTotalTime == 0.0) {
            return 0.0;
        }
        return (double)this.totalTime / rootTotalTime * 100.0;
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CallTreeNode)) {
            return false;
        }
        CallTreeNode frameNode = (CallTreeNode)obj;
        return frameNode.getName().equals(this.qualifiedMethodName) && frameNode.getSelfTime() == this.selfTime && frameNode.getTotalTime() == this.totalTime && frameNode.getInvocationCount() == this.invocationCount;
    }

    public void addChild(CallTreeNode node) {
        this.frames.add(node);
    }

    public void setTotalTime(long time) {
        this.totalTime = time;
    }

    public void setSelfTime(long time) {
        this.selfTime = time;
    }

    public void setInvocationCount(int count) {
        this.invocationCount = count;
    }

    public void dump(StringBuffer buffer, int nest) {
        int i = 0;
        while (i < nest) {
            buffer.append('\t');
            ++i;
        }
        String method = this.qualifiedMethodName.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        buffer.append("<frame name=\"").append(method).append("\" cnt=\"").append(this.invocationCount).append("\" time=\"").append(this.totalTime).append("\"");
        if (this.frames.size() > 0) {
            buffer.append(">\n");
            for (CallTreeNode frameNode : this.frames) {
                frameNode.dump(buffer, nest + 1);
            }
            int i2 = 0;
            while (i2 < nest) {
                buffer.append('\t');
                ++i2;
            }
            buffer.append("</frame>\n");
        } else {
            buffer.append("/>\n");
        }
    }
}

