/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core.cpu;

import com.fusesource.ide.jvmmonitor.core.cpu.CpuModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.ICallTreeNode;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModelChangeListener;
import com.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import com.fusesource.ide.jvmmonitor.core.cpu.ITreeNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.AbstractMethodNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.CallTreeNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.MethodNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.ThreadNode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class CpuModel
implements ICpuModel {
    static final String AGENT_VERSION = "3.7.0";
    private List<ThreadNode<CallTreeNode>> callTreeThreads = new CopyOnWriteArrayList<ThreadNode<CallTreeNode>>();
    private List<ThreadNode<MethodNode>> hotSpotThreads = new CopyOnWriteArrayList<ThreadNode<MethodNode>>();
    private List<MethodNode> callers = new ArrayList<MethodNode>();
    private List<MethodNode> callees = new ArrayList<MethodNode>();
    private List<ICpuModelChangeListener> listeners;
    private CallTreeNode focusTarget;
    private Map<String, MethodNode> focusedHotSpotRoots = new HashMap<String, MethodNode>();
    private IMethodNode callersCalleesTarget;
    private long maxTotalTime;
    private long maxSelfTime;
    private int maxInvocationCount;

    public CpuModel() {
        this.listeners = new ArrayList<ICpuModelChangeListener>();
    }

    @Override
    public ITreeNode[] getCallTreeRoots() {
        if (this.focusTarget == null) {
            return this.callTreeThreads.toArray(new ThreadNode[0]);
        }
        return new ICallTreeNode[]{this.focusTarget};
    }

    @Override
    public ITreeNode[] getHotSpotRoots() {
        if (this.focusTarget == null) {
            return this.hotSpotThreads.toArray(new ThreadNode[0]);
        }
        return this.focusedHotSpotRoots.values().toArray(new IMethodNode[0]);
    }

    @Override
    public IMethodNode[] getCallers() {
        return this.callers.toArray(new IMethodNode[0]);
    }

    @Override
    public IMethodNode[] getCallees() {
        return this.callees.toArray(new IMethodNode[0]);
    }

    @Override
    public void setCallersCalleesTarget(IMethodNode targetMethod) {
        this.callers.clear();
        this.callees.clear();
        this.callersCalleesTarget = targetMethod;
        String thread = this.getThread(targetMethod);
        List<CallTreeNode> frameRootNodes = this.getFrameRootNodes(thread);
        if (frameRootNodes.isEmpty() || targetMethod == null) {
            this.notifyModelChanged(new CpuModelEvent(CpuModelEvent.CpuModelState.CallersCalleesTargetChanged));
            return;
        }
        ArrayList<String> callerNames = new ArrayList<String>();
        ArrayList<String> calleeNames = new ArrayList<String>();
        this.refreshCallersCallees(callerNames, calleeNames, frameRootNodes, targetMethod.getName());
        List<MethodNode> methodNodes = this.getMethodNodes(thread);
        for (MethodNode methodNode : methodNodes) {
            if (callerNames.contains(methodNode.getName())) {
                this.callers.add(methodNode);
            }
            if (!calleeNames.contains(methodNode.getName())) continue;
            this.callees.add(methodNode);
        }
        this.notifyModelChanged(new CpuModelEvent(CpuModelEvent.CpuModelState.CallersCalleesTargetChanged));
    }

    @Override
    public IMethodNode getCallersCalleesTarget() {
        return this.callersCalleesTarget;
    }

    @Override
    public void setFocusTarget(ICallTreeNode node) {
        this.focusTarget = (CallTreeNode)node;
        if (this.focusTarget != null) {
            this.focusedHotSpotRoots.clear();
            this.addFocusedHotSpotNodes(this.focusTarget);
        }
        this.setCallersCalleesTarget(null);
        this.notifyModelChanged(new CpuModelEvent(CpuModelEvent.CpuModelState.FocusedMethodChanged));
    }

    @Override
    public ICallTreeNode getFocusTarget() {
        return this.focusTarget;
    }

    @Override
    public void addModelChangeListener(ICpuModelChangeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeModelChangeListener(ICpuModelChangeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void refreshMaxValues() {
        this.maxTotalTime = 0L;
        this.maxSelfTime = 0L;
        this.maxInvocationCount = 0;
        for (ThreadNode<MethodNode> rootNode : this.hotSpotThreads) {
            long totalTime = rootNode.getTotalTime();
            if (totalTime > this.maxTotalTime) {
                this.maxTotalTime = totalTime;
            }
            for (ITreeNode iTreeNode : rootNode.getChildren()) {
                long selfTime;
                int count = ((MethodNode)iTreeNode).getInvocationCount();
                if (count > this.maxInvocationCount) {
                    this.maxInvocationCount = count;
                }
                if ((selfTime = ((MethodNode)iTreeNode).getSelfTime()) <= this.maxSelfTime) continue;
                this.maxSelfTime = selfTime;
            }
        }
    }

    @Override
    public long getMaxTotalTime() {
        return this.maxTotalTime;
    }

    @Override
    public long getMaxSelfTime() {
        return this.maxSelfTime;
    }

    @Override
    public long getMaxInvocationCount() {
        return this.maxInvocationCount;
    }

    public ThreadNode<CallTreeNode> getCallTreeThread(String threadName) {
        for (ThreadNode<CallTreeNode> treeNode : this.callTreeThreads) {
            if (!treeNode.getName().equals(threadName)) continue;
            return treeNode;
        }
        return null;
    }

    public void addCallTreeThread(ThreadNode<CallTreeNode> thread) {
        if (!this.callTreeThreads.contains(thread)) {
            this.callTreeThreads.add(thread);
        }
    }

    public ThreadNode<MethodNode> getHotSpotThread(String threadName) {
        for (ThreadNode<MethodNode> treeNode : this.hotSpotThreads) {
            if (!treeNode.getName().equals(threadName)) continue;
            return treeNode;
        }
        return null;
    }

    public void addHotSpotThread(ThreadNode<MethodNode> thread) {
        if (!this.hotSpotThreads.contains(thread)) {
            this.hotSpotThreads.add(thread);
        }
    }

    public void removeAll() {
        this.callTreeThreads.clear();
        this.hotSpotThreads.clear();
        this.callers.clear();
        this.callees.clear();
        this.focusedHotSpotRoots.clear();
    }

    protected void clear() {
        for (ThreadNode<CallTreeNode> threadNode : this.callTreeThreads) {
            threadNode.clear();
        }
        for (ThreadNode<AbstractMethodNode> threadNode : this.hotSpotThreads) {
            threadNode.clear();
        }
    }

    protected void notifyModelChanged(CpuModelEvent event) {
        for (ICpuModelChangeListener listener : this.listeners) {
            listener.modelChanged(event);
        }
    }

    protected String getCpuDumpString(String runtime, String mainClass, String arguments) {
        Date currentDate = new Date();
        String date = new SimpleDateFormat("yyyy/MM/dd").format(currentDate);
        String time = new SimpleDateFormat("HH:mm:ss").format(currentDate);
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        buffer.append("<?JvmMonitor version=\"");
        buffer.append(AGENT_VERSION);
        buffer.append("\"?>\n");
        buffer.append("<cpu-profile date=\"").append(date).append(' ').append(time).append("\" ");
        buffer.append("runtime=\"").append(runtime).append("\" ");
        buffer.append("mainClass=\"").append(mainClass).append("\" ");
        buffer.append("arguments=\"").append(arguments).append("\">\n");
        for (ThreadNode<CallTreeNode> node : this.callTreeThreads) {
            buffer.append("\t<thread name=\"").append(node.getName()).append("\">\n");
            for (CallTreeNode frameNode : node.getChildren()) {
                frameNode.dump(buffer, 2);
            }
            buffer.append("\t</thread>\n");
        }
        buffer.append("</cpu-profile>");
        return buffer.toString();
    }

    private void refreshCallersCallees(List<String> callerNames, List<String> calleeNames, List<CallTreeNode> frameRootNodes, String method) {
        for (CallTreeNode frameNode : frameRootNodes) {
            String parentFrameName = frameNode.getParent().getName();
            String frameName = frameNode.getName();
            if (parentFrameName.equals(method)) {
                calleeNames.add(frameName);
            }
            if (frameName.equals(method)) {
                callerNames.add(parentFrameName);
            }
            this.refreshCallersCallees(callerNames, calleeNames, frameNode.getChildren(), method);
        }
    }

    private void addFocusedHotSpotNodes(ICallTreeNode frame) {
        String methodName = frame.getName();
        MethodNode node = new MethodNode((ICpuModel)this, methodName, null);
        node.incrementCount(frame.getInvocationCount());
        node.incrementTime(frame.getSelfTime());
        this.focusedHotSpotRoots.put(methodName, node);
        for (CallTreeNode child : ((CallTreeNode)frame).getChildren()) {
            methodName = child.getName();
            if (this.focusedHotSpotRoots.containsKey(methodName)) {
                node = this.focusedHotSpotRoots.get(methodName);
                node.incrementCount(child.getInvocationCount());
                node.incrementTime(child.getSelfTime());
            } else {
                node = new MethodNode((ICpuModel)this, methodName, null);
                node.incrementCount(child.getInvocationCount());
                node.incrementTime(child.getSelfTime());
                this.focusedHotSpotRoots.put(methodName, node);
            }
            this.addFocusedHotSpotNodes(child);
        }
    }

    private List<CallTreeNode> getFrameRootNodes(String thread) {
        if (thread == null) {
            return new ArrayList<CallTreeNode>();
        }
        List<CallTreeNode> frameRootNodes = null;
        if (this.focusTarget == null) {
            for (ThreadNode<CallTreeNode> treeNode : this.callTreeThreads) {
                ThreadNode<CallTreeNode> threadNode = treeNode;
                if (!threadNode.getName().equals(thread)) continue;
                frameRootNodes = threadNode.getChildren();
                break;
            }
            if (frameRootNodes == null) {
                throw new IllegalArgumentException("unknown thread: " + thread);
            }
        } else {
            String focusedThread = null;
            ITreeNode node = this.focusTarget;
            if (node != null) {
                while (node.getParent() != null) {
                    node = node.getParent();
                }
                focusedThread = node.getName();
            }
            frameRootNodes = new ArrayList<CallTreeNode>();
            if (!thread.equals(focusedThread)) {
                return frameRootNodes;
            }
            frameRootNodes.add(this.focusTarget);
        }
        return frameRootNodes;
    }

    private List<MethodNode> getMethodNodes(String thread) {
        List<MethodNode> methodNodes = null;
        if (this.focusTarget == null) {
            for (ThreadNode<MethodNode> treeNode : this.hotSpotThreads) {
                ThreadNode<MethodNode> threadNode = treeNode;
                if (!threadNode.getName().equals(thread)) continue;
                methodNodes = threadNode.getChildren();
                break;
            }
            if (methodNodes == null) {
                throw new IllegalArgumentException("unknown thread: " + thread);
            }
        } else {
            methodNodes = new ArrayList<MethodNode>();
            for (MethodNode methodNode : this.focusedHotSpotRoots.values()) {
                methodNodes.add(methodNode);
            }
        }
        return methodNodes;
    }

    private String getThread(IMethodNode callersCalleesMethod) {
        if (this.focusTarget != null) {
            return this.focusTarget.getThread();
        }
        if (callersCalleesMethod != null) {
            return callersCalleesMethod.getThread();
        }
        return null;
    }
}

