/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core.cpu;

import com.fusesource.ide.jvmmonitor.core.Activator;
import com.fusesource.ide.jvmmonitor.core.ISnapshot;
import com.fusesource.ide.jvmmonitor.core.JvmCoreException;
import com.fusesource.ide.jvmmonitor.core.JvmModel;
import com.fusesource.ide.jvmmonitor.core.JvmModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.CpuModelEvent;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.ICpuProfiler;
import com.fusesource.ide.jvmmonitor.core.dump.CpuDumpParser;
import com.fusesource.ide.jvmmonitor.internal.core.AbstractJvm;
import com.fusesource.ide.jvmmonitor.internal.core.ActiveJvm;
import com.fusesource.ide.jvmmonitor.internal.core.Host;
import com.fusesource.ide.jvmmonitor.internal.core.MBeanServer;
import com.fusesource.ide.jvmmonitor.internal.core.Messages;
import com.fusesource.ide.jvmmonitor.internal.core.Snapshot;
import com.fusesource.ide.jvmmonitor.internal.core.Util;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.CpuModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.SAXException;

public class CpuProfiler
implements ICpuProfiler {
    private static final String PROFILER_MXBEAN_NAME = "com.fusesource.ide.jvmmonitor:type=CPU BCI Profiler";
    private static final String TRANSFORM_CLASSES = "transformClasses";
    private static final String INTERRUPT_TRANSFORM = "interruptTransform";
    private static final String CLEAR = "clear";
    private static final String DUMP = "dump";
    private static final String SET_FILTER = "setFilter";
    private static final String TRANSFORM_STATUS = "TransformStatus";
    private static final String TARGET_CLASSES_COUNT = "targetClassesCount";
    private static final String TRANSFORMED_CLASSES_COUNT = "transformedClassesCount";
    private static final String VERSION = "Version";
    private static final String RUNNING = "Running";
    private static final String PROFILED_PACKAGES = "ProfiledPackages";
    private static final String PROFILED_PACKAGES_PROP_KEY = "jvmmonitor.profiled.packages";
    private CpuModel cpuModel = new CpuModel();
    private ActiveJvm jvm;
    private String agentJarVersion;
    private ICpuProfiler.ProfilerType type;
    private Set<String> profiledPackages;

    public CpuProfiler(ActiveJvm jvm) {
        this.jvm = jvm;
        this.type = ICpuProfiler.ProfilerType.SAMPLING;
        this.profiledPackages = new HashSet<String>();
    }

    @Override
    public void setProfilerType(ICpuProfiler.ProfilerType type) {
        this.type = type;
    }

    @Override
    public ICpuProfiler.ProfilerType getProfilerType() {
        return this.type;
    }

    @Override
    public void transformClasses(IProgressMonitor monitor) throws JvmCoreException, InterruptedException {
        if (this.type == ICpuProfiler.ProfilerType.BCI) {
            this.validateAgent();
            int target = this.getTransformStatusCompositeValue(TARGET_CLASSES_COUNT);
            int previousTransformed = this.getTransformStatusCompositeValue(TRANSFORMED_CLASSES_COUNT);
            monitor.beginTask(Messages.transformClassesTask, target);
            monitor.worked(previousTransformed);
            this.invokeCpuProfilerMXBeanMethod(TRANSFORM_CLASSES, null, null);
            while (true) {
                int transformed;
                if (monitor.isCanceled()) {
                    this.invokeCpuProfilerMXBeanMethod(INTERRUPT_TRANSFORM, null, null);
                    throw new InterruptedException();
                }
                target = this.getTransformStatusCompositeValue(TARGET_CLASSES_COUNT);
                if (target == (transformed = this.getTransformStatusCompositeValue(TRANSFORMED_CLASSES_COUNT))) break;
                monitor.worked(transformed - previousTransformed);
                previousTransformed = transformed;
            }
        }
    }

    @Override
    public void resume() throws JvmCoreException {
        if (this.type == ICpuProfiler.ProfilerType.BCI) {
            this.validateAgent();
            ObjectName objectName = this.jvm.getMBeanServer().getObjectName(PROFILER_MXBEAN_NAME);
            if (objectName != null) {
                this.jvm.getMBeanServer().setAttribute(objectName, new Attribute(RUNNING, true));
            }
        } else {
            this.jvm.getMBeanServer().resumeSampling();
        }
    }

    @Override
    public void suspend() throws JvmCoreException {
        if (this.type == ICpuProfiler.ProfilerType.BCI) {
            this.validateAgent();
            ObjectName objectName = this.jvm.getMBeanServer().getObjectName(PROFILER_MXBEAN_NAME);
            if (objectName != null) {
                this.jvm.getMBeanServer().setAttribute(objectName, new Attribute(RUNNING, false));
            }
        } else {
            this.jvm.getMBeanServer().suspendSampling();
        }
    }

    @Override
    public void clear() throws JvmCoreException {
        if (this.type == ICpuProfiler.ProfilerType.BCI) {
            this.validateAgent();
            this.invokeCpuProfilerMXBeanMethod(CLEAR, null, null);
        }
        this.cpuModel.removeAll();
        this.cpuModel.notifyModelChanged(new CpuModelEvent(CpuModelEvent.CpuModelState.CpuModelChanged));
    }

    @Override
    public IFileStore dump() throws JvmCoreException {
        String dump = this.cpuModel.getCpuDumpString(String.valueOf(this.jvm.getPid()) + "@" + this.jvm.getHost().getName(), this.jvm.getMainClass(), this.jvm.getMBeanServer().getJvmArguments());
        StringBuffer fileName = new StringBuffer();
        fileName.append(new Date().getTime()).append('.').append(ISnapshot.SnapshotType.Cpu.getExtension());
        IFileStore fileStore = Util.getFileStore(fileName.toString(), this.jvm.getBaseDirectory());
        AbstractJvm abstractJvm = this.jvm;
        if (!((Host)this.jvm.getHost()).getJvms().contains(this.jvm)) {
            this.jvm.saveJvmProperties();
            abstractJvm = (AbstractJvm)((Object)((Host)this.jvm.getHost()).addTerminatedJvm(this.jvm.getPid(), this.jvm.getPort(), this.jvm.getMainClass()));
        }
        OutputStream os = null;
        try {
            try {
                os = fileStore.openOutputStream(0, null);
                os.write(dump.getBytes());
                Snapshot snapshot = new Snapshot(fileStore, abstractJvm);
                abstractJvm.addSnapshot(snapshot);
                JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.ShapshotTaken, this.jvm, snapshot));
            }
            catch (CoreException e) {
                throw new JvmCoreException(4, NLS.bind((String)Messages.openOutputStreamFailedMsg, (Object)fileStore.toURI().getPath()), e);
            }
            catch (IOException e) {
                try {
                    fileStore.delete(0, null);
                }
                catch (CoreException coreException) {}
                throw new JvmCoreException(4, NLS.bind((String)Messages.dumpCpuProfileDataFailedMsg, (Object)fileStore.toURI().getPath()), e);
            }
        }
        catch (Throwable throwable) {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
        return fileStore;
    }

    @Override
    public CpuModel getCpuModel() {
        return this.cpuModel;
    }

    @Override
    public void refreshBciProfileCache(IProgressMonitor monitor) throws JvmCoreException {
        if (this.type != ICpuProfiler.ProfilerType.BCI) {
            return;
        }
        this.validateAgent();
        if (!this.isBciProfilerRunning()) {
            return;
        }
        String dumpString = (String)this.invokeCpuProfilerMXBeanMethod(DUMP, null, null);
        if (dumpString == null) {
            return;
        }
        ByteArrayInputStream input = null;
        try {
            try {
                input = new ByteArrayInputStream(dumpString.getBytes());
                CpuDumpParser parser = new CpuDumpParser(input, (ICpuModel)this.cpuModel, monitor);
                parser.parse();
            }
            catch (ParserConfigurationException e) {
                throw new JvmCoreException(4, Messages.parseCpuDumpFailedMsg, e);
            }
            catch (SAXException e) {
                throw new JvmCoreException(4, Messages.parseCpuDumpFailedMsg, e);
            }
            catch (IOException e) {
                throw new JvmCoreException(4, Messages.parseCpuDumpFailedMsg, e);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void setProfiledPackages(Set<String> packages) throws JvmCoreException {
        if (this.type == ICpuProfiler.ProfilerType.BCI) {
            this.validateAgent();
            ICpuProfiler.ProfilerState state = this.getState();
            if (state != ICpuProfiler.ProfilerState.READY && state != ICpuProfiler.ProfilerState.RUNNING) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            for (String item : packages) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(item);
            }
            this.invokeCpuProfilerMXBeanMethod(SET_FILTER, new String[]{PROFILED_PACKAGES_PROP_KEY, buffer.toString()}, new String[]{String.class.getName(), String.class.getName()});
        } else {
            this.profiledPackages = packages;
        }
        JvmModel.getInstance().fireJvmModelChangeEvent(new JvmModelEvent(JvmModelEvent.State.CpuProfilerConfigChanged, this.jvm));
    }

    @Override
    public Set<String> getProfiledPackages() throws JvmCoreException {
        if (this.type == ICpuProfiler.ProfilerType.BCI) {
            this.validateAgent();
            LinkedHashSet<String> packages = new LinkedHashSet<String>();
            ICpuProfiler.ProfilerState state = this.getState();
            if (state != ICpuProfiler.ProfilerState.READY && state != ICpuProfiler.ProfilerState.RUNNING) {
                return packages;
            }
            ObjectName objectName = this.jvm.getMBeanServer().getObjectName(PROFILER_MXBEAN_NAME);
            if (this.jvm.isConnected()) {
                String[] stringArray = (String[])this.jvm.getMBeanServer().getAttribute(objectName, PROFILED_PACKAGES);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String item = stringArray[n2];
                    if (!item.isEmpty()) {
                        packages.add(item);
                    }
                    ++n2;
                }
            }
            return packages;
        }
        return this.profiledPackages;
    }

    @Override
    public ICpuProfiler.ProfilerState getState() {
        return this.getState(this.type);
    }

    @Override
    public ICpuProfiler.ProfilerState getState(ICpuProfiler.ProfilerType typeToQuery) {
        if (typeToQuery == ICpuProfiler.ProfilerType.SAMPLING) {
            MBeanServer server = this.jvm.getMBeanServer();
            if (server == null) {
                return ICpuProfiler.ProfilerState.UNKNOWN;
            }
            return server.getProfilerState();
        }
        if (!this.jvm.isRemote() && !JvmModel.getInstance().getAgentLoadHandler().isAgentLoaded()) {
            return ICpuProfiler.ProfilerState.AGENT_NOT_LOADED;
        }
        try {
            if (!this.isValidAgentVersion()) {
                return ICpuProfiler.ProfilerState.INVALID_VERSION;
            }
            if (!this.isBciProfilerRunning()) {
                return ICpuProfiler.ProfilerState.READY;
            }
        }
        catch (JvmCoreException jvmCoreException) {
            return ICpuProfiler.ProfilerState.UNKNOWN;
        }
        return ICpuProfiler.ProfilerState.RUNNING;
    }

    @Override
    public Integer getSamplingPeriod() {
        return this.jvm.getMBeanServer().getSamplingPeriod();
    }

    @Override
    public void setSamplingPeriod(Integer samplingPeriod) {
        this.jvm.getMBeanServer().setSamplingPeriod(samplingPeriod);
    }

    private boolean isValidAgentVersion() throws JvmCoreException {
        ObjectName objectName;
        if (this.agentJarVersion == null && (objectName = this.jvm.getMBeanServer().getObjectName(PROFILER_MXBEAN_NAME)) != null) {
            Object value = this.jvm.getMBeanServer().getAttribute(objectName, VERSION);
            if (value == null) {
                return false;
            }
            this.agentJarVersion = String.valueOf(value);
        }
        String bundleVersion = Activator.getDefault().getBundle().getVersion().toString();
        return bundleVersion.startsWith(this.agentJarVersion);
    }

    private int getTransformStatusCompositeValue(String compositeKey) throws JvmCoreException {
        Object element;
        ObjectName objectName = this.jvm.getMBeanServer().getObjectName(PROFILER_MXBEAN_NAME);
        Object attribute = this.jvm.getMBeanServer().getAttribute(objectName, TRANSFORM_STATUS);
        if (attribute instanceof CompositeData && (element = ((CompositeData)attribute).get(compositeKey)) instanceof Integer) {
            return (Integer)element;
        }
        throw new IllegalStateException();
    }

    private boolean isBciProfilerRunning() throws JvmCoreException {
        ObjectName objectName = this.jvm.getMBeanServer().getObjectName(PROFILER_MXBEAN_NAME);
        if (objectName != null) {
            Object attribute = this.jvm.getMBeanServer().getAttribute(objectName, RUNNING);
            return attribute == null ? false : (Boolean)attribute;
        }
        return false;
    }

    private void validateAgent() throws JvmCoreException {
        if (!this.jvm.isRemote() && !JvmModel.getInstance().getAgentLoadHandler().isAgentLoaded()) {
            this.type = ICpuProfiler.ProfilerType.SAMPLING;
            throw new JvmCoreException(4, Messages.agentNotLoadedMsg, new Exception());
        }
    }

    private Object invokeCpuProfilerMXBeanMethod(String method, String[] params, String[] signatures) throws JvmCoreException {
        ObjectName objectName = this.jvm.getMBeanServer().getObjectName(PROFILER_MXBEAN_NAME);
        return this.jvm.getMBeanServer().invoke(objectName, method, params, signatures);
    }
}

