/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core.cpu;

import com.fusesource.ide.jvmmonitor.core.cpu.ICpuModel;
import com.fusesource.ide.jvmmonitor.core.cpu.ITreeNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.AbstractMethodNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.ThreadNode;
import java.util.List;

public class MethodNode
extends AbstractMethodNode {
    public MethodNode(ICpuModel cpuModel, String name, ThreadNode<MethodNode> thread) {
        super(cpuModel, name, thread);
        this.selfTime = 0L;
        this.invocationCount = 0;
    }

    public List<MethodNode> getChildren() {
        return null;
    }

    @Override
    public MethodNode getChild(String name) {
        return null;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public ITreeNode getParent() {
        return this.threadNode;
    }

    @Override
    public void clear() {
        this.selfTime = 0L;
        this.invocationCount = 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodNode)) {
            return false;
        }
        MethodNode methodNode = (MethodNode)obj;
        return methodNode.getName().equals(this.qualifiedMethodName) && methodNode.getSelfTime() == this.selfTime && methodNode.getInvocationCount() == this.invocationCount;
    }

    public void incrementTime(long time) {
        this.selfTime += time;
    }

    public void incrementCount(int count) {
        this.invocationCount += count;
    }
}

