/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.jvmmonitor.internal.core.cpu;

import com.fusesource.ide.jvmmonitor.core.cpu.IMethodNode;
import com.fusesource.ide.jvmmonitor.core.cpu.IThreadNode;
import com.fusesource.ide.jvmmonitor.core.cpu.ITreeNode;
import com.fusesource.ide.jvmmonitor.internal.core.cpu.AbstractMethodNode;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ThreadNode<E extends IMethodNode>
implements IThreadNode {
    private List<E> nodes;
    private String threadName;
    private long totalTime;

    public ThreadNode(String name) {
        this.threadName = name;
        this.nodes = new CopyOnWriteArrayList();
    }

    public List<E> getChildren() {
        return this.nodes;
    }

    @Override
    public IMethodNode getChild(String name) {
        for (IMethodNode node : this.nodes) {
            if (!node.getName().equals(name)) continue;
            return node;
        }
        return null;
    }

    @Override
    public boolean hasChildren() {
        return this.nodes.size() > 0;
    }

    @Override
    public ITreeNode getParent() {
        return null;
    }

    @Override
    public String getName() {
        return this.threadName;
    }

    @Override
    public long getTotalTime() {
        return this.totalTime;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ThreadNode)) {
            return false;
        }
        return ((ITreeNode)obj).getName().equals(this.threadName);
    }

    public int hashCode() {
        return super.hashCode() | this.threadName.hashCode();
    }

    public String toString() {
        return "Thread: " + this.getName();
    }

    public void addChild(E node) {
        this.nodes.add(node);
    }

    public void clear() {
        this.totalTime = 0L;
        for (IMethodNode node : this.nodes) {
            ((AbstractMethodNode)node).clear();
        }
    }

    public void setTotalTime(long time) {
        this.totalTime = time;
    }
}

