/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.deployment;

import com.fusesource.rider.deployment.config.HotfolderDeploymentConfiguration;
import com.fusesource.rider.preferences.PreferenceManager;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ConfigurationUtils {
    public static void savePreferences(HotfolderDeploymentConfiguration[] deploymentConfigurations) {
        if (deploymentConfigurations == null) {
            return;
        }
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        HotfolderDeploymentConfiguration[] hotfolderDeploymentConfigurationArray = deploymentConfigurations;
        int n = deploymentConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            HotfolderDeploymentConfiguration cfg = hotfolderDeploymentConfigurationArray[n2];
            if (first) {
                first = false;
            } else {
                sb.append(";");
            }
            sb.append(String.format("%s,%s,%s,%s", Boolean.toString(cfg.isDefaultConfig()), cfg.getName(), cfg.getDescription(), cfg.getHotDeployPath()));
            ++n2;
        }
        PreferenceManager.getInstance().savePreference("com.fusesource.rider.deployment.storage", sb.toString());
    }

    public static HotfolderDeploymentConfiguration[] loadPreferences() {
        HotfolderDeploymentConfiguration[] deploymentConfigurations = new HotfolderDeploymentConfiguration[]{};
        String values = PreferenceManager.getInstance().loadPreferenceAsString("com.fusesource.rider.deployment.storage");
        if (values != null && values.trim().length() >= 1) {
            ArrayList<HotfolderDeploymentConfiguration> configs = new ArrayList<HotfolderDeploymentConfiguration>();
            StringTokenizer stok = new StringTokenizer(values, ";");
            while (stok.hasMoreTokens()) {
                int i = 0;
                String token = stok.nextToken();
                String[] parts = token.split(",");
                HotfolderDeploymentConfiguration cfg = new HotfolderDeploymentConfiguration();
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String part = stringArray[n2];
                    switch (i) {
                        case 0: {
                            cfg.setDefaultConfig(Boolean.parseBoolean(part));
                            break;
                        }
                        case 1: {
                            cfg.setName(part);
                            break;
                        }
                        case 2: {
                            cfg.setDescription(part);
                            break;
                        }
                        case 3: {
                            cfg.setHotDeployPath(part);
                        }
                    }
                    ++i;
                    ++n2;
                }
                configs.add(cfg);
            }
            deploymentConfigurations = configs.toArray(new HotfolderDeploymentConfiguration[configs.size()]);
        }
        return deploymentConfigurations;
    }

    public static HotfolderDeploymentConfiguration loadDefaultConfiguration() {
        HotfolderDeploymentConfiguration[] configs;
        HotfolderDeploymentConfiguration[] hotfolderDeploymentConfigurationArray = configs = ConfigurationUtils.loadPreferences();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            HotfolderDeploymentConfiguration config = hotfolderDeploymentConfigurationArray[n2];
            if (config.isDefaultConfig()) {
                return config;
            }
            ++n2;
        }
        return null;
    }
}

