/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.deployment;

import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.Workbenches;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class DeployViews {
    private static Map<String, IViewPart> viewMap = new ConcurrentHashMap<String, IViewPart>();
    private static ISelectionListener selectionListener;
    private static IProject activeProject;

    public static void registerView(String id, IViewPart view) {
        IWorkbenchWindow window;
        viewMap.put(id, view);
        IWorkbench workbench = Workbenches.getActiveWorkbench();
        if (workbench != null && (window = workbench.getActiveWorkbenchWindow()) != null && selectionListener == null) {
            selectionListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    IProject project = DeployViews.selectionToProject(selection);
                    if (project != null) {
                        activeProject = project;
                    }
                }
            };
            window.getSelectionService().addSelectionListener(selectionListener);
        }
    }

    public static IViewPart findView(String id) {
        IViewPart answer = Workbenches.findView((String)id);
        if (answer == null) {
            answer = viewMap.get(id);
        }
        return answer;
    }

    public static IProject getActiveProject() {
        return activeProject;
    }

    public static IProject selectionToProject(ISelection selection) {
        Object element = Selections.getFirstSelection((ISelection)selection);
        IProject project = null;
        if (element instanceof IResource) {
            project = ((IResource)element).getProject();
        } else if (element instanceof PackageFragmentRootContainer) {
            IJavaProject jProject = ((PackageFragmentRootContainer)element).getJavaProject();
            project = jProject.getProject();
        } else if (element instanceof IJavaElement) {
            IJavaProject jProject = ((IJavaElement)element).getJavaProject();
            project = jProject.getProject();
        }
        return project;
    }
}

