/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.deployment;

import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.drop.DeployMenuProvider;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.deployment.ConfigurationUtils;
import com.fusesource.rider.deployment.DeployPlugin;
import com.fusesource.rider.deployment.DeployViews;
import com.fusesource.rider.deployment.Messages;
import com.fusesource.rider.deployment.config.HotfolderDeploymentConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;

public class DeploymentContributionItem
extends ContributionItem {
    private static final String CONFIGURE_DEPLOYMENTS_ID = "com.fusesource.rider.deployment.edit.command";
    private static final String EXECUTE_DEPLOYMENT_ID = "com.fusesource.rider.deployment.command";
    private Menu menu;
    private static Object previousSelectedData;
    private static final boolean showMenuIfNoPreviousSelection = true;

    public void fill(Menu menu, int index) {
        super.fill(menu, index);
        IProject resource = this.getProjectSelection();
        if (resource != null) {
            MenuItem subMenuItem = new MenuItem(menu, 64);
            subMenuItem.setText(Messages.deployToolbarLabel);
            subMenuItem.setImage(DeployPlugin.getDefault().getImage("deploy.png"));
            Menu subMenu = new Menu(menu);
            subMenuItem.setMenu(subMenu);
            this.recreateMenu(subMenu, (IResource)resource);
        }
    }

    public void fill(final ToolBar parent, int index) {
        super.fill(parent, index);
        final ToolItem item = new ToolItem(parent, 4);
        item.setToolTipText(Messages.deployToolbarTooltip);
        item.setImage(DeployPlugin.getDefault().getImage("deploy.png"));
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DeploymentContributionItem.this.recreateMenu(parent);
                if (event.detail == 4) {
                    Rectangle bounds = item.getBounds();
                    Point point = parent.toDisplay(bounds.x, bounds.y + bounds.height);
                    DeploymentContributionItem.this.menu.setLocation(point);
                    DeploymentContributionItem.this.menu.setVisible(true);
                } else {
                    MenuItem menuItem = DeploymentContributionItem.this.findMenuItem(DeploymentContributionItem.this.menu, previousSelectedData);
                    if (menuItem != null) {
                        menuItem.notifyListeners(13, new Event());
                        return;
                    }
                    previousSelectedData = null;
                    Rectangle bounds = item.getBounds();
                    Point point = parent.toDisplay(bounds.x, bounds.y + bounds.height);
                    DeploymentContributionItem.this.menu.setLocation(point);
                    DeploymentContributionItem.this.menu.setVisible(true);
                }
            }
        });
    }

    private void recreateMenu(ToolBar parent) {
        HotfolderDeploymentConfiguration[] configs;
        this.menu = new Menu((Decorations)parent.getShell(), 8);
        IProject resource = this.getLastProjectSelection();
        if (resource != null) {
            this.fillEsbDeployMenus(this.menu, (IResource)resource);
        }
        HotfolderDeploymentConfiguration[] hotfolderDeploymentConfigurationArray = configs = this.determineDeploymentConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            final HotfolderDeploymentConfiguration cfg = hotfolderDeploymentConfigurationArray[n2];
            MenuItem i = new MenuItem(this.menu, 8);
            i.setText(cfg.getName());
            i.setImage(DeployPlugin.getDefault().getImage("folder.gif"));
            i.setData((Object)cfg.getHotDeployPath());
            i.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    try {
                        HashMap<String, HotfolderDeploymentConfiguration> params = new HashMap<String, HotfolderDeploymentConfiguration>();
                        params.put("com.fusesource.rider.deployment.commandParameter.config", cfg);
                        ExecutionEvent evt = new ExecutionEvent(commandService.getCommand(DeploymentContributionItem.EXECUTE_DEPLOYMENT_ID), params, null, null);
                        commandService.getCommand(DeploymentContributionItem.EXECUTE_DEPLOYMENT_ID).executeWithChecks(evt);
                    }
                    catch (Exception ex) {
                        DeployPlugin.getLogger().error((Throwable)ex);
                        throw new RuntimeException("Execution exception occured: " + ex.getMessage());
                    }
                }
            });
            ++n2;
        }
        if (configs.length > 0) {
            new MenuItem(this.menu, 2);
        }
        MenuItem cfgItem = new MenuItem(this.menu, 8);
        cfgItem.setText(Messages.configureDeploymentsMenuLabel);
        cfgItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentContributionItem.this.openConfigurationUI();
            }
        });
        this.addSelectionListeners(this.menu);
    }

    protected IProject getLastProjectSelection() {
        IProject firstSelection = this.getProjectSelection();
        if (!(firstSelection instanceof IProject)) {
            firstSelection = DeployViews.getActiveProject();
        }
        return firstSelection;
    }

    protected IProject getProjectSelection() {
        return DeployViews.selectionToProject(Selections.getWorkbenchSelection());
    }

    private void addSelectionListeners(Menu menu) {
        MenuItem[] items = menu.getItems();
        if (items != null) {
            MenuItem[] menuItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Menu child;
                MenuItem menuItem = menuItemArray[n2];
                final Object data = menuItem.getData();
                if (data != null) {
                    menuItem.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            if (data != null) {
                                previousSelectedData = data;
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
                if ((child = menuItem.getMenu()) != null) {
                    this.addSelectionListeners(child);
                }
                ++n2;
            }
        }
    }

    protected MenuItem findMenuItem(Menu menu, Object selectData) {
        MenuItem[] items;
        if (selectData != null && (items = menu.getItems()) != null) {
            MenuItem[] menuItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                MenuItem childItem;
                MenuItem menuItem = menuItemArray[n2];
                Object data = menuItem.getData();
                if (Objects.equal((Object)data, (Object)selectData)) {
                    return menuItem;
                }
                Menu child = menuItem.getMenu();
                if (child != null && (childItem = this.findMenuItem(child, selectData)) != null) {
                    return childItem;
                }
                ++n2;
            }
        }
        return null;
    }

    private void recreateMenu(Menu parent, IResource resource) {
        HotfolderDeploymentConfiguration[] configs;
        this.fillEsbDeployMenus(parent, resource);
        HotfolderDeploymentConfiguration[] hotfolderDeploymentConfigurationArray = configs = this.determineDeploymentConfigurations();
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            final HotfolderDeploymentConfiguration cfg = hotfolderDeploymentConfigurationArray[n2];
            MenuItem i = new MenuItem(parent, 8);
            i.setText(cfg.getName());
            i.setImage(DeployPlugin.getDefault().getImage("folder.gif"));
            i.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    try {
                        HashMap<String, HotfolderDeploymentConfiguration> params = new HashMap<String, HotfolderDeploymentConfiguration>();
                        params.put("com.fusesource.rider.deployment.commandParameter.config", cfg);
                        ExecutionEvent evt = new ExecutionEvent(commandService.getCommand(DeploymentContributionItem.EXECUTE_DEPLOYMENT_ID), params, null, null);
                        commandService.getCommand(DeploymentContributionItem.EXECUTE_DEPLOYMENT_ID).executeWithChecks(evt);
                    }
                    catch (Exception ex) {
                        DeployPlugin.getLogger().error((Throwable)ex);
                        throw new RuntimeException("Execution exception occured: " + ex.getMessage());
                    }
                }
            });
            ++n2;
        }
        if (configs.length > 0) {
            new MenuItem(parent, 2);
        }
        MenuItem cfgItem = new MenuItem(parent, 8);
        cfgItem.setText(Messages.configureDeploymentsMenuLabel);
        cfgItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentContributionItem.this.openConfigurationUI();
            }
        });
        this.addSelectionListeners(parent);
    }

    protected void fillEsbDeployMenus(Menu parent, IResource resource) {
        if (resource != null) {
            DeployMenuProvider menuProvider;
            IViewPart fabricNavigator = DeployViews.findView("com.fusesource.ide.fabric.navigator");
            IViewPart jmxExplorer = DeployViews.findView("com.fusesource.ide.jmx.ui.internal.views.navigator.MBeanExplorer");
            if (fabricNavigator instanceof DeployMenuProvider) {
                menuProvider = (DeployMenuProvider)fabricNavigator;
                menuProvider.appendDeployActions(parent, resource);
            }
            if (jmxExplorer instanceof DeployMenuProvider) {
                menuProvider = (DeployMenuProvider)jmxExplorer;
                menuProvider.appendDeployActions(parent, resource);
            }
        }
    }

    protected void openConfigurationUI() {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        try {
            handlerService.executeCommand(CONFIGURE_DEPLOYMENTS_ID, new Event());
        }
        catch (Exception ex) {
            DeployPlugin.getLogger().error((Throwable)ex);
            throw new RuntimeException("Error executing configure command: " + ex.getMessage());
        }
    }

    protected HotfolderDeploymentConfiguration[] determineDeploymentConfigurations() {
        HotfolderDeploymentConfiguration[] storedConfigs;
        ArrayList<HotfolderDeploymentConfiguration> configs = new ArrayList<HotfolderDeploymentConfiguration>();
        HotfolderDeploymentConfiguration[] hotfolderDeploymentConfigurationArray = storedConfigs = ConfigurationUtils.loadPreferences();
        int n = storedConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            HotfolderDeploymentConfiguration cfg = hotfolderDeploymentConfigurationArray[n2];
            configs.add(cfg);
            ++n2;
        }
        hotfolderDeploymentConfigurationArray = ServerCore.getRuntimes();
        n = hotfolderDeploymentConfigurationArray.length;
        n2 = 0;
        while (n2 < n) {
            String id;
            IRuntimeType runtimeType;
            HotfolderDeploymentConfiguration rt = hotfolderDeploymentConfigurationArray[n2];
            if (rt != null && (runtimeType = rt.getRuntimeType()) != null && (id = runtimeType.getId()) != null && (id.startsWith("com.fusesource.rider.server.karaf.runtime.") || id.startsWith("com.fusesource.rider.server.smx.runtime."))) {
                HotfolderDeploymentConfiguration cfg = new HotfolderDeploymentConfiguration();
                cfg.setName(String.valueOf(rt.getName()) + " (" + rt.getLocation().toOSString() + ")");
                cfg.setDescription(rt.getLocation().toOSString());
                cfg.setHotDeployPath(rt.getLocation().append("deploy").toOSString());
                configs.add(cfg);
            }
            ++n2;
        }
        return configs.toArray(new HotfolderDeploymentConfiguration[configs.size()]);
    }
}

