/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.deployment.handler;

import com.fusesource.rider.launcher.MavenLaunchDelegate;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public abstract class MavenLaunchDelegateSupport
extends MavenLaunchDelegate {
    public MavenLaunchDelegateSupport(String mavenGoals) {
        super(mavenGoals);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (this.isNonJavaProject(configuration)) {
            return this.preChecksNonJavaProject(configuration, mode, monitor);
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected boolean preChecksNonJavaProject(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (!this.saveBeforeLaunch(configuration, mode, monitor)) {
            return false;
        }
        if (mode.equals("run") && configuration.supportsMode("debug")) {
            IBreakpoint[] breakpoints = this.getBreakpoints(configuration);
            if (breakpoints == null) {
                return true;
            }
            int i = 0;
            while (i < breakpoints.length) {
                if (breakpoints[i].isEnabled()) {
                    boolean launchInDebugModeInstead;
                    IStatusHandler prompter = DebugPlugin.getDefault().getStatusHandler(promptStatus);
                    return prompter == null || !(launchInDebugModeInstead = ((Boolean)prompter.handleStatus(switchToDebugPromptStatus, (Object)configuration)).booleanValue());
                }
                ++i;
            }
        }
        return true;
    }

    public IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        if (this.isNonJavaProject(configuration)) {
            return this.getVMInstallNonJavaProject(configuration);
        }
        return super.getVMInstall(configuration);
    }

    public Map getVMSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        if (this.isNonJavaProject(configuration)) {
            return null;
        }
        return super.getVMSpecificAttributesMap(configuration);
    }

    public String[] getBootpath(ILaunchConfiguration configuration) throws CoreException {
        if (this.isNonJavaProject(configuration)) {
            return null;
        }
        return super.getBootpath(configuration);
    }

    protected IVMInstall getVMInstallNonJavaProject(ILaunchConfiguration configuration) {
        return JavaRuntime.getDefaultVMInstall();
    }

    protected boolean isNonJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject;
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        boolean answer = false;
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
        if (projectName != null && projectName.trim().length() > 0 && (javaProject = javaModel.getJavaProject(projectName)) != null && !javaProject.exists()) {
            answer = true;
        }
        return answer;
    }
}

