/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.deployment.maven;

import com.fusesource.rider.commons.ui.Selections;
import com.fusesource.rider.commons.ui.Workbenches;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.deployment.DeployPlugin;
import com.fusesource.rider.launcher.ui.ExecutePomActionSupport;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;

public class MavenUtils {
    public static String getBundleURI(Model mavenModel) {
        String answer = "mvn:" + mavenModel.getGroupId() + "/" + mavenModel.getArtifactId() + "/" + MavenUtils.getVersion(mavenModel);
        String packaging = mavenModel.getPackaging();
        if (Objects.equal((Object)"bundle", (Object)packaging)) {
            return answer;
        }
        if (Objects.equal((Object)"pom", (Object)packaging)) {
            return null;
        }
        if (Objects.equal((Object)"war", (Object)packaging)) {
            return "war:" + answer;
        }
        return "fab:" + answer;
    }

    public static String getVersion(Model mavenModel) {
        Parent parent;
        String answer = mavenModel.getVersion();
        if (Strings.isBlank((String)answer) && (parent = mavenModel.getParent()) != null) {
            answer = parent.getVersion();
        }
        return answer;
    }

    public static void launch(ExecutePomActionSupport action) {
        ISelection isel = Selections.getSelection((IWorkbenchSite)Workbenches.getActiveWorkbenchPartSite());
        Object first = Selections.getFirstSelection((ISelection)isel);
        if (isel == null || isel.isEmpty() || !(first instanceof IJavaElement) && !(first instanceof IResource)) {
            IEditorPart editor = DeployPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            action.launch(editor, "run");
        } else {
            action.launch(isel, "run");
        }
    }
}

