/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.deployment.preferences;

import com.fusesource.rider.deployment.ConfigurationUtils;
import com.fusesource.rider.deployment.Messages;
import com.fusesource.rider.deployment.config.HotfolderDeploymentConfiguration;
import java.io.File;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class DeploymentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String COLUMN_PROPERTY_DEFAULT = "default";
    private static final String COLUMN_PROPERTY_NAME = "name";
    private static final String COLUMN_PROPERTY_DESCRIPTION = "description";
    private static final String COLUMN_PROPERTY_DEPLOYPATH = "deploypath";
    private static final String[] COLUMN_PROPERTIES = new String[]{"default", "name", "deploypath", "description"};
    private static final int[] COLUMN_WIDTHS = new int[]{50, 150, 250, 350};
    private HotfolderDeploymentConfiguration[] deploymentConfigurations;
    private Text txt_name;
    private Text txt_description;
    private Text txt_deploypath;
    private Button btn_browseDeployFolder;
    private TableViewer tableViewer;
    private Table table;
    private Button makeDefaultButton;
    private Button addButton;
    private Button removeButton;
    private Button clearButton;

    public void init(IWorkbench workbench) {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(3, false);
        c.setLayout((Layout)gl);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)c, "com.fusesource.rider.editor.deployFolderPref");
        this.applyDialogFont(c);
        this.createContentControls(c);
        this.hookListeners();
        this.refreshFromModel();
        this.validateFormFields();
        return c;
    }

    protected void createContentControls(Composite parent) {
        this.createForm(parent);
        this.createTable(parent);
        this.createTableColumns(this.table);
        this.createTableViewer(this.table);
        this.initializeTableViewerProviders(this.tableViewer);
        Composite buttonColumn = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, true);
        gl.marginWidth = 0;
        buttonColumn.setLayout((Layout)gl);
        this.createButtons(buttonColumn);
    }

    protected void createForm(Composite parent) {
        Label label_name = new Label(parent, 0);
        label_name.setText(Messages.tableHeaderNameLabel);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        label_name.setLayoutData((Object)gd);
        this.txt_name = new Text(parent, 18432);
        this.txt_name.setText("");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.txt_name.setLayoutData((Object)gd);
        new Label(parent, 0);
        Label label_deployPath = new Label(parent, 0);
        label_deployPath.setText(Messages.tableHeaderDeployPathLabel);
        label_deployPath.setToolTipText(Messages.tableHeaderDeployPathToolTip);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        label_deployPath.setLayoutData((Object)gd);
        this.txt_deploypath = new Text(parent, 18432);
        this.txt_deploypath.setText("");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.txt_deploypath.setLayoutData((Object)gd);
        this.btn_browseDeployFolder = new Button(parent, 8);
        this.btn_browseDeployFolder.setText("...");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.btn_browseDeployFolder.setLayoutData((Object)gd);
        Label label_description = new Label(parent, 0);
        label_description.setText(Messages.tableHeaderDescriptionLabel);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        label_description.setLayoutData((Object)gd);
        this.txt_description = new Text(parent, 18432);
        this.txt_description.setText("");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        this.txt_description.setLayoutData((Object)gd);
        new Label(parent, 0);
        new Label(parent, 0);
        new Label(parent, 0);
        new Label(parent, 0);
        Composite btnCompo = new Composite(parent, 0);
        GridLayout gl = new GridLayout(3, false);
        btnCompo.setLayout((Layout)gl);
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.horizontalAlignment = 4;
        btnCompo.setLayoutData((Object)gd);
        this.addButton = new Button(btnCompo, 8);
        this.addButton.setText(Messages.addDeployConfigButtonLabel);
        this.addButton.setEnabled(false);
        this.setButtonLayoutData(this.addButton);
        this.removeButton = new Button(btnCompo, 8);
        this.removeButton.setText(Messages.removeDeployConfigButtonLabel);
        this.removeButton.setEnabled(false);
        this.setButtonLayoutData(this.removeButton);
        this.clearButton = new Button(btnCompo, 8);
        this.clearButton.setText(Messages.clearDeployConfigButtonLabel);
        this.clearButton.setEnabled(true);
        this.setButtonLayoutData(this.clearButton);
    }

    protected void createButtons(Composite parent) {
        this.makeDefaultButton = new Button(parent, 8);
        this.makeDefaultButton.setText(Messages.makeDefaultConfigButtonLabel);
        this.makeDefaultButton.setEnabled(true);
        this.setButtonLayoutData(this.makeDefaultButton);
    }

    private boolean isEditing() {
        return this.table.getSelectionCount() > 0 && ((HotfolderDeploymentConfiguration)this.table.getSelection()[0].getData()).getName().equals(this.txt_name.getText());
    }

    protected void addNewElement() {
        if (this.isEditing()) {
            HotfolderDeploymentConfiguration cfg = (HotfolderDeploymentConfiguration)this.table.getSelection()[0].getData();
            cfg.setDescription(this.txt_description.getText());
            cfg.setHotDeployPath(this.txt_deploypath.getText());
        } else {
            int n = this.deploymentConfigurations.length;
            HotfolderDeploymentConfiguration[] adc = new HotfolderDeploymentConfiguration[n + 1];
            System.arraycopy(this.deploymentConfigurations, 0, adc, 0, n);
            adc[n] = new HotfolderDeploymentConfiguration();
            adc[n].setDefaultConfig(n == 0);
            adc[n].setName(this.txt_name.getText());
            adc[n].setDescription(this.txt_description.getText());
            adc[n].setHotDeployPath(this.txt_deploypath.getText());
            this.deploymentConfigurations = adc;
            this.tableViewer.reveal((Object)adc[n]);
        }
        this.tableViewer.refresh();
        this.clearForm();
        this.clearSelection();
    }

    protected void clearSelection() {
        this.table.deselectAll();
    }

    protected void clearForm() {
        this.txt_name.setText("");
        this.txt_description.setText("");
        this.txt_deploypath.setText("");
        this.setErrorMessage(null);
    }

    protected void removeSelectedElements() {
        int j = 0;
        int n = this.deploymentConfigurations.length - this.table.getSelectionCount();
        HotfolderDeploymentConfiguration[] dcs = new HotfolderDeploymentConfiguration[n];
        int i = 0;
        while (i < this.table.getItemCount()) {
            if (!this.table.isSelected(i)) {
                dcs[j++] = this.deploymentConfigurations[i];
            }
            ++i;
        }
        this.deploymentConfigurations = dcs;
        this.tableViewer.refresh();
        this.clearForm();
        this.clearSelection();
    }

    protected void markSelectedElementAsDefault() {
        if (this.table.getSelectionCount() != 1) {
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)this.tableViewer.getSelection();
        if (sel.getFirstElement() != null) {
            HotfolderDeploymentConfiguration dep = (HotfolderDeploymentConfiguration)sel.getFirstElement();
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem ti = tableItemArray[n2];
                HotfolderDeploymentConfiguration cfg = (HotfolderDeploymentConfiguration)ti.getData();
                cfg.setDefaultConfig(false);
                ++n2;
            }
            dep.setDefaultConfig(true);
            this.tableViewer.refresh();
        }
    }

    protected Table createTable(Composite parent) {
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 300;
        this.table = new Table(parent, 68100);
        this.table.setLayoutData((Object)gd);
        return this.table;
    }

    protected void createTableColumns(Table tbl) {
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        TableColumn varDefault = new TableColumn(tbl, 0x1000000);
        TableColumn varName = new TableColumn(tbl, 16384);
        TableColumn varDeployPath = new TableColumn(tbl, 16384);
        TableColumn varDescription = new TableColumn(tbl, 16384);
        varDefault.setText(Messages.tableHeaderDefaultLabel);
        varDefault.setWidth(COLUMN_WIDTHS[0]);
        varName.setText(Messages.tableHeaderNameLabel);
        varName.setWidth(COLUMN_WIDTHS[1]);
        varDescription.setText(Messages.tableHeaderDescriptionLabel);
        varDescription.setWidth(COLUMN_WIDTHS[2]);
        varDeployPath.setText(Messages.tableHeaderDeployPathLabel);
        varDeployPath.setWidth(COLUMN_WIDTHS[3]);
    }

    protected TableContentProvider createTableContentProvider() {
        return new TableContentProvider();
    }

    protected TableLabelProvider createTableLabelProvider() {
        return new TableLabelProvider();
    }

    protected TableViewer createTableViewer(Table table) {
        this.tableViewer = new TableViewer(table);
        return this.tableViewer;
    }

    protected void hookListeners() {
        this.btn_browseDeployFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog ddlg = new DirectoryDialog(DeploymentPreferencePage.this.getShell(), 4096);
                ddlg.setMessage(Messages.containerFolderDialogDescription);
                ddlg.setText(Messages.containerFolderDialogTitle);
                ddlg.setFilterPath(DeploymentPreferencePage.this.txt_deploypath.getText().trim());
                String path = ddlg.open();
                if (path != null) {
                    DeploymentPreferencePage.this.txt_deploypath.setText(path);
                }
            }
        });
        this.clearButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentPreferencePage.this.clearForm();
                DeploymentPreferencePage.this.clearSelection();
                DeploymentPreferencePage.this.removeButton.setEnabled(false);
                DeploymentPreferencePage.this.validateFormFields();
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DeploymentPreferencePage.this.validateFormFields()) {
                    DeploymentPreferencePage.this.addNewElement();
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentPreferencePage.this.removeSelectedElements();
                DeploymentPreferencePage.this.removeButton.setEnabled(false);
            }
        });
        this.makeDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentPreferencePage.this.markSelectedElementAsDefault();
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeploymentPreferencePage.this.removeButton.setEnabled(DeploymentPreferencePage.this.table.getSelectionCount() > 0);
                DeploymentPreferencePage.this.displaySelection();
            }
        });
        this.txt_name.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeploymentPreferencePage.this.addButton.setEnabled(DeploymentPreferencePage.this.validateFormFields());
                DeploymentPreferencePage.this.updateButtons();
            }
        });
        this.txt_description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeploymentPreferencePage.this.validateFormFields();
            }
        });
        this.txt_deploypath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeploymentPreferencePage.this.addButton.setEnabled(DeploymentPreferencePage.this.validateFormFields());
                DeploymentPreferencePage.this.updateButtons();
            }
        });
    }

    private void updateButtons() {
        if (this.table.getSelectionCount() > 0 && this.table.getSelection().length > 0) {
            if (((HotfolderDeploymentConfiguration)this.table.getSelection()[0].getData()).getName().equals(this.txt_name.getText())) {
                this.addButton.setText(Messages.updateDeployConfigButtonLabel);
            } else {
                this.addButton.setText(Messages.addDeployConfigButtonLabel);
            }
        } else {
            this.addButton.setText(Messages.addDeployConfigButtonLabel);
        }
    }

    private boolean validateFormFields() {
        if (this.containsInvalidChars(this.txt_name.getText()) || this.containsInvalidChars(this.txt_description.getText()) || this.containsInvalidChars(this.txt_deploypath.getText())) {
            this.setErrorMessage(Messages.invalidCharsError);
            return false;
        }
        if (this.txt_name.getText().trim().length() < 1) {
            this.setErrorMessage(Messages.nameTooShortError);
            return false;
        }
        if (!this.isUniqueName(this.txt_name.getText().trim())) {
            this.setErrorMessage(Messages.nameNotUniqueError);
            return false;
        }
        if (this.txt_deploypath.getText().trim().length() < 1) {
            this.setErrorMessage(Messages.deployFolderTooShortError);
            return false;
        }
        if (!this.isValidFolder(this.txt_deploypath.getText().trim())) {
            this.setErrorMessage(Messages.deployFolderNotValidError);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean containsInvalidChars(String value) {
        return value.indexOf(44) != -1 || value.indexOf(59) != -1;
    }

    private boolean isUniqueName(String name) {
        if (this.isEditing()) {
            return true;
        }
        HotfolderDeploymentConfiguration[] hotfolderDeploymentConfigurationArray = this.deploymentConfigurations;
        int n = this.deploymentConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            HotfolderDeploymentConfiguration cfg = hotfolderDeploymentConfigurationArray[n2];
            if (cfg.getName().trim().equalsIgnoreCase(name)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isValidFolder(String folderPath) {
        File f = new File(folderPath);
        return f.exists() && f.isDirectory();
    }

    private void displaySelection() {
        this.clearForm();
        TableItem[] items = this.table.getSelection();
        if (items.length != 1) {
            return;
        }
        HotfolderDeploymentConfiguration config = (HotfolderDeploymentConfiguration)items[0].getData();
        this.txt_name.setText(config.getName());
        this.txt_description.setText(config.getDescription());
        this.txt_deploypath.setText(config.getHotDeployPath());
    }

    protected void initializeTableViewerProviders(TableViewer tv) {
        tv.setLabelProvider((IBaseLabelProvider)this.createTableLabelProvider());
        tv.setContentProvider((IContentProvider)this.createTableContentProvider());
    }

    public boolean performCancel() {
        this.refreshFromModel();
        return true;
    }

    public boolean performOk() {
        HotfolderDeploymentConfiguration[] dc = new HotfolderDeploymentConfiguration[this.deploymentConfigurations.length];
        int i = 0;
        while (i < dc.length) {
            dc[i] = new HotfolderDeploymentConfiguration();
            dc[i].setDefaultConfig(this.deploymentConfigurations[i].isDefaultConfig());
            dc[i].setName(this.deploymentConfigurations[i].getName());
            dc[i].setDescription(this.deploymentConfigurations[i].getDescription());
            dc[i].setHotDeployPath(this.deploymentConfigurations[i].getHotDeployPath());
            ++i;
        }
        this.deploymentConfigurations = dc;
        ConfigurationUtils.savePreferences(this.deploymentConfigurations);
        return true;
    }

    protected void refreshFromModel() {
        this.clearForm();
        this.clearSelection();
        this.deploymentConfigurations = ConfigurationUtils.loadPreferences();
        this.tableViewer.setInput((Object)this.deploymentConfigurations);
        this.tableViewer.refresh();
    }

    private final class TableContentProvider
    implements IStructuredContentProvider {
        private TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return DeploymentPreferencePage.this.deploymentConfigurations;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class TableLabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            HotfolderDeploymentConfiguration dc = (HotfolderDeploymentConfiguration)element;
            if (columnIndex == 0) {
                return Boolean.toString(dc.isDefaultConfig());
            }
            if (columnIndex == 1) {
                return dc.getName();
            }
            if (columnIndex == 2) {
                return dc.getHotDeployPath();
            }
            if (columnIndex == 3) {
                return dc.getDescription();
            }
            return "";
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

