/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.layout;

import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.layout.ReportEditorWithRuler;
import org.eclipse.birt.report.designer.internal.ui.palette.MasterPagePaletteFactory;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.ui.IEditorPart;

public abstract class ReportMasterPageEditor
extends ReportEditorWithRuler {
    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
    }

    protected void setContents() {
        this.setViewContentsAsMasterPage();
    }

    public void setViewContentsAsMasterPage() {
        ModuleHandle designHandle = this.getModel();
        SimpleMasterPageHandle masterPage = null;
        if (designHandle.getMasterPages().getCount() == 0) {
            masterPage = DesignElementFactory.getInstance((ModuleHandle)designHandle.getModuleHandle()).newSimpleMasterPage(null);
            try {
                designHandle.getMasterPages().add((DesignElementHandle)masterPage);
            }
            catch (ContentException e) {
                ExceptionUtil.handle((Throwable)e);
            }
            catch (NameException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        } else {
            masterPage = (SimpleMasterPageHandle)designHandle.getMasterPages().get(0);
        }
        this.getGraphicalViewer().setContents((Object)masterPage);
        this.hookModelEventManager(masterPage);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = MasterPagePaletteFactory.createPalette();
        }
        return this.paletteRoot;
    }

    public void performRequest(ReportRequest request) {
        if ("load masterpage".equals(request.getType()) && request.getSelectionModelList().size() == 1 && request.getSelectionModelList().get(0) instanceof MasterPageHandle) {
            this.handlerLoadMasterPage(request);
            return;
        }
        super.performRequest(request);
    }

    protected void handlerLoadMasterPage(ReportRequest request) {
        Object handle = request.getSelectionModelList().get(0);
        if (this.getGraphicalViewer().getContents().getModel() != handle) {
            this.getGraphicalViewer().setContents(handle);
            this.hookModelEventManager(handle);
        }
        super.performBreadcrumbRequest(request);
    }

    protected IEditorPart getMultiPageEditor() {
        return null;
    }
}

