/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.launcher;

import com.fusesource.rider.commons.contenttype.BlueprintXmlMatchingStrategy;
import com.fusesource.rider.commons.contenttype.XmlMatchingStrategySupport;
import com.fusesource.rider.launcher.MavenLaunchDelegate;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CamelRunMavenLaunchDelegate
extends MavenLaunchDelegate {
    private XmlMatchingStrategySupport blueprintXmlMatcher = new BlueprintXmlMatchingStrategy();

    public CamelRunMavenLaunchDelegate() {
        super("clean package org.apache.camel:camel-maven-plugin:run");
    }

    @Override
    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        String filePath = configuration.getAttribute("rider.file", "");
        if (filePath.trim().length() > 0) {
            boolean isBluePrint = this.isBlueprintFile(filePath);
            filePath = String.format(" -D%s=%s", "camel.fileApplicationContextUri", filePath);
            if (isBluePrint) {
                filePath = String.format("%s -D%s", filePath, "camel.blueprint=true");
            }
        }
        return String.valueOf(super.getGoals(configuration)) + filePath;
    }

    protected boolean isBlueprintFile(String filePath) {
        boolean isBlueprint = false;
        if (filePath != null && filePath.trim().length() > 0) {
            String rawPath = null;
            rawPath = filePath.startsWith("file:") ? filePath.substring(5) : filePath;
            Path f = new Path(rawPath);
            File nf = new File(f.toOSString());
            if (nf.exists() && nf.isFile()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(f.makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation()));
                isBlueprint = this.blueprintXmlMatcher.matches(file);
            }
        }
        return isBlueprint;
    }

    @Override
    public String getEclipseProcessName() {
        return "Local Camel Context";
    }
}

