/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.launcher;

import com.fusesource.rider.launcher.Activator;
import com.fusesource.rider.launcher.MavenLaunchUtils;
import com.fusesource.rider.launcher.MavenLauncherConfigurationHandler;
import com.fusesource.rider.sus.SubscriptionChecker;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.JavaLaunchDelegate;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MavenLaunchDelegate
extends JavaLaunchDelegate
implements MavenLaunchConstants {
    private static final Logger LOG = LoggerFactory.getLogger(MavenLaunchDelegate.class);
    private static final String LAUNCHER_TYPE = "org.codehaus.classworlds.Launcher";
    private static final String LAUNCHER_TYPE3 = "org.codehaus.plexus.classworlds.launcher.Launcher";
    private static final String LAUNCH_M2CONF_FILE = "org.eclipse.m2e.internal.launch.M2_CONF";
    private final String mavenGoals;
    private boolean workspaceResolution = false;
    private List<String> jvmProperties = Collections.EMPTY_LIST;
    private String mavenProfiles = null;
    private boolean updateSnapshots = false;
    private boolean mavenNonRecursive = false;
    private boolean mavenSkipTests = false;
    private String mavenUserSettings = null;
    private MavenRuntime runtime;
    private MavenLauncherConfigurationHandler m2conf;
    private File confFile;

    public MavenLaunchDelegate(String mavenGoals) {
        this.mavenGoals = mavenGoals;
    }

    protected void setSkipTests(boolean skipTests) {
        this.mavenSkipTests = skipTests;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!SubscriptionChecker.isDevSubscriptionValid()) {
            return;
        }
        LOG.info("" + this.getWorkingDirectory(configuration));
        LOG.info(" mvn" + this.getProgramArguments(configuration));
        this.runtime = MavenLaunchUtils.getMavenRuntime(configuration);
        this.m2conf = new MavenLauncherConfigurationHandler();
        if (this.shouldResolveWorkspaceArtifacts(configuration)) {
            this.m2conf.addArchiveEntry(MavenLaunchUtils.getCliResolver(this.runtime));
        }
        MavenLaunchUtils.addUserComponents(configuration, this.m2conf);
        this.runtime.createLauncherConfiguration((IMavenLauncherConfiguration)this.m2conf, monitor);
        File state = Activator.getInstance().getStateLocation().toFile();
        try {
            File dir = new File(state, "launches");
            dir.mkdirs();
            this.confFile = File.createTempFile("m2conf", ".tmp", dir);
            launch.setAttribute(LAUNCH_M2CONF_FILE, this.confFile.getCanonicalPath());
            FileOutputStream os = new FileOutputStream(this.confFile);
            try {
                this.m2conf.save(os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, "Can't create m2.conf ", (Throwable)e));
        }
        super.launch(configuration, mode, launch, monitor);
    }

    public IVMRunner getVMRunner(final ILaunchConfiguration configuration, String mode) throws CoreException {
        final IVMRunner runner = super.getVMRunner(configuration, mode);
        return new IVMRunner(){

            public void run(VMRunnerConfiguration runnerConfiguration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
                runner.run(runnerConfiguration, launch, monitor);
                IProcess[] processes = launch.getProcesses();
                if (processes != null && processes.length > 0) {
                    BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, launch);
                    refresher.init();
                } else {
                    MavenLaunchDelegate.removeTempFiles(launch);
                }
            }
        };
    }

    public String getMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return this.runtime.getVersion().startsWith("3.0") ? LAUNCHER_TYPE3 : LAUNCHER_TYPE;
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        List<String> cp = this.m2conf.getRealmEntries("]launcher");
        return cp.toArray(new String[cp.size()]);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        return String.valueOf(this.getProperties(configuration)) + this.getPreferences(configuration) + " " + this.getGoals(configuration);
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        StringBuffer sb = new StringBuffer();
        this.shouldResolveWorkspaceArtifacts(configuration);
        String location = this.runtime.getLocation();
        if (location != null) {
            sb.append(" -Dmaven.home=").append(this.quote(location));
        }
        sb.append(" -Dclassworlds.conf=").append(this.quote(this.confFile.getAbsolutePath()));
        sb.append(" ").append(super.getVMArguments(configuration));
        sb.append(" -DECLIPSE_PROCESS_NAME=\"'" + this.getEclipseProcessName() + "'\"");
        return sb.toString();
    }

    private String quote(String string) {
        return string.indexOf(32) > -1 ? "\"" + string + "\"" : string;
    }

    private boolean shouldResolveWorkspaceArtifacts(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("M2_WORKSPACE_RESOLUTION", this.workspaceResolution);
    }

    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("M2_GOALS", this.mavenGoals);
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) {
        return false;
    }

    private String getProperties(ILaunchConfiguration configuration) {
        String msg;
        StringBuffer sb = new StringBuffer();
        try {
            List properties = configuration.getAttribute("M2_PROPERTIES", this.jvmProperties);
            for (String property : properties) {
                int n = property.indexOf(61);
                String name = property;
                String value = null;
                if (n > -1) {
                    name = property.substring(0, n);
                    if (n > 1) {
                        value = MavenLaunchUtils.substituteVar(property.substring(n + 1));
                    }
                }
                sb.append(" -D").append(name);
                if (value == null) continue;
                sb.append('=').append(this.quote(value));
            }
        }
        catch (CoreException e) {
            msg = "Exception while getting configuration attribute M2_PROPERTIES";
            LOG.error(msg, (Throwable)e);
        }
        try {
            String profiles = configuration.getAttribute("M2_PROFILES", this.mavenProfiles);
            if (profiles != null && profiles.trim().length() > 0) {
                sb.append(" -P").append(profiles.replaceAll("\\s+", ","));
            }
        }
        catch (CoreException ex) {
            msg = "Exception while getting configuration attribute M2_PROFILES";
            LOG.error(msg, (Throwable)ex);
        }
        return sb.toString();
    }

    protected String getPreferences(ILaunchConfiguration configuration) throws CoreException {
        String settings;
        MavenPlugin.getDefault();
        IMavenConfiguration mavenConfiguration = MavenPlugin.getMavenConfiguration();
        StringBuffer sb = new StringBuffer();
        sb.append(" -B");
        if (configuration.getAttribute("M2_DEBUG_OUTPUT", mavenConfiguration.isDebugOutput())) {
            sb.append(" -X").append(" -e");
        }
        if (configuration.getAttribute("M2_OFFLINE", mavenConfiguration.isOffline())) {
            sb.append(" -o");
        }
        if (configuration.getAttribute("M2_UPDATE_SNAPSHOTS", this.updateSnapshots)) {
            sb.append(" -U");
        }
        if (configuration.getAttribute("M2_NON_RECURSIVE", this.mavenNonRecursive)) {
            sb.append(" -N");
        }
        if (configuration.getAttribute("M2_SKIP_TESTS", this.mavenSkipTests)) {
            sb.append(" -Dmaven.test.skip=true");
        }
        if (!((settings = configuration.getAttribute("M2_USER_SETTINGS", this.mavenUserSettings)) != null && settings.trim().length() > 0 || (settings = mavenConfiguration.getUserSettingsFile()) == null || settings.trim().length() <= 0 || new File(settings.trim()).exists())) {
            settings = null;
        }
        if (settings != null && settings.trim().length() > 0) {
            sb.append(" -s ").append(this.quote(settings));
        }
        return sb.toString();
    }

    static void removeTempFiles(ILaunch launch) {
        String m2confName = launch.getAttribute(LAUNCH_M2CONF_FILE);
        if (m2confName != null) {
            new File(m2confName).delete();
        }
    }

    public abstract String getEclipseProcessName();

    public static class BackgroundResourceRefresher
    implements IDebugEventSetListener {
        final ILaunchConfiguration configuration;
        final IProcess process;
        final ILaunch launch;

        public BackgroundResourceRefresher(ILaunchConfiguration configuration, ILaunch launch) {
            this.configuration = configuration;
            this.process = launch.getProcesses()[0];
            this.launch = launch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() {
            IProcess iProcess = this.process;
            synchronized (iProcess) {
                if (this.process.isTerminated()) {
                    this.processResources();
                } else {
                    DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
                }
            }
        }

        public void handleDebugEvents(DebugEvent[] events) {
            int i = 0;
            while (i < events.length) {
                DebugEvent event = events[i];
                if (event.getSource() == this.process && event.getKind() == 8) {
                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                    this.processResources();
                    break;
                }
                ++i;
            }
        }

        protected void processResources() {
            MavenLaunchDelegate.removeTempFiles(this.launch);
            Job job = new Job("Refreshing resources..."){

                public IStatus run(IProgressMonitor monitor) {
                    try {
                        RefreshTab.refreshResources((ILaunchConfiguration)BackgroundResourceRefresher.this.configuration, (IProgressMonitor)monitor);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        LOG.error("Error refreshing resources...", (Throwable)e);
                        return e.getStatus();
                    }
                }
            };
            job.schedule();
        }
    }
}

