/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.launcher;

import com.fusesource.rider.launcher.Activator;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.embedder.MavenRuntimeManager;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenLaunchUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MavenLaunchUtils.class);

    public static MavenRuntime getMavenRuntime(ILaunchConfiguration configuration) throws CoreException {
        String location;
        MavenRuntimeManager runtimeManager = MavenPlugin.getMavenRuntimeManager();
        MavenRuntime runtime = runtimeManager.getRuntime(location = configuration.getAttribute("M2_RUNTIME", ""));
        if (runtime == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, "Can't find Maven installation " + location, null));
        }
        return runtime;
    }

    public static String getCliResolver(MavenRuntime runtime) throws CoreException {
        String runtimeVersion = runtime.getVersion();
        String jarname = runtimeVersion.startsWith("3.") ? "org.maven.ide.eclipse.cliresolver30.jar" : "org.maven.ide.eclipse.cliresolver.jar";
        URL url = Activator.getInstance().getBundle().getEntry(jarname);
        try {
            URL fileURL = FileLocator.toFileURL((URL)url);
            URI fileURI = new URI(fileURL.getProtocol(), fileURL.getHost(), fileURL.getPath(), fileURL.getQuery());
            return new File(fileURI).getCanonicalPath();
        }
        catch (Exception ex) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, ex.getMessage(), (Throwable)ex));
        }
    }

    public static void addUserComponents(ILaunchConfiguration configuration, IMavenLauncherConfiguration collector) throws CoreException {
        List list = configuration.getAttribute("M2_FORCED_COMPONENTS_LIST", new ArrayList());
        if (list == null) {
            return;
        }
        IMaven maven = MavenPlugin.getMaven();
        for (String gav : list) {
            StringTokenizer st = new StringTokenizer(gav, ":");
            String groupId = st.nextToken();
            String artifactId = st.nextToken();
            String version = st.nextToken();
            IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().getMavenProject(groupId, artifactId, version);
            if (facade != null) {
                collector.addProjectEntry(facade);
                continue;
            }
            String name = String.valueOf(groupId) + ":" + artifactId + ":" + version;
            try {
                Artifact artifact = maven.resolve(groupId, artifactId, version, "jar", null, null, null);
                File file = artifact.getFile();
                if (file == null) continue;
                collector.addArchiveEntry(file.getAbsolutePath());
            }
            catch (CoreException ex) {
                LOG.error("Artifact not found " + name, (Throwable)ex);
            }
        }
    }

    public static String substituteVar(String s) {
        if (s == null) {
            return s;
        }
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
        }
        catch (CoreException e) {
            LOG.error("Could not substitute variable {}.", (Object)s, (Object)e);
            return null;
        }
    }
}

