/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.fmc.activemq.facade.JmxTemplateBrokerFacade;
import com.fusesource.fmc.activemq.facade.RemoteBrokerFacade;
import com.fusesource.ide.fabric.activemq.FabricActiveMQPlugin;
import com.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import com.fusesource.ide.fabric.navigator.ContainerNode;
import com.fusesource.ide.jmx.core.IJMXRunnable;
import com.fusesource.ide.jmx.core.JMXException;
import com.fusesource.ide.jmx.core.tree.NodeProvider;
import com.fusesource.ide.jmx.core.tree.Root;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.sus.SubscriptionChecker;
import java.util.List;
import javax.management.MBeanServerConnection;
import org.eclipse.core.runtime.CoreException;

public class ActiveMQNodeProvider
implements com.fusesource.ide.fabric.navigator.NodeProvider,
NodeProvider {
    public void provide(ContainerNode agentNode) {
        if (!SubscriptionChecker.isDevSubscriptionValid()) {
            return;
        }
        JmxTemplateBrokerFacade facade = new JmxTemplateBrokerFacade(agentNode.getJmxTemplate());
        String brokerName = null;
        try {
            brokerName = facade.getBrokerName();
        }
        catch (Exception e) {
            FabricActiveMQPlugin.getLogger().warning("Could not find Broker name: " + e, (Throwable)e);
        }
        if (brokerName == null) {
            brokerName = "Broker";
        }
        agentNode.addChild((Node)new BrokerNode((Node)agentNode, (BrokerFacade)facade, brokerName));
    }

    public void provide(final Root root) {
        if (!SubscriptionChecker.isDevSubscriptionValid()) {
            return;
        }
        if (root.containsDomain("org.apache.activemq")) {
            try {
                root.getConnection().run(new IJMXRunnable(){

                    public void run(MBeanServerConnection connection) throws JMXException {
                        RemoteBrokerFacade facade = new RemoteBrokerFacade(connection);
                        BrokerNode broker = new BrokerNode((Node)root, (BrokerFacade)facade, "Broker");
                        root.addChild((Node)broker);
                    }
                });
            }
            catch (CoreException e) {
                FabricActiveMQPlugin.getLogger().warning("Failed to connect to JMX: " + (Object)((Object)e), (Throwable)e);
            }
        }
    }

    public void provideRootNodes(List list) {
    }
}

