/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.FabricActiveMQPlugin;
import com.fusesource.ide.fabric.activemq.navigator.ConnectionsNode;
import com.fusesource.ide.fabric.activemq.navigator.QueuesNode;
import com.fusesource.ide.fabric.activemq.navigator.TopicsNode;
import com.fusesource.rider.commons.Activator;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.NodeSupport;
import com.fusesource.rider.commons.tree.Refreshable;
import com.fusesource.rider.commons.ui.ImageProvider;
import org.eclipse.swt.graphics.Image;

public class BrokerNode
extends NodeSupport
implements ImageProvider,
Refreshable {
    private final BrokerFacade facade;
    private final String brokerName;
    private String userName;
    private String password;

    public BrokerNode(Node parent, BrokerFacade facade, String brokerName) {
        super(parent);
        this.facade = facade;
        this.brokerName = brokerName;
        this.addChild((Node)new QueuesNode(this));
        this.addChild((Node)new TopicsNode(this));
        this.addChild((Node)new ConnectionsNode(this));
        try {
            this.setPropertyBean(facade.getBrokerAdmin());
        }
        catch (Exception e) {
            Activator.getLogger().warning("Failed to get broker admin: " + e, (Throwable)e);
        }
    }

    public String toString() {
        return this.brokerName;
    }

    public BrokerFacade getFacade() {
        return this.facade;
    }

    public void refresh() {
        if (this.getParent() instanceof Refreshable) {
            Refreshable refreshable = (Refreshable)this.getParent();
            refreshable.refresh();
        }
    }

    public void handleException(Node node, Exception e) {
        FabricActiveMQPlugin.getLogger().warning("Failed to load node " + node + " due to: " + e, (Throwable)e);
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("fuse-broker.gif");
    }
}

