/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.fmc.activemq.facade.ConnectionViewFacade;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import com.fusesource.ide.fabric.activemq.navigator.ConnectionNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.ui.ImageProvider;
import java.util.Collection;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;

public class ConnectionsNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;

    public ConnectionsNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
        this.facade = brokerNode.getFacade();
    }

    public String toString() {
        return "Connections";
    }

    protected void loadChildren() {
        try {
            Collection list = this.facade.getConnections();
            if (list != null) {
                for (ConnectionViewFacade mbean : list) {
                    this.addChild((Node)new ConnectionNode((Node)this, (ConnectionViewMBean)mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/listeners.gif");
    }

    public void provideContextMenu(IMenuManager menu) {
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

