/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.FabricActiveMQPlugin;
import com.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import com.fusesource.ide.fabric.activemq.navigator.JmsTypeConverters;
import com.fusesource.ide.fabric.navigator.MessageDropHandler;
import com.fusesource.ide.fabric.navigator.MessageDropTarget;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.NodeSupport;
import com.fusesource.rider.commons.ui.drop.DropHandler;
import com.fusesource.rider.commons.ui.drop.DropHandlerFactory;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.Strings;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IMessage;

public abstract class DestinationNodeSupport
extends NodeSupport
implements MessageDropTarget,
DropHandlerFactory {
    protected Set<String> ignoreSendHeaders = new HashSet<String>(Arrays.asList("JMSDestination", "JMSMessageID"));
    private final BrokerNode brokerNode;
    private final DestinationViewMBean destination;

    public DestinationNodeSupport(Node parent, BrokerNode brokerNode, DestinationViewMBean destination) {
        super(parent);
        this.brokerNode = brokerNode;
        this.destination = destination;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.destination.getName();
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        return new MessageDropHandler((MessageDropTarget)this);
    }

    public void dropMessage(IMessage message) {
        Map headers = message.getHeaders();
        HashMap cleanHeaders = new HashMap();
        Set entrySet = headers.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null || this.ignoreSendHeaders.contains(key)) continue;
            if (Objects.equal((Object)"JMSReplyTo", (Object)key)) {
                value = JmsTypeConverters.toDestination(value);
            } else if (Objects.equal((Object)"JMSExpiration", (Object)key)) {
                value = JmsTypeConverters.toTimestamp(value);
            } else if (Objects.equal((Object)"JMSTimestamp", (Object)key)) {
                value = JmsTypeConverters.toTimestamp(value);
            } else if (Objects.equal((Object)"JMSDeliveryMode", (Object)key)) {
                value = JmsTypeConverters.toDeliveryMode(value);
            } else if (Objects.equal((Object)"JMSRedelivered", (Object)key)) {
                value = JmsTypeConverters.toBoolean(value);
            } else if (Objects.equal((Object)"JMSPriority", (Object)key)) {
                value = JmsTypeConverters.toInteger(value);
            }
            if (value == null) continue;
            cleanHeaders.put(key, value);
        }
        String body = Strings.getOrElse((Object)message.getBody());
        try {
            String userName = this.getBrokerNode().getUserName();
            String password = this.getBrokerNode().getPassword();
            if (userName != null && password != null) {
                this.destination.sendTextMessage(cleanHeaders, body, userName, password);
            } else {
                this.destination.sendTextMessage(cleanHeaders, body);
            }
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)("Send message to " + (Object)((Object)this) + " failed"), (String)("Could not send message to " + (Object)((Object)this)), (Exception)e);
        }
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public DestinationViewMBean getDestination() {
        return this.destination;
    }

    protected IExchange createExchange(Object object) {
        return FabricActiveMQPlugin.getConverter().toExchange(object);
    }
}

