/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.FabricActiveMQPlugin;
import com.fusesource.ide.fabric.activemq.Messages;
import com.fusesource.ide.fabric.activemq.navigator.DestinationNodeSupport;
import com.fusesource.ide.fabric.activemq.navigator.QueueConsumersNode;
import com.fusesource.ide.fabric.activemq.navigator.QueueProducersNode;
import com.fusesource.ide.fabric.activemq.navigator.QueuesNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.ConnectedNode;
import com.fusesource.rider.commons.tree.GraphableNode;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.Shells;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jms.InvalidSelectorException;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.fusesource.fon.util.messages.IExchange;
import org.fusesource.fon.util.messages.IExchangeBrowser;

public class QueueNode
extends DestinationNodeSupport
implements IExchangeBrowser,
ImageProvider,
ContextMenuProvider,
IPropertySourceProvider,
GraphableNode,
ConnectedNode {
    private final QueuesNode queuesNode;
    private final QueueViewMBean queue;
    private final QueueConsumersNode consumersNode;
    private final QueueProducersNode producersNode;

    public QueueNode(QueuesNode queuesNode, QueueViewMBean queue) {
        super((Node)queuesNode, queuesNode.getBrokerNode(), (DestinationViewMBean)queue);
        this.queuesNode = queuesNode;
        this.queue = queue;
        this.consumersNode = new QueueConsumersNode(this);
        this.addChild((Node)this.consumersNode);
        this.producersNode = new QueueProducersNode(this);
        this.addChild((Node)this.producersNode);
        this.setPropertyBean(queue);
    }

    public QueuesNode getQueuesNode() {
        return this.queuesNode;
    }

    public QueueViewMBean getQueue() {
        return this.queue;
    }

    public List<Node> getChildrenGraph() {
        ArrayList<Node> answer = new ArrayList<Node>();
        answer.addAll(Arrays.asList(this.consumersNode.getChildren()));
        answer.addAll(Arrays.asList(this.producersNode.getChildren()));
        return answer;
    }

    public List<?> getConnectedTo() {
        return this.getConsumersNode().getChildrenList();
    }

    public QueueConsumersNode getConsumersNode() {
        return this.consumersNode;
    }

    public QueueProducersNode getProducersNode() {
        return this.producersNode;
    }

    public List<IExchange> browseExchanges() {
        ArrayList<IExchange> answer = new ArrayList<IExchange>();
        try {
            List messages = this.queue.browseMessages();
            for (Object object : messages) {
                IExchange exchange = this.createExchange(object);
                if (exchange == null) continue;
                answer.add(exchange);
            }
        }
        catch (InvalidSelectorException e) {
            FabricActiveMQPlugin.getLogger().warning("Failed to browse queue " + (Object)((Object)e), (Throwable)e);
        }
        return answer;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/queue.gif");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action traceAction = new Action(Messages.DeleteQueueAction, 32){

            public void run() {
                QueueNode.this.showDeleteQueueDialog();
            }
        };
        traceAction.setToolTipText(Messages.DeleteQueueActionToolTip);
        traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("delete.gif"));
        menu.add((IAction)traceAction);
    }

    protected void showDeleteQueueDialog() {
        String message = Messages.bind((String)Messages.DeleteQueueDialogMessage, (Object)this.queue.getName());
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)Messages.DeleteQueueDialogTitle, (String)message);
        if (confirm) {
            this.deleteQueue();
        }
    }

    protected void deleteQueue() {
        String name = this.queue.getName();
        try {
            this.getFacade().getBrokerAdmin().removeQueue(name);
            this.queuesNode.refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)"Failed to delete Queue", (String)("Failed to delete queue: " + this.queue), (Exception)e);
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

