/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.fmc.activemq.facade.ProducerViewFacade;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import com.fusesource.ide.fabric.activemq.navigator.ProducerNode;
import com.fusesource.ide.fabric.activemq.navigator.QueueNode;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.ui.ImageProvider;
import java.util.Collection;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.eclipse.swt.graphics.Image;

public class QueueProducersNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;
    private final QueueNode queueNode;

    public QueueProducersNode(QueueNode queueNode) {
        super((Node)queueNode);
        this.queueNode = queueNode;
        this.brokerNode = queueNode.getBrokerNode();
        this.facade = queueNode.getFacade();
    }

    public String toString() {
        return "Producers";
    }

    protected void loadChildren() {
        try {
            String name = this.queueNode.getName();
            Collection list = this.getFacade().getQueueProducers(name);
            if (list != null) {
                for (ProducerViewFacade mbean : list) {
                    this.addChild((Node)new ProducerNode((Node)this, (Node)this.queueNode, (ProducerViewMBean)mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/listeners.gif");
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

