/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.fmc.activemq.facade.QueueViewFacade;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.Messages;
import com.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import com.fusesource.ide.fabric.activemq.navigator.QueueNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.Shells;
import com.fusesource.rider.commons.util.Strings;
import java.util.Collection;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;

public class QueuesNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;

    public QueuesNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
        this.facade = brokerNode.getFacade();
    }

    public String toString() {
        return "Queues";
    }

    protected void loadChildren() {
        try {
            Collection queues = this.facade.getQueues();
            if (queues != null) {
                for (QueueViewFacade queue : queues) {
                    this.addChild((Node)new QueueNode(this, (QueueViewMBean)queue));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/queue.gif");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action traceAction = new Action(Messages.CreateQueueAction, 32){

            public void run() {
                QueuesNode.this.showCreateQueueDialog();
            }
        };
        traceAction.setToolTipText(Messages.CreateQueueActionToolTip);
        traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("add_destination.gif"));
        menu.add((IAction)traceAction);
    }

    protected void showCreateQueueDialog() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.CreateQueueDialogTitle, Messages.CreateQueueDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String queue = dialog.getValue();
            this.createQueue(queue);
        }
    }

    protected void createQueue(String queue) {
        if (!Strings.isBlank((String)queue)) {
            try {
                this.getFacade().getBrokerAdmin().addQueue(queue);
                this.refresh();
            }
            catch (Exception e) {
                FabricPlugin.showUserError((String)"Failed to create Queue", (String)("Failed to create queue: " + queue), (Exception)e);
            }
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

