/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.Messages;
import com.fusesource.ide.fabric.activemq.navigator.DestinationNodeSupport;
import com.fusesource.ide.fabric.activemq.navigator.TopicConsumersNode;
import com.fusesource.ide.fabric.activemq.navigator.TopicDurableConsumersNode;
import com.fusesource.ide.fabric.activemq.navigator.TopicProducersNode;
import com.fusesource.ide.fabric.activemq.navigator.TopicsNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.ConnectedNode;
import com.fusesource.rider.commons.tree.GraphableNode;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.Shells;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;

public class TopicNode
extends DestinationNodeSupport
implements ImageProvider,
ContextMenuProvider,
GraphableNode,
ConnectedNode {
    private final TopicsNode topicsNode;
    private final TopicViewMBean topic;
    private final TopicConsumersNode consumersNode;
    private final TopicProducersNode producersNode;
    private final TopicDurableConsumersNode durableConsumersNode;

    public TopicNode(TopicsNode topicsNode, TopicViewMBean topic) {
        super((Node)topicsNode, topicsNode.getBrokerNode(), (DestinationViewMBean)topic);
        this.topicsNode = topicsNode;
        this.topic = topic;
        this.consumersNode = new TopicConsumersNode(this);
        this.durableConsumersNode = new TopicDurableConsumersNode(this);
        this.producersNode = new TopicProducersNode(this);
        this.addChild((Node)this.consumersNode);
        this.addChild((Node)this.durableConsumersNode);
        this.addChild((Node)this.producersNode);
        this.setPropertyBean(topic);
    }

    @Override
    public String toString() {
        return this.topic.getName();
    }

    public TopicsNode getTopicsNode() {
        return this.topicsNode;
    }

    public TopicViewMBean getTopic() {
        return this.topic;
    }

    public List<Node> getConsumerChildren() {
        ArrayList<Node> answer = new ArrayList<Node>();
        answer.addAll(Arrays.asList(this.consumersNode.getChildren()));
        answer.addAll(Arrays.asList(this.durableConsumersNode.getChildren()));
        return answer;
    }

    public List<Node> getChildrenGraph() {
        List<Node> answer = this.getConsumerChildren();
        answer.addAll(Arrays.asList(this.producersNode.getChildren()));
        return answer;
    }

    public List<?> getConnectedTo() {
        return this.getConsumerChildren();
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/topic.gif");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action traceAction = new Action(Messages.DeleteTopicAction, 32){

            public void run() {
                TopicNode.this.showDeleteTopicDialog();
            }
        };
        traceAction.setToolTipText(Messages.DeleteTopicActionToolTip);
        traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("delete.gif"));
        menu.add((IAction)traceAction);
    }

    protected void showDeleteTopicDialog() {
        String message = Messages.bind((String)Messages.DeleteTopicDialogMessage, (Object)this.topic.getName());
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)Messages.DeleteTopicDialogTitle, (String)message);
        if (confirm) {
            this.deleteTopic();
        }
    }

    protected void deleteTopic() {
        String name = this.topic.getName();
        try {
            this.getFacade().getBrokerAdmin().removeTopic(name);
            this.topicsNode.refresh();
        }
        catch (Exception e) {
            FabricPlugin.showUserError((String)"Failed to delete Topic", (String)("Failed to delete topic: " + this.topic), (Exception)e);
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

