/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.fmc.activemq.facade.ProducerViewFacade;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import com.fusesource.ide.fabric.activemq.navigator.ProducerNode;
import com.fusesource.ide.fabric.activemq.navigator.TopicNode;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.ui.ImageProvider;
import java.util.Collection;
import org.apache.activemq.broker.jmx.ProducerViewMBean;
import org.eclipse.swt.graphics.Image;

public class TopicProducersNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;
    private final TopicNode topicNode;

    public TopicProducersNode(TopicNode topicNode) {
        super((Node)topicNode);
        this.topicNode = topicNode;
        this.brokerNode = topicNode.getBrokerNode();
        this.facade = topicNode.getFacade();
    }

    public String toString() {
        return "Producers";
    }

    protected void loadChildren() {
        try {
            Collection list = this.getFacade().getTopicProducers(this.topicNode.getName());
            if (list != null) {
                for (ProducerViewFacade mbean : list) {
                    this.addChild((Node)new ProducerNode((Node)this, (Node)this.topicNode, (ProducerViewMBean)mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/listeners.gif");
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

