/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.ide.fabric.activemq.navigator;

import com.fusesource.fmc.activemq.facade.BrokerFacade;
import com.fusesource.fmc.activemq.facade.TopicViewFacade;
import com.fusesource.ide.fabric.FabricPlugin;
import com.fusesource.ide.fabric.activemq.Messages;
import com.fusesource.ide.fabric.activemq.navigator.BrokerNode;
import com.fusesource.ide.fabric.activemq.navigator.TopicNode;
import com.fusesource.ide.jmx.ui.internal.views.navigator.ContextMenuProvider;
import com.fusesource.rider.commons.tree.Node;
import com.fusesource.rider.commons.tree.RefreshableCollectionNode;
import com.fusesource.rider.commons.ui.ImageProvider;
import com.fusesource.rider.commons.ui.Shells;
import com.fusesource.rider.commons.util.Strings;
import java.util.Collection;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.graphics.Image;

public class TopicsNode
extends RefreshableCollectionNode
implements ImageProvider,
ContextMenuProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;

    public TopicsNode(BrokerNode brokerNode) {
        super((Node)brokerNode);
        this.brokerNode = brokerNode;
        this.facade = brokerNode.getFacade();
    }

    public String toString() {
        return "Topics";
    }

    protected void loadChildren() {
        try {
            Collection topics = this.facade.getTopics();
            if (topics != null) {
                for (TopicViewFacade topic : topics) {
                    this.addChild((Node)new TopicNode(this, (TopicViewMBean)topic));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return FabricPlugin.getDefault().getImage("jms/topic.gif");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action traceAction = new Action(Messages.CreateTopicAction, 32){

            public void run() {
                TopicsNode.this.showCreateTopicDialog();
            }
        };
        traceAction.setToolTipText(Messages.CreateTopicActionToolTip);
        traceAction.setImageDescriptor(FabricPlugin.getDefault().getImageDescriptor("add_destination.gif"));
        menu.add((IAction)traceAction);
    }

    protected void showCreateTopicDialog() {
        InputDialog dialog = new InputDialog(Shells.getShell(), Messages.CreateTopicDialogTitle, Messages.CreateTopicDialogMessage, "", null);
        int result = dialog.open();
        if (result == 0) {
            String topic = dialog.getValue();
            this.createTopic(topic);
        }
    }

    protected void createTopic(String topic) {
        if (!Strings.isBlank((String)topic)) {
            try {
                this.getFacade().getBrokerAdmin().addTopic(topic);
                this.refresh();
            }
            catch (Exception e) {
                FabricPlugin.showUserError((String)"Failed to create Topic", (String)("Failed to create topic: " + topic), (Exception)e);
            }
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }
}

