/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.net4j.buffer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.text.MessageFormat;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferState;
import org.eclipse.net4j.buffer.IBufferProvider;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.IErrorHandler;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;
import org.eclipse.spi.net4j.InternalBuffer;

public class Buffer
implements InternalBuffer {
    public static final int EOS_OFFSET = 1;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER, Buffer.class);
    private IErrorHandler errorHandler;
    private IBufferProvider bufferProvider;
    private short channelID;
    private boolean eos;
    private BufferState state = BufferState.INITIAL;
    private ByteBuffer byteBuffer;

    public Buffer(IBufferProvider provider, short capacity) {
        this.bufferProvider = provider;
        this.byteBuffer = ByteBuffer.allocateDirect(capacity);
    }

    public boolean isEOS() {
        return this.eos;
    }

    public void setEOS(boolean eos) {
        this.eos = eos;
    }

    public IBufferProvider getBufferProvider() {
        return this.bufferProvider;
    }

    public void setBufferProvider(IBufferProvider bufferProvider) {
        this.bufferProvider = bufferProvider;
    }

    public short getChannelID() {
        if (this.state == BufferState.INITIAL || this.state == BufferState.READING_HEADER) {
            throw new IllegalStateException(this.toString());
        }
        return this.channelID;
    }

    public void setChannelID(short channelID) {
        this.channelID = channelID;
    }

    public short getCapacity() {
        return (short)this.byteBuffer.capacity();
    }

    public BufferState getState() {
        return this.state;
    }

    public void setState(BufferState state) {
        this.state = state;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setByteBuffer(ByteBuffer buffer) {
        this.byteBuffer = buffer;
    }

    public void clear() {
        this.state = BufferState.INITIAL;
        this.channelID = Short.MIN_VALUE;
        this.eos = false;
        this.byteBuffer.clear();
    }

    public void release() {
        if (this.state != BufferState.RELEASED) {
            this.state = BufferState.RELEASED;
            this.errorHandler = null;
            if (this.bufferProvider != null) {
                this.bufferProvider.retainBuffer(this);
            }
        }
    }

    public void dispose() {
        this.state = BufferState.DISPOSED;
        this.bufferProvider = null;
        this.byteBuffer = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer startGetting(SocketChannel socketChannel) throws IOException {
        try {
            if (this.state != BufferState.INITIAL && this.state != BufferState.READING_HEADER && this.state != BufferState.READING_BODY) {
                throw new IllegalStateException(this.toString());
            }
            if (this.state == BufferState.INITIAL) {
                this.byteBuffer.limit(4);
                this.state = BufferState.READING_HEADER;
            }
            if (this.state == BufferState.READING_HEADER) {
                Buffer.readChannel(socketChannel, this.byteBuffer);
                if (this.byteBuffer.hasRemaining()) {
                    return null;
                }
                this.byteBuffer.flip();
                this.channelID = this.byteBuffer.getShort();
                short payloadSize = this.byteBuffer.getShort();
                if (payloadSize < 0) {
                    this.eos = true;
                    payloadSize = -payloadSize;
                }
                payloadSize = (short)(payloadSize - 1);
                this.byteBuffer.clear();
                this.byteBuffer.limit(payloadSize);
                this.state = BufferState.READING_BODY;
            }
            Buffer.readChannel(socketChannel, this.byteBuffer);
            if (this.byteBuffer.hasRemaining()) {
                return null;
            }
            if (TRACER.isEnabled()) {
                TRACER.trace("Read " + this.byteBuffer.limit() + " bytes" + (this.eos ? " (EOS)" : "") + StringUtil.NL + this.formatContent(false));
            }
            this.byteBuffer.flip();
            this.state = BufferState.GETTING;
            return this.byteBuffer;
        }
        catch (IOException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public ByteBuffer startPutting(short channelID) {
        try {
            if (this.state == BufferState.PUTTING) {
                if (channelID != this.channelID) {
                    throw new IllegalArgumentException("channelID != this.channelID");
                }
            } else {
                if (this.state != BufferState.INITIAL) {
                    throw new IllegalStateException("state: " + (Object)((Object)this.state));
                }
                this.state = BufferState.PUTTING;
                this.channelID = channelID;
                this.byteBuffer.clear();
                this.byteBuffer.position(4);
            }
            return this.byteBuffer;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public boolean write(SocketChannel socketChannel) throws IOException {
        block11: {
            int numBytes;
            if (this.state != BufferState.PUTTING && this.state != BufferState.WRITING) {
                throw new IllegalStateException(this.toString());
            }
            if (this.state == BufferState.PUTTING) {
                if (this.channelID == Short.MIN_VALUE) {
                    throw new IllegalStateException("channelID == NO_CHANNEL");
                }
                int payloadSize = this.byteBuffer.position() - 4 + 1;
                if (this.eos) {
                    payloadSize = -payloadSize;
                }
                if (TRACER.isEnabled()) {
                    TRACER.trace("Writing " + (Math.abs(payloadSize) - 1) + " bytes" + (this.eos ? " (EOS)" : "") + StringUtil.NL + this.formatContent(false));
                }
                this.byteBuffer.flip();
                this.byteBuffer.putShort(this.channelID);
                this.byteBuffer.putShort((short)payloadSize);
                this.byteBuffer.position(0);
                this.state = BufferState.WRITING;
            }
            if ((numBytes = socketChannel.write(this.byteBuffer)) == -1) {
                throw new IOException("Channel closed");
            }
            if (!this.byteBuffer.hasRemaining()) break block11;
            return false;
        }
        try {
            this.clear();
            return true;
        }
        catch (IOException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public void flip() {
        try {
            if (this.state != BufferState.PUTTING) {
                throw new IllegalStateException(this.toString());
            }
            this.byteBuffer.flip();
            this.byteBuffer.position(4);
            this.state = BufferState.GETTING;
        }
        catch (RuntimeException ex) {
            this.handleError(ex);
            throw ex;
        }
        catch (Error ex) {
            this.handleError(ex);
            throw ex;
        }
    }

    public String toString() {
        return MessageFormat.format("Buffer@{0}[{1}]", new Object[]{ReflectUtil.getID((Object)this), this.state});
    }

    public String formatContent(boolean showHeader) {
        int oldPosition = this.byteBuffer.position();
        int oldLimit = this.byteBuffer.limit();
        try {
            if (this.state != BufferState.GETTING) {
                this.byteBuffer.flip();
            }
            if (this.state == BufferState.PUTTING && !showHeader) {
                this.byteBuffer.position(4);
            }
            StringBuilder builder = new StringBuilder();
            while (this.byteBuffer.hasRemaining()) {
                int b = this.byteBuffer.get();
                HexUtil.appendHex((StringBuilder)builder, (int)(b < 0 ? ~b : b));
                builder.append(' ');
            }
            String string = builder.toString();
            return string;
        }
        finally {
            this.byteBuffer.position(oldPosition);
            this.byteBuffer.limit(oldLimit);
        }
    }

    public IErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void handleError(Throwable t) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(t);
        }
        this.release();
    }

    private static void readChannel(SocketChannel socketChannel, ByteBuffer buffer) throws ClosedChannelException {
        try {
            if (socketChannel.read(buffer) == -1) {
                throw new ClosedChannelException();
            }
        }
        catch (ClosedChannelException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw new ClosedChannelException();
        }
    }
}

