/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.IBuffer;
import org.eclipse.net4j.buffer.IBufferHandler;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.util.HexUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.io.IOTimeoutException;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class BufferInputStream
extends InputStream
implements IBufferHandler {
    public static final long NO_TIMEOUT = -1L;
    public static final long DEFAULT_MILLIS_BEFORE_TIMEOUT = -1L;
    public static final long DEFAULT_MILLIS_INTERRUPT_CHECK = 100L;
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_BUFFER_STREAM, BufferInputStream.class);
    private final boolean tracerEnabled;
    private BlockingQueue<IBuffer> buffers = new LinkedBlockingQueue<IBuffer>();
    private IBuffer currentBuffer;
    private boolean eos;
    private RemoteException exception;
    private long stopTimeMillis;

    public BufferInputStream() {
        this.tracerEnabled = TRACER.isEnabled();
    }

    public long getMillisBeforeTimeout() {
        return -1L;
    }

    public long getMillisInterruptCheck() {
        return 100L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartTimeout() {
        BufferInputStream bufferInputStream = this;
        synchronized (bufferInputStream) {
            this.stopTimeMillis = System.currentTimeMillis() + this.getMillisBeforeTimeout();
        }
    }

    public RuntimeException getException() {
        return this.exception;
    }

    public void setException(RemoteException exception) {
        this.exception = exception;
    }

    public void handleBuffer(IBuffer buffer) {
        this.buffers.add(buffer);
    }

    public int read() throws IOException {
        ByteBuffer byteBuffer;
        if (this.currentBuffer == null) {
            if (this.eos) {
                return -1;
            }
            if (!this.ensureBuffer()) {
                return -1;
            }
        }
        if (!(byteBuffer = this.currentBuffer.getByteBuffer()).hasRemaining()) {
            return -1;
        }
        int result = byteBuffer.get() & 0xFF;
        if (this.tracerEnabled) {
            TRACER.trace("<-- " + HexUtil.formatByte((int)result) + (result >= 32 ? " " + Character.toString((char)result) : ""));
        }
        if (!byteBuffer.hasRemaining()) {
            this.currentBuffer.release();
            this.currentBuffer = null;
        }
        return result;
    }

    public void close() throws IOException {
        this.buffers = null;
        this.currentBuffer = null;
        super.close();
    }

    public String toString() {
        return "BufferInputStream";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    protected boolean ensureBuffer() throws IOException {
        block11: {
            long check = this.getMillisInterruptCheck();
            try {
                if (this.getMillisBeforeTimeout() == -1L) {
                    while (this.currentBuffer == null) {
                        this.throwRemoteExceptionIfExists();
                        if (this.buffers == null) {
                            return false;
                        }
                        this.currentBuffer = this.buffers.poll(check, TimeUnit.MILLISECONDS);
                    }
                    break block11;
                }
                this.restartTimeout();
                while (this.currentBuffer == null) {
                    long remaining;
                    this.throwRemoteExceptionIfExists();
                    if (this.buffers == null) {
                        return false;
                    }
                    BufferInputStream bufferInputStream = this;
                    synchronized (bufferInputStream) {
                        remaining = this.stopTimeMillis;
                    }
                    if ((remaining -= System.currentTimeMillis()) <= 0L) {
                        throw new IOTimeoutException();
                    }
                    this.currentBuffer = this.buffers.poll(Math.min(remaining, check), TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }
        this.eos = this.currentBuffer.isEOS();
        return true;
    }

    private void throwRemoteExceptionIfExists() {
        if (this.exception != null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            this.exception.setLocalStacktrace(stackTrace);
            throw this.exception;
        }
    }
}

