/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.BufferOutputStream;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.signal.SignalActor;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestWithConfirmation<RESULT>
extends SignalActor {
    private RESULT result;

    public RequestWithConfirmation(SignalProtocol<?> protocol, short id, String name) {
        super(protocol, id, name);
    }

    public RequestWithConfirmation(SignalProtocol<?> protocol, short signalID) {
        super(protocol, signalID);
    }

    public RequestWithConfirmation(SignalProtocol<?> protocol, Enum<?> literal) {
        super(protocol, literal);
    }

    public Future<RESULT> sendAsync() {
        ExecutorService executorService = this.getAsyncExecutorService();
        return executorService.submit(new Callable<RESULT>(){

            @Override
            public RESULT call() throws Exception {
                return RequestWithConfirmation.this.doSend(RequestWithConfirmation.this.getProtocol().getTimeout());
            }
        });
    }

    public RESULT send() throws Exception, RemoteException {
        return this.doSend(this.getProtocol().getTimeout());
    }

    public RESULT send(long timeout) throws Exception, RemoteException {
        return this.doSend(timeout);
    }

    RESULT doSend(long timeout) throws Exception {
        this.result = null;
        this.getProtocol().startSignal(this, timeout);
        return this.result;
    }

    protected ExecutorService getAsyncExecutorService() {
        return this.getProtocol().getExecutorService();
    }

    @Override
    void doExecute(BufferInputStream in, BufferOutputStream out) throws Exception {
        this.doOutput(out);
        this.doInput(in);
    }

    protected abstract void requesting(ExtendedDataOutputStream var1) throws Exception;

    protected abstract RESULT confirming(ExtendedDataInputStream var1) throws Exception;

    @Override
    void doExtendedOutput(ExtendedDataOutputStream out) throws Exception {
        this.requesting(out);
    }

    @Override
    void doExtendedInput(ExtendedDataInputStream in) throws Exception {
        this.result = this.confirming(in);
    }

    void setRemoteException(Throwable t, boolean responding) {
        RemoteException remoteException = this.getRemoteException(t, responding);
        this.getBufferInputStream().setException(remoteException);
    }

    private RemoteException getRemoteException(Throwable t, boolean responding) {
        if (t instanceof RemoteException) {
            return (RemoteException)t;
        }
        return new RemoteException(t, this, responding);
    }
}

