/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.scanners;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.sonatype.guice.bean.reflect.ClassSpace;
import org.sonatype.guice.bean.reflect.Logs;
import org.sonatype.guice.bean.scanners.ClassSpaceVisitor;
import org.sonatype.guice.bean.scanners.asm.ClassReader;
import org.sonatype.guice.bean.scanners.asm.ClassVisitor;

public final class ClassSpaceScanner {
    private static final int ASM_FLAGS = 7;
    private final ClassSpace space;

    public ClassSpaceScanner(ClassSpace space) {
        this.space = space;
    }

    public void accept(ClassSpaceVisitor visitor) {
        visitor.visit(this.space);
        Enumeration e = this.space.findEntries(null, "*.class", true);
        while (e.hasMoreElements()) {
            URL url = (URL)e.nextElement();
            ClassVisitor cv = visitor.visitClass(url);
            if (null == cv) continue;
            ClassSpaceScanner.accept(cv, url);
        }
        visitor.visitEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void accept(ClassVisitor visitor, URL url) {
        if (null == url) {
            return;
        }
        try {
            InputStream in = url.openStream();
            try {
                new ClassReader(in).accept(visitor, 7);
            }
            finally {
                in.close();
            }
        }
        catch (Throwable e) {
            Logs.debug(visitor.getClass(), (String)"Problem scanning resource: {} cause: {}", (Object)url, (Object)e);
        }
    }
}

