/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model;

import com.fusesource.rider.commons.properties.BooleanPropertyDescriptor;
import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.Predicate;
import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.model.Activator;
import com.fusesource.rider.model.CamelModelHelper;
import com.fusesource.rider.model.Endpoint;
import com.fusesource.rider.model.ExpressionPropertyDescriptor;
import com.fusesource.rider.model.Flow;
import com.fusesource.rider.model.LanguageExpressionBean;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Bean;
import com.fusesource.rider.model.generated.Catch;
import com.fusesource.rider.model.generated.Choice;
import com.fusesource.rider.model.generated.ConvertBody;
import com.fusesource.rider.model.generated.Enrich;
import com.fusesource.rider.model.generated.Finally;
import com.fusesource.rider.model.generated.InOnly;
import com.fusesource.rider.model.generated.InOut;
import com.fusesource.rider.model.generated.InterceptSendToEndpoint;
import com.fusesource.rider.model.generated.LoadBalance;
import com.fusesource.rider.model.generated.Log;
import com.fusesource.rider.model.generated.Marshal;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.generated.Multicast;
import com.fusesource.rider.model.generated.NodeFactory;
import com.fusesource.rider.model.generated.OnException;
import com.fusesource.rider.model.generated.Otherwise;
import com.fusesource.rider.model.generated.PollEnrich;
import com.fusesource.rider.model.generated.RemoveHeader;
import com.fusesource.rider.model.generated.RemoveProperty;
import com.fusesource.rider.model.generated.Rollback;
import com.fusesource.rider.model.generated.SetExchangePattern;
import com.fusesource.rider.model.generated.Sort;
import com.fusesource.rider.model.generated.Tooltips;
import com.fusesource.rider.model.generated.Try;
import com.fusesource.rider.model.generated.Unmarshal;
import com.fusesource.rider.model.generated.When;
import com.fusesource.rider.model.util.Expressions;
import com.fusesource.rider.preferences.PreferenceManager;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.camel.ExchangePattern;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.loadbalancer.CustomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.FailoverLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RandomLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.RoundRobinLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.StickyLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.TopicLoadBalancerDefinition;
import org.apache.camel.model.loadbalancer.WeightedLoadBalancerDefinition;
import org.apache.camel.spi.NodeIdFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class AbstractNode
extends EClassImpl
implements IPropertySource,
IAdaptable {
    protected static final boolean lazyCreateIds = false;
    protected static final boolean useCamelIds = true;
    public static final String PROPERTY_LAYOUT_NODE = "AbstractNode.Layout";
    public static final String SOURCE_CONNECTIONS = "AbstractNode.SourceConn";
    public static final String TARGET_CONNECTIONS = "AbstractNode.TargetConn";
    public static final String PROPERTY_ID = "AbstractNode.Id";
    public static final String PROPERTY_DESCRIPTION = "AbstractNode.Description";
    public static final String PROPERTY_INHERITERRORHANDLER = "AbstractNode.InheritErrorHandler";
    private static final String ICON = "generic.png";
    public static final Rectangle DEFAULT_LAYOUT = new Rectangle(0, 0, 140, 80);
    protected static final ICellEditorValidator DEFAULT_STRING_VALIDATOR = new ICellEditorValidator(){

        public String isValid(Object value) {
            String val = (String)value;
            return val != null && val.trim().length() > 0 ? null : Messages.invalidValidatorValueLabel;
        }
    };
    private static transient NodeIdFactory nodeIdFactory;
    private String id;
    private String description;
    private Rectangle layout;
    private List<Flow> sourceConnections = new ArrayList<Flow>();
    private List<Flow> targetConnections = new ArrayList<Flow>();
    private RouteContainer parent;
    private transient Map<String, PropertyDescriptor> descriptors;
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport((Object)this);
    private boolean disableListeners;
    private Image image;
    private Image smallImage;
    private Boolean inheritErrorHandler;

    public AbstractNode() {
        this.layout = DEFAULT_LAYOUT;
        this.descriptors = new HashMap<String, PropertyDescriptor>();
        this.descriptors.put(PROPERTY_ID, (PropertyDescriptor)new TextPropertyDescriptor((Object)PROPERTY_ID, Messages.propertyLabelId));
        this.descriptors.get(PROPERTY_ID).setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                String val = (String)value;
                return val != null && val.trim().length() > 0 && AbstractNode.this.isUniqueId(val) ? null : Messages.invalidValidatorUniqueValueLabel;
            }
        });
        this.descriptors.put(PROPERTY_DESCRIPTION, (PropertyDescriptor)new TextPropertyDescriptor((Object)PROPERTY_DESCRIPTION, Messages.propertyLabelDescription));
        this.descriptors.get(PROPERTY_DESCRIPTION).setValidator(DEFAULT_STRING_VALIDATOR);
        this.descriptors.put(PROPERTY_INHERITERRORHANDLER, (PropertyDescriptor)new BooleanPropertyDescriptor((Object)PROPERTY_INHERITERRORHANDLER, Messages.propertyLabelInheritErrorHandler));
        this.addCustomProperties(this.descriptors);
    }

    public AbstractNode(RouteContainer parent) {
        this();
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        return false;
    }

    public void clearResources() {
        this.eSetDirectResource(null);
        Resource resource = this.eResource();
        if (resource != null) {
            throw new IllegalStateException("Should have cleared the resources!!!");
        }
        List<AbstractNode> children = this.getOutputs();
        for (AbstractNode node : children) {
            node.clearResources();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return new IWorkbenchAdapter(){

                public Object[] getChildren(Object o) {
                    if (o instanceof AbstractNode) {
                        AbstractNode node = (AbstractNode)((Object)o);
                        node.getChildren().toArray();
                    }
                    return null;
                }

                public ImageDescriptor getImageDescriptor(Object o) {
                    if (o instanceof AbstractNode) {
                        return null;
                    }
                    return null;
                }

                public String getLabel(Object o) {
                    if (o instanceof AbstractNode) {
                        AbstractNode node = (AbstractNode)((Object)o);
                        return node.getDisplayText();
                    }
                    return null;
                }

                public Object getParent(Object o) {
                    if (o instanceof AbstractNode) {
                        AbstractNode node = (AbstractNode)((Object)o);
                        return node.getParent();
                    }
                    return null;
                }
            };
        }
        if (adapter == IPropertySource.class) {
            return this;
        }
        if (adapter == AbstractNode.class) {
            return this;
        }
        return null;
    }

    protected boolean isUniqueId(String id) {
        return true;
    }

    public List<AbstractNode> getChildren() {
        return Collections.EMPTY_LIST;
    }

    public String getIconName() {
        return ICON;
    }

    public String getCategoryName() {
        return "Routing";
    }

    public String getSmallIconName() {
        String iconName = this.getIconName();
        return iconName.replace(".png", "16.png");
    }

    public Image getImage() {
        if (this.image == null) {
            String name = this.getIconName();
            this.image = Activator.getDefault().getImage(name);
        }
        return this.image;
    }

    public Image getSmallImage() {
        if (this.smallImage == null) {
            String name = this.getSmallIconName();
            this.smallImage = Activator.getDefault().getImage(name);
        }
        return this.smallImage;
    }

    public boolean canAcceptOutput() {
        ProcessorDefinition def;
        Class<?> aClass = this.getCamelDefinitionClass();
        if (aClass == null) {
            return false;
        }
        if (BeanDefinition.class.isAssignableFrom(aClass)) {
            return false;
        }
        if (MarshalDefinition.class.isAssignableFrom(aClass) || UnmarshalDefinition.class.isAssignableFrom(aClass)) {
            return false;
        }
        if (ProcessorDefinition.class.isAssignableFrom(aClass) && (def = this.createCamelDefinition()) != null) {
            boolean answer = def.isOutputSupported();
            return answer;
        }
        return false;
    }

    public boolean canAcceptInput() {
        int inputs = this.getInputs().size();
        return inputs <= 0;
    }

    public Class<?> getCamelDefinitionClass() {
        return null;
    }

    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.addPropertyChangeListener(l);
    }

    public void firePropertyChange(String prop, Object old, Object newValue) {
        if (newValue instanceof String && "".equals(newValue)) {
            this.disableListeners = true;
            this.setPropertyValue(prop, null);
            this.disableListeners = false;
        }
        if (!this.disableListeners && this.hasPropertyListener(prop)) {
            this.listeners.firePropertyChange(prop, old, newValue);
        }
    }

    protected void fireChildAdded(String prop, Object child, Object index) {
        if (this.hasPropertyListener(prop)) {
            this.listeners.firePropertyChange(prop, index, child);
        }
    }

    protected void fireChildRemoved(String prop, Object child) {
        if (this.hasPropertyListener(prop)) {
            this.listeners.firePropertyChange(prop, child, null);
        }
    }

    protected void fireStructureChange(String prop, Object child) {
        if (this.hasPropertyListener(prop)) {
            this.listeners.firePropertyChange(prop, null, child);
        }
    }

    protected boolean hasPropertyListener(String prop) {
        return this.listeners != null && this.listeners.hasListeners(prop);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (l != null && this.listeners != null) {
            this.listeners.removePropertyChangeListener(l);
        }
    }

    public synchronized String getId() {
        if (this.id == null) {
            // empty if block
        }
        return this.id;
    }

    public void setId(String id) {
        String oldId = this.id;
        this.id = id;
        if (!Objects.equal((Object)this.description, (Object)oldId)) {
            this.firePropertyChange(PROPERTY_ID, oldId, this.id);
        }
    }

    public Boolean getInheritErrorHandler() {
        return this.inheritErrorHandler;
    }

    public void setInheritErrorHandler(Boolean inheritErrorHandler) {
        Boolean old = this.inheritErrorHandler;
        this.inheritErrorHandler = inheritErrorHandler;
        if (!Objects.equal((Object)inheritErrorHandler, (Object)old)) {
            this.firePropertyChange(PROPERTY_INHERITERRORHANDLER, old, this.inheritErrorHandler);
        }
    }

    protected String getNewID() {
        String answer = null;
        ProcessorDefinition definition = this.createCamelDefinition();
        if (definition != null) {
            answer = definition.idOrCreate(AbstractNode.getNodeIdFactory());
        }
        if (answer == null) {
            answer = UUID.randomUUID().toString();
        }
        return answer;
    }

    protected static synchronized NodeIdFactory getNodeIdFactory() {
        if (nodeIdFactory == null) {
            nodeIdFactory = new DefaultCamelContext().getNodeIdFactory();
        }
        return nodeIdFactory;
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldDesc = this.description;
        this.description = description;
        if (!Objects.equal((Object)description, (Object)oldDesc)) {
            this.firePropertyChange(PROPERTY_DESCRIPTION, oldDesc, this.description);
        }
    }

    public RouteContainer getParent() {
        return this.parent;
    }

    public void setParent(RouteContainer parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    public Rectangle getLayout() {
        return this.layout;
    }

    public void setLayout(Rectangle layout) {
        Rectangle oldLayout = this.layout;
        this.layout = layout;
        this.firePropertyChange(PROPERTY_LAYOUT_NODE, oldLayout, this.layout);
    }

    public final String getDisplayText() {
        return this.getDisplayText(true);
    }

    public final String getDisplayText(boolean useID) {
        boolean preferID = false;
        if (useID) {
            preferID = PreferenceManager.getInstance().containsPreference("preferIdAsLabelPreference");
            if (PreferenceManager.getInstance().containsPreference("preferIdAsLabelPreference")) {
                preferID = PreferenceManager.getInstance().loadPreferenceAsBoolean("preferIdAsLabelPreference");
            }
        }
        if (preferID && this.getId() != null) {
            return this.getId();
        }
        if (this instanceof Endpoint) {
            Endpoint node = (Endpoint)this;
            if (node.getUri() != null && node.getUri().trim().length() > 0) {
                return node.getUri();
            }
        } else {
            if (this instanceof Bean) {
                Bean node = (Bean)this;
                return "bean " + Strings.getOrElse((Object)node.getRef());
            }
            if (this instanceof Catch) {
                Catch node = (Catch)this;
                List exceptions = node.getExceptions();
                if (exceptions != null && exceptions.size() > 0) {
                    return "catch " + exceptions;
                }
                return "catch " + Expressions.getExpressionOrElse(node.getHandled());
            }
            if (this instanceof Choice) {
                return "choice";
            }
            if (this instanceof ConvertBody) {
                ConvertBody node = (ConvertBody)this;
                return "convertBody " + Strings.getOrElse((Object)node.getType());
            }
            if (this instanceof Enrich) {
                Enrich node = (Enrich)this;
                return "enrich " + Strings.getOrElse((Object)node.getResourceUri());
            }
            if (this instanceof Finally) {
                return "finally";
            }
            if (this instanceof InOnly) {
                InOnly node = (InOnly)this;
                return "inOnly " + Strings.getOrElse((Object)node.getUri());
            }
            if (this instanceof InOut) {
                InOut node = (InOut)this;
                return "inOut " + Strings.getOrElse((Object)node.getUri());
            }
            if (this instanceof InterceptSendToEndpoint) {
                InterceptSendToEndpoint node = (InterceptSendToEndpoint)this;
                return "intercept " + Strings.getOrElse((Object)node.getUri());
            }
            if (this instanceof Log) {
                Log node = (Log)this;
                return "log " + Strings.getOrElse((Object)node.getLogName());
            }
            if (this instanceof Marshal) {
                return "marshal";
            }
            if (this instanceof OnException) {
                OnException node = (OnException)this;
                return "on exception " + Strings.getOrElse((Object)node.getExceptions());
            }
            if (this instanceof Otherwise) {
                return "otherwise";
            }
            if (this instanceof PollEnrich) {
                PollEnrich node = (PollEnrich)this;
                return "poll enrich " + Strings.getOrElse((Object)node.getResourceUri());
            }
            if (this instanceof RemoveHeader) {
                RemoveHeader node = (RemoveHeader)this;
                return "remove header " + Strings.getOrElse((Object)node.getHeaderName());
            }
            if (this instanceof RemoveProperty) {
                RemoveProperty node = (RemoveProperty)this;
                return "remove property " + Strings.getOrElse((Object)node.getPropertyName());
            }
            if (this instanceof Rollback) {
                Rollback node = (Rollback)this;
                return "rollback " + Strings.getOrElse((Object)node.getMessage());
            }
            if (this instanceof SetExchangePattern) {
                SetExchangePattern node = (SetExchangePattern)this;
                ExchangePattern pattern = node.getPattern();
                if (pattern == null) {
                    return "setExchangePattern";
                }
                return "set " + pattern;
            }
            if (this instanceof Sort) {
                Sort node = (Sort)this;
                return "sort " + Expressions.getExpressionOrElse(node.getExpression());
            }
            if (this instanceof When) {
                When node = (When)this;
                return "when " + Expressions.getExpressionOrElse(node.getExpression());
            }
            if (this instanceof Unmarshal) {
                return "unmarshal";
            }
            if (this instanceof Try) {
                return "try";
            }
            if (this instanceof LoadBalance) {
                LoadBalance load = (LoadBalance)this;
                if (load.getRef() != null) {
                    return "custom " + Strings.getOrElse((Object)load.getRef());
                }
                if (load.getLoadBalancerType() != null) {
                    if (load.getLoadBalancerType().getClass().isAssignableFrom(CustomLoadBalancerDefinition.class)) {
                        CustomLoadBalancerDefinition custom = (CustomLoadBalancerDefinition)load.getLoadBalancerType();
                        return "custom " + Strings.getOrElse((Object)custom.getRef());
                    }
                    if (load.getLoadBalancerType().getClass().isAssignableFrom(FailoverLoadBalancerDefinition.class)) {
                        return "failover";
                    }
                    if (load.getLoadBalancerType().getClass().isAssignableFrom(RandomLoadBalancerDefinition.class)) {
                        return "random";
                    }
                    if (load.getLoadBalancerType().getClass().isAssignableFrom(RoundRobinLoadBalancerDefinition.class)) {
                        return "round robin";
                    }
                    if (load.getLoadBalancerType().getClass().isAssignableFrom(StickyLoadBalancerDefinition.class)) {
                        return "sticky";
                    }
                    if (load.getLoadBalancerType().getClass().isAssignableFrom(TopicLoadBalancerDefinition.class)) {
                        return "topic";
                    }
                    if (load.getLoadBalancerType().getClass().isAssignableFrom(WeightedLoadBalancerDefinition.class)) {
                        return "weighted";
                    }
                } else {
                    return "load balance";
                }
            }
        }
        String answer = null;
        ProcessorDefinition camelDef = this.createCamelDefinition();
        if (camelDef != null) {
            try {
                answer = camelDef.getLabel();
            }
            catch (Exception exception) {}
        }
        if (Strings.isBlank(answer)) {
            answer = this.getId();
        }
        if (Strings.isBlank((String)answer)) {
            answer = this.getPatternName();
        }
        return answer;
    }

    public String getPatternName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public String getDisplayToolTip() {
        if (this instanceof When) {
            When node = (When)this;
            return "when " + Expressions.getExpressionOrElse(node.getExpression());
        }
        String answer = Tooltips.tooltip(this.getPatternName());
        if (answer == null) {
            ProcessorDefinition camelDef = this.createCamelDefinition();
            if (camelDef != null) {
                if (camelDef instanceof RouteDefinition) {
                    RouteDefinition route = (RouteDefinition)camelDef;
                    return "Route " + (route.getId() != null ? route.getId() : "");
                }
                if (camelDef instanceof ToDefinition && this.isNotTarget()) {
                    return "From " + camelDef.getLabel();
                }
                return String.valueOf(camelDef.getShortName()) + " " + camelDef.getLabel();
            }
            return this.getDescription();
        }
        return answer;
    }

    public String getDocumentationFileName() {
        return null;
    }

    public String toString() {
        return String.format("%s: %s", ((Object)((Object)this)).getClass().getSimpleName(), this.getDisplayText());
    }

    public List<AbstractNode> getOutputs() {
        ArrayList<AbstractNode> answer = new ArrayList<AbstractNode>();
        List<Flow> list = this.getSourceConnections();
        for (Flow flow : list) {
            answer.add(flow.getTarget());
        }
        return answer;
    }

    public List<AbstractNode> getInputs() {
        ArrayList<AbstractNode> answer = new ArrayList<AbstractNode>();
        List<Flow> list = this.getTargetConnections();
        for (Flow flow : list) {
            answer.add(flow.getSource());
        }
        return answer;
    }

    public void addTargetNode(AbstractNode to) {
        new Flow(this, to);
    }

    public void addConnection(Flow conn) {
        AbstractNode target = conn.getTarget();
        if (conn == null || conn.getSource() == target) {
            throw new IllegalArgumentException();
        }
        if (this.containsFlow(this.sourceConnections, conn) || this.containsFlow(this.targetConnections, conn)) {
            return;
        }
        if (conn.getSource() == this) {
            Predicate<Flow> before = this.createBeforePredicate(target);
            boolean added = false;
            if (before != null) {
                int idx = 0;
                for (Flow f : this.sourceConnections) {
                    if (before.matches((Object)f)) {
                        this.sourceConnections.add(idx, conn);
                        added = true;
                        break;
                    }
                    ++idx;
                }
            }
            if (!added) {
                this.sourceConnections.add(conn);
            }
            this.firePropertyChange(SOURCE_CONNECTIONS, null, (Object)conn);
        } else if (target == this) {
            this.targetConnections.add(conn);
            this.firePropertyChange(TARGET_CONNECTIONS, null, (Object)conn);
        }
    }

    protected boolean containsFlow(Collection<Flow> coll, Flow flow) {
        for (Flow aFlow : coll) {
            boolean sourceEqual = Objects.equal((Object)((Object)aFlow.getSource()), (Object)((Object)flow.getSource()));
            boolean targetEqual = Objects.equal((Object)((Object)aFlow.getTarget()), (Object)((Object)flow.getTarget()));
            if (!sourceEqual || !targetEqual) continue;
            return true;
        }
        return false;
    }

    protected Predicate<Flow> createBeforePredicate(AbstractNode target) {
        if (this instanceof Choice) {
            if (target instanceof When) {
                return new Predicate<Flow>(){

                    public boolean matches(Flow f) {
                        return f.getTarget() instanceof Otherwise || !(f.getTarget() instanceof When);
                    }
                };
            }
            if (target instanceof Otherwise) {
                return new Predicate<Flow>(){

                    public boolean matches(Flow f) {
                        return !(f.getTarget() instanceof When);
                    }
                };
            }
        } else if (this instanceof Try) {
            if (target instanceof Catch) {
                return new Predicate<Flow>(){

                    public boolean matches(Flow f) {
                        return f.getTarget() instanceof Finally;
                    }
                };
            }
            if (!(target instanceof Finally)) {
                return new Predicate<Flow>(){

                    public boolean matches(Flow f) {
                        return f.getTarget() instanceof Catch || f.getTarget() instanceof Finally;
                    }
                };
            }
        }
        return null;
    }

    public void addConnections(List<Flow> flows) {
        for (Flow flow : flows) {
            this.addConnection(flow);
        }
    }

    void removeConnection(Flow conn) {
        if (conn == null) {
            throw new IllegalArgumentException();
        }
        if (conn.getSource() == this) {
            this.sourceConnections.remove((Object)conn);
            this.firePropertyChange(SOURCE_CONNECTIONS, null, (Object)conn);
        } else if (conn.getTarget() == this) {
            this.targetConnections.remove((Object)conn);
            this.firePropertyChange(TARGET_CONNECTIONS, null, (Object)conn);
        }
    }

    public void delete(List<Flow> deletedFlows) {
        for (Flow flow : this.sourceConnections) {
            flow.getTarget().removeConnection(flow);
            deletedFlows.add(flow);
        }
        for (Flow flow : this.targetConnections) {
            flow.getSource().removeConnection(flow);
            deletedFlows.add(flow);
        }
    }

    public List<Flow> getSourceConnections() {
        return new ArrayList<Flow>(this.sourceConnections);
    }

    public List<Flow> getTargetConnections() {
        return new ArrayList<Flow>(this.targetConnections);
    }

    public List<AbstractNode> getTargetNodes() {
        ArrayList<AbstractNode> answer = new ArrayList<AbstractNode>();
        for (Flow connection : this.targetConnections) {
            answer.add(connection.getTarget());
        }
        return answer;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors.values().toArray(new IPropertyDescriptor[this.descriptors.size()]);
    }

    public IPropertyDescriptor getPropertyDescriptor(Object id) {
        IPropertyDescriptor[] array;
        IPropertyDescriptor[] iPropertyDescriptorArray = array = this.getPropertyDescriptors();
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
            if (Objects.equal((Object)id, (Object)descriptor.getId())) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    public Object getPropertyValue(Object id) {
        if (PROPERTY_ID.equals(id)) {
            return this.getId();
        }
        if (PROPERTY_DESCRIPTION.equals(id)) {
            return this.getDescription();
        }
        if (PROPERTY_INHERITERRORHANDLER.equals(id)) {
            return this.getInheritErrorHandler();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        return this.descriptors.containsKey(id);
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_ID.equals(id)) {
            this.setId((String)value);
        } else if (PROPERTY_DESCRIPTION.equals(id)) {
            this.setDescription((String)value);
        } else if (PROPERTY_INHERITERRORHANDLER.equals(id)) {
            this.setInheritErrorHandler((Boolean)value);
        }
    }

    public boolean isPropertyName(String name) {
        return name != null && this.descriptors.containsKey(name);
    }

    public abstract ProcessorDefinition createCamelDefinition();

    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        this.description = processor.getDescriptionText();
        this.id = processor.getId();
        this.inheritErrorHandler = null;
        Boolean bool = processor.isInheritErrorHandler();
        if (bool != null && bool.booleanValue()) {
            this.inheritErrorHandler = true;
        }
    }

    protected void loadChildrenFromCamelDefinition(ProcessorDefinition processor) {
        List<ProcessorDefinition> outputs = this.getOutputs(processor);
        AbstractNode parent = this;
        for (ProcessorDefinition childProcessor : outputs) {
            AbstractNode node = NodeFactory.createNode(childProcessor, this.getParent());
            parent.addTargetNode(node);
            if (parent.isMulticastNode(parent, node)) continue;
            parent = node;
        }
    }

    protected boolean isMulticastNode(AbstractNode parent, AbstractNode child) {
        return parent instanceof Multicast || parent instanceof Choice && (child instanceof When || child instanceof Otherwise) || parent instanceof Try && (child instanceof Catch || child instanceof Finally);
    }

    protected List<ProcessorDefinition> getOutputs(ProcessorDefinition processor) {
        if (processor instanceof ChoiceDefinition) {
            OtherwiseDefinition otherwise;
            ChoiceDefinition choice = (ChoiceDefinition)processor;
            ArrayList<ProcessorDefinition> list = new ArrayList<ProcessorDefinition>();
            List whenClauses = choice.getWhenClauses();
            if (whenClauses != null) {
                list.addAll(whenClauses);
            }
            if ((otherwise = choice.getOtherwise()) != null) {
                list.add((ProcessorDefinition)otherwise);
            }
            return list;
        }
        return processor.getOutputs();
    }

    protected void addCamelOutput(ProcessorDefinition processor, ProcessorDefinition toNode) {
        if (processor instanceof ChoiceDefinition) {
            ChoiceDefinition choice = (ChoiceDefinition)processor;
            if (toNode instanceof WhenDefinition) {
                choice.getWhenClauses().add((WhenDefinition)toNode);
            } else if (toNode instanceof OtherwiseDefinition) {
                choice.setOtherwise((OtherwiseDefinition)toNode);
            } else {
                ProcessorDefinition grandParent = choice.getParent();
                if (grandParent != null) {
                    grandParent.addOutput(toNode);
                } else {
                    Activator.getLogger().warning("No parent of " + choice + " so cannot add output " + toNode);
                }
            }
        } else {
            ExpressionNode en;
            if (processor instanceof ExpressionNode && (en = (ExpressionNode)processor).getExpression() == null) {
                en.setExpression(new ExpressionDefinition());
            }
            processor.addOutput(toNode);
        }
    }

    public void savePropertiesToCamelDefinition(ProcessorDefinition processor) {
        if (this.inheritErrorHandler != null && this.inheritErrorHandler.booleanValue()) {
            processor.setInheritErrorHandler(this.inheritErrorHandler);
        } else if (processor.getClass().isAssignableFrom(LoadBalanceDefinition.class)) {
            if (this.inheritErrorHandler != null) {
                processor.setInheritErrorHandler(this.inheritErrorHandler);
            } else {
                processor.setInheritErrorHandler(null);
            }
        } else {
            processor.setInheritErrorHandler(null);
        }
        if (this.description != null && this.description.trim().length() > 0) {
            DescriptionDefinition descriptionDefinition = new DescriptionDefinition();
            descriptionDefinition.setText(this.description);
            processor.setDescription(descriptionDefinition);
        }
        if (this.id != null && this.id.trim().length() > 0) {
            processor.setId(this.id);
        }
    }

    public void saveChildrenToCamelDefinitions(ProcessorDefinition processor) {
        List<Flow> children = this.getSourceConnections();
        for (Flow flow : children) {
            IPropertyDescriptor[] propertyDescriptors;
            AbstractNode target = flow.getTarget();
            ProcessorDefinition toNode = target.createCamelDefinition();
            this.addCamelOutput(processor, toNode);
            IPropertyDescriptor[] iPropertyDescriptorArray = propertyDescriptors = this.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                boolean cfr_ignored_0 = descriptor instanceof ExpressionPropertyDescriptor;
                ++n2;
            }
            ProcessorDefinition outputNode = target.canAcceptOutput() ? toNode : processor;
            target.saveChildrenToCamelDefinitions(outputNode);
        }
    }

    protected <T> T toXmlPropertyValue(Object id, T value) {
        if (value instanceof LanguageExpressionBean) {
            LanguageExpressionBean lb = (LanguageExpressionBean)value;
            return (T)lb.toXmlExpression();
        }
        if (CamelModelHelper.isPropertyListOFSetHeaders(id) && value instanceof List) {
            List list = (List)value;
            for (Object object : list) {
                SetHeaderDefinition sh;
                ExpressionDefinition expression;
                if (!(object instanceof SetHeaderDefinition) || !((expression = (sh = (SetHeaderDefinition)object).getExpression()) instanceof LanguageExpressionBean)) continue;
                LanguageExpressionBean lb = (LanguageExpressionBean)expression;
                sh.setExpression(lb.toXmlExpression());
            }
        }
        return value;
    }

    public boolean isNotTarget() {
        return this.getTargetConnections().isEmpty();
    }

    public void layout() {
    }

    public Set<Flow> getAllConnections() {
        HashSet<Flow> set = new HashSet<Flow>();
        set.addAll(this.getSourceConnections());
        set.addAll(this.getTargetConnections());
        return set;
    }

    public boolean canSupportOutput() {
        boolean output = this.canAcceptOutput();
        if (output) {
            return true;
        }
        for (Flow flow : this.getAllConnections()) {
            if (flow.getSource() != this) continue;
            return false;
        }
        return true;
    }

    public boolean canConnectTo(AbstractNode target) {
        if (target == this || target instanceof RouteContainer) {
            return false;
        }
        if (target == null) {
            return true;
        }
        for (Flow flow : this.getAllConnections()) {
            if (!target.equals((Object)flow.getSource()) && !target.equals((Object)flow.getTarget())) continue;
            return false;
        }
        if (this.detectLoops(this, target)) {
            return false;
        }
        if (this.detectInputLoops(this, target)) {
            return false;
        }
        if (!target.canAcceptInput()) {
            return false;
        }
        boolean isOtherwise = target instanceof Otherwise;
        boolean isWhen = target instanceof When;
        boolean whenOrOtherwise = isWhen || isOtherwise;
        boolean thisIsChoice = this instanceof Choice;
        if (thisIsChoice) {
            if (isOtherwise) {
                List<AbstractNode> outputs = this.getOutputs(Otherwise.class);
                return outputs.size() == 0;
            }
            return true;
        }
        if (whenOrOtherwise) {
            Class<?> camelClass;
            if (thisIsChoice) {
                return true;
            }
            if (isWhen && (camelClass = this.getCamelDefinitionClass()) != null) {
                Field[] fields;
                Field[] fieldArray = fields = camelClass.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (WhenDefinition.class.isAssignableFrom(field.getType())) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
        return true;
    }

    private AbstractNode getMatchedInput(AbstractNode node, boolean inputCanAcceptOutput) {
        if (node == null) {
            return null;
        }
        for (AbstractNode input : node.getInputs()) {
            if (!inputCanAcceptOutput) {
                return input;
            }
            if (input.canAcceptOutput()) {
                return input;
            }
            AbstractNode child = this.getMatchedInput(input, inputCanAcceptOutput);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    protected boolean detectLoops(AbstractNode sourceNode, AbstractNode targetNode) {
        List<AbstractNode> nodes = sourceNode.getInputs();
        for (AbstractNode n : nodes) {
            if (n.equals((Object)targetNode)) {
                return true;
            }
            if (!this.detectLoops(n, targetNode)) continue;
            return true;
        }
        return false;
    }

    protected boolean detectInputLoops(AbstractNode sourceNode, AbstractNode targetNode) {
        AbstractNode thisParent = this.getMatchedInput(sourceNode, true);
        AbstractNode targetParent = this.getMatchedInput(targetNode, true);
        return thisParent != null && targetParent != null && thisParent.equals((Object)targetParent);
    }

    public List<AbstractNode> getOutputs(Class<? extends AbstractNode> aClass) {
        List<AbstractNode> list = this.getOutputs();
        ArrayList<AbstractNode> answer = new ArrayList<AbstractNode>();
        for (AbstractNode node : list) {
            if (!aClass.isInstance((Object)node)) continue;
            answer.add(node);
        }
        return answer;
    }

    public void appendEndpointUris(Set<String> uris) {
        List<AbstractNode> outputs = this.getOutputs();
        for (AbstractNode node : outputs) {
            node.appendEndpointUris(uris);
        }
    }

    protected void appendDescendents(Set<AbstractNode> answer) {
        answer.add(this);
        List<AbstractNode> list = this.getOutputs();
        for (AbstractNode node : list) {
            node.appendDescendents(answer);
        }
    }

    public void removeConnection(AbstractNode target) {
        List<Flow> list = this.getSourceConnections();
        for (Flow flow : list) {
            if (flow.getTarget() != target) continue;
            flow.disconnect();
            return;
        }
    }

    public void detach() {
        RouteContainer p = this.getParent();
        if (p != null) {
            p.removeChild(this);
        }
        this.disconnect(this.getSourceConnections());
        this.disconnect(this.getTargetConnections());
    }

    private void disconnect(List<Flow> list) {
        for (Flow flow : list) {
            flow.disconnect();
        }
    }
}

