/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model;

import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.model.Activator;
import com.fusesource.rider.model.Endpoint;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ToDefinition;

public class CamelModelHelper {
    public static String getDefaultLanguageName() {
        String answer = Activator.getDefault().getPreferenceStore().getString("defaultLanguagePreference");
        if (Strings.isBlank((String)answer)) {
            return "simple";
        }
        return answer;
    }

    public static boolean isPropertyListOFSetHeaders(Object id) {
        return Objects.equal((Object)"WireTap.Headers", (Object)id);
    }

    public static String getUri(FromDefinition input) {
        String ref;
        String key = input.getUri();
        if (Strings.isBlank((String)key) && !Strings.isBlank((String)(ref = input.getRef()))) {
            return "ref:" + ref;
        }
        return key;
    }

    public static String getUri(ToDefinition input) {
        String ref;
        String key = input.getUri();
        if (Strings.isBlank((String)key) && !Strings.isBlank((String)(ref = input.getRef()))) {
            return "ref:" + ref;
        }
        return key;
    }

    public static void setUri(FromDefinition node, Endpoint endpoint) {
        String value = endpoint.getUri();
        if (value != null && value.startsWith("ref:")) {
            node.setRef(value.substring(4));
        } else {
            node.setUri(value);
        }
    }

    public static void setUri(ToDefinition node, Endpoint endpoint) {
        String value = endpoint.getUri();
        if (value != null && value.startsWith("ref:")) {
            node.setRef(value.substring(4));
        } else {
            node.setUri(value);
        }
    }

    public static void setId(FromDefinition node, Endpoint endpoint) {
        String value = endpoint.getId();
        if (value != null && value.trim().length() > 0) {
            node.setId(value);
        }
    }

    public static void setDescription(FromDefinition node, Endpoint endpoint) {
        String value = endpoint.getId();
        if (value != null && value.trim().length() > 0) {
            DescriptionDefinition dd = new DescriptionDefinition();
            dd.setText(endpoint.getDescription());
            node.setDescription(dd);
        }
    }
}

