/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.CamelModelHelper;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.RouteSupport;
import com.fusesource.rider.model.generated.Messages;
import java.util.Map;
import java.util.Set;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ToDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Endpoint
extends AbstractNode {
    public static final String PROPERTY_URI = "Endpoint.Uri";
    private static final String ICON = "endpoint.png";
    private String uri = "";

    public Endpoint() {
    }

    public static Endpoint newInstance(ToDefinition definition, RouteContainer parent) {
        if (parent instanceof RouteSupport) {
            RouteSupport route = (RouteSupport)parent;
            return route.getOrCreateEndpoint(definition, parent);
        }
        return new Endpoint(definition, parent);
    }

    public Endpoint(ToDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    public Endpoint(FromDefinition definition, RouteContainer parent) {
        super(parent);
        this.setId(definition.getId());
        this.setDescription(definition.getDescriptionText());
        this.setUri(CamelModelHelper.getUri(definition));
    }

    public Endpoint(String uri) {
        this.uri = uri;
    }

    public Endpoint(Endpoint endpoint) {
        this(endpoint.uri);
        this.setId(endpoint.getId());
        this.setDescription(endpoint.getDescription());
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        String oldUri = this.uri;
        this.uri = uri;
        this.firePropertyChange(PROPERTY_URI, oldUri, uri);
    }

    @Override
    protected String getNewID() {
        return "";
    }

    @Override
    public String getIconName() {
        return ICON;
    }

    @Override
    public String getDocumentationFileName() {
        return "endpoint";
    }

    @Override
    public String getCategoryName() {
        return "Endpoints";
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor desc = new TextPropertyDescriptor((Object)PROPERTY_URI, Messages.propertyLabelEndpointUri);
        desc.setValidator(DEFAULT_STRING_VALIDATOR);
        descriptors.put(PROPERTY_URI, (PropertyDescriptor)desc);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_URI.equals(id)) {
            this.setUri((String)value);
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_URI.equals(id)) {
            return this.getUri();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        ToDefinition answer = new ToDefinition();
        CamelModelHelper.setUri(answer, this);
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public void savePropertiesToCamelDefinition(ProcessorDefinition processor) {
        super.savePropertiesToCamelDefinition(processor);
        if (!(processor instanceof ToDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof ToDefinition. Was " + processor.getClass().getName());
        }
        ToDefinition node = (ToDefinition)processor;
        CamelModelHelper.setUri(node, this);
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof ToDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof ToDefinition. Was " + processor.getClass().getName());
        }
        ToDefinition node = (ToDefinition)processor;
        String value = CamelModelHelper.getUri(node);
        this.setUri(value);
    }

    public void populateCamelDefinition(FromDefinition from) {
        this.setId(from.getId());
        this.setDescription(from.getDescriptionText());
    }

    @Override
    public void appendEndpointUris(Set<String> uris) {
        String trimmed;
        if (this.uri != null && (trimmed = this.uri.trim()).length() > 0) {
            uris.add(trimmed);
        }
        super.appendEndpointUris(uris);
    }

    public boolean isInputEndpoint() {
        return !this.getSourceConnections().isEmpty() && this.getTargetConnections().isEmpty();
    }

    public boolean isOutputEndpoint() {
        return this.getSourceConnections().isEmpty() && !this.getTargetConnections().isEmpty();
    }
}

