/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model;

import com.fusesource.rider.model.Endpoint;
import com.fusesource.rider.model.RouteContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class EndpointSummary {
    private Map<String, Endpoint> inputEndpoints = new LinkedHashMap<String, Endpoint>();
    private Map<String, Endpoint> outputEndpoints = new LinkedHashMap<String, Endpoint>();

    public EndpointSummary(RouteContainer routeContainer) {
        Set<Endpoint> endpoints = routeContainer.getEndpoints();
        for (Endpoint endpoint : endpoints) {
            String key = endpoint.getUri();
            if (key == null) continue;
            if (endpoint.isInputEndpoint()) {
                this.inputEndpoints.put(key, endpoint);
            }
            if (!endpoint.isOutputEndpoint()) continue;
            this.outputEndpoints.put(key, endpoint);
        }
        ArrayList<String> outputKeys = new ArrayList<String>(this.outputEndpoints.keySet());
        ArrayList<String> inputKeys = new ArrayList<String>(this.inputEndpoints.keySet());
        EndpointSummary.removeAll(this.inputEndpoints, outputKeys);
        EndpointSummary.removeAll(this.outputEndpoints, inputKeys);
    }

    public static <K, V> void removeAll(Map<K, V> map, Collection<K> keys) {
        for (K key : keys) {
            map.remove(key);
        }
    }

    public Map<String, Endpoint> getInputEndpoints() {
        return this.inputEndpoints;
    }

    public Map<String, Endpoint> getOutputEndpoints() {
        return this.outputEndpoints;
    }
}

