/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model;

import com.fusesource.rider.commons.util.Strings;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.CamelModelHelper;
import com.fusesource.rider.model.HasValue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ELExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.GroovyExpression;
import org.apache.camel.model.language.HeaderExpression;
import org.apache.camel.model.language.JXPathExpression;
import org.apache.camel.model.language.JavaScriptExpression;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.language.MethodCallExpression;
import org.apache.camel.model.language.MvelExpression;
import org.apache.camel.model.language.OgnlExpression;
import org.apache.camel.model.language.PhpExpression;
import org.apache.camel.model.language.PropertyExpression;
import org.apache.camel.model.language.PythonExpression;
import org.apache.camel.model.language.RefExpression;
import org.apache.camel.model.language.RubyExpression;
import org.apache.camel.model.language.SimpleExpression;
import org.apache.camel.model.language.SpELExpression;
import org.apache.camel.model.language.SqlExpression;
import org.apache.camel.model.language.TokenizerExpression;
import org.apache.camel.model.language.XPathExpression;
import org.apache.camel.model.language.XQueryExpression;
import org.apache.camel.util.ObjectHelper;

public class LanguageExpressionBean
extends LanguageExpression
implements HasValue {
    private transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private ExpressionDefinition original;

    public static LanguageExpressionBean bindToNodeProperty(AbstractNode node, Object propertyName) {
        Object value = node.getPropertyValue(propertyName);
        if (value instanceof LanguageExpressionBean) {
            return (LanguageExpressionBean)value;
        }
        LanguageExpressionBean answer = LanguageExpressionBean.toLanguageExpressionBean(value);
        node.setPropertyValue(propertyName, answer);
        return answer;
    }

    public static LanguageExpressionBean toLanguageExpressionBean(Object value) {
        LanguageExpressionBean languageBean;
        if (value instanceof LanguageExpressionBean) {
            languageBean = (LanguageExpressionBean)value;
        } else if (value instanceof ExpressionDefinition) {
            ExpressionDefinition exp = (ExpressionDefinition)value;
            String language = exp.getLanguage();
            String expression = exp.getExpression();
            if (exp instanceof MethodCallExpression) {
                MethodCallExpression mc = (MethodCallExpression)exp;
                language = "method";
                expression = String.valueOf(Strings.getOrElse((Object)mc.getBean(), (String)mc.getRef())) + "." + Strings.getOrElse((Object)mc.getMethod());
            }
            languageBean = new LanguageExpressionBean(language, expression);
            languageBean.original = exp;
        } else {
            languageBean = new LanguageExpressionBean();
        }
        if (Strings.isBlank((String)languageBean.getLanguage())) {
            languageBean.setLanguage(CamelModelHelper.getDefaultLanguageName());
        }
        return languageBean;
    }

    public LanguageExpressionBean() {
    }

    public LanguageExpressionBean(String language, String expression) {
        super(language, expression);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new IllegalArgumentException();
        }
        this.listeners.addPropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.listeners != null) {
            this.listeners.removePropertyChangeListener(l);
        }
    }

    protected void firePropertyChange(String prop, Object old, Object newValue) {
        if (this.listeners != null) {
            this.listeners.firePropertyChange(prop, old, newValue);
        }
    }

    public void setExpression(String expression) {
        String old = this.getExpression();
        if (expression != null && "".equals(expression)) {
            expression = null;
        }
        super.setExpression(expression);
        this.firePropertyChange("expression", old, expression);
    }

    public void setLanguage(String language) {
        String old = this.getLanguage();
        super.setLanguage(language);
        this.firePropertyChange("language", old, this.getLanguage());
    }

    @Override
    public boolean hasValue() {
        return this.getExpression() != null;
    }

    public ExpressionDefinition getOriginal() {
        return this.original;
    }

    public void setOriginal(ExpressionDefinition original) {
        this.original = original;
    }

    public ExpressionDefinition toXmlExpression() {
        String language = Strings.getOrElse((Object)this.getLanguage());
        String expression = Strings.getOrElse((Object)this.getExpression());
        if ("constant".equals(language)) {
            return this.getOrCreateOriginalExpression(ConstantExpression.class, expression);
        }
        if ("el".equals(language)) {
            return this.getOrCreateOriginalExpression(ELExpression.class, expression);
        }
        if ("groovy".equals(language)) {
            return this.getOrCreateOriginalExpression(GroovyExpression.class, expression);
        }
        if ("header".equals(language)) {
            return this.getOrCreateOriginalExpression(HeaderExpression.class, expression);
        }
        if ("javaScript".equals(language)) {
            return this.getOrCreateOriginalExpression(JavaScriptExpression.class, expression);
        }
        if ("jxpath".equals(language)) {
            return this.getOrCreateOriginalExpression(JXPathExpression.class, expression);
        }
        if ("method".equals(language)) {
            return this.getOrCreateMethodCall(expression);
        }
        if ("mvel".equals(language)) {
            return this.getOrCreateOriginalExpression(MvelExpression.class, expression);
        }
        if ("ognl".equals(language)) {
            return this.getOrCreateOriginalExpression(OgnlExpression.class, expression);
        }
        if ("php".equals(language)) {
            return this.getOrCreateOriginalExpression(PhpExpression.class, expression);
        }
        if ("property".equals(language)) {
            return this.getOrCreateOriginalExpression(PropertyExpression.class, expression);
        }
        if ("python".equals(language)) {
            return this.getOrCreateOriginalExpression(PythonExpression.class, expression);
        }
        if ("ref".equals(language)) {
            return this.getOrCreateOriginalExpression(RefExpression.class, expression);
        }
        if ("ruby".equals(language)) {
            return this.getOrCreateOriginalExpression(RubyExpression.class, expression);
        }
        if ("simple".equals(language)) {
            return this.getOrCreateOriginalExpression(SimpleExpression.class, expression);
        }
        if ("spel".equals(language)) {
            return this.getOrCreateOriginalExpression(SpELExpression.class, expression);
        }
        if ("sql".equals(language)) {
            return this.getOrCreateOriginalExpression(SqlExpression.class, expression);
        }
        if ("tokenize".equals(language)) {
            return this.getOrCreateOriginalExpression(TokenizerExpression.class, expression);
        }
        if ("xpath".equals(language)) {
            return this.getOrCreateOriginalExpression(XPathExpression.class, expression);
        }
        if ("xquery".equals(language)) {
            return this.getOrCreateOriginalExpression(XQueryExpression.class, expression);
        }
        return this;
    }

    private <T extends ExpressionDefinition> T getOrCreateOriginalExpression(Class<T> aType, String expression) {
        T answer = this.getOrCreateOriginalExpression(aType);
        answer.setExpression(expression);
        return (T)((ExpressionDefinition)aType.cast(answer));
    }

    private <T extends ExpressionDefinition> T getOrCreateOriginalExpression(Class<T> aType) {
        if (!aType.isInstance(this.original)) {
            this.original = (ExpressionDefinition)ObjectHelper.newInstance(aType);
        }
        return (T)((ExpressionDefinition)aType.cast(this.original));
    }

    private MethodCallExpression getOrCreateMethodCall(String expression) {
        MethodCallExpression answer = this.getOrCreateOriginalExpression(MethodCallExpression.class);
        int idx = expression.lastIndexOf(46);
        if (idx > 0) {
            answer.setRef(expression.substring(0, idx));
            answer.setMethod(expression.substring(idx + 1));
        } else {
            answer.setBean(expression);
        }
        return answer;
    }
}

