/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model;

import com.fusesource.rider.commons.util.Objects;
import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.Activator;
import com.fusesource.rider.model.Endpoint;
import com.fusesource.rider.model.RouteSupport;
import com.fusesource.rider.model.generated.Route;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.fusesource.camel.rider.util.ValidationHandler;
import org.fusesource.camel.rider.util.XmlModel;

public class RouteContainer
extends AbstractNode {
    protected static final transient Log LOG = LogFactory.getLog(MinimalEObjectImpl.Container.class);
    public static final String CHILD_ADDED_PROP = "Route.ChildAdded";
    public static final String CHILD_REMOVED_PROP = "Route.ChildRemoved";
    private List<AbstractNode> children = new ArrayList<AbstractNode>();
    private Map<String, String> beans = new HashMap<String, String>();
    private Set<String> camelContextEndpointUris = new TreeSet<String>();
    private boolean autoLayout;
    private XmlModel model;
    private boolean failedToParseXml;

    public RouteContainer() {
    }

    public RouteContainer(RouteContainer parent) {
        super(parent);
    }

    @Override
    public void clearResources() {
        super.clearResources();
        List<AbstractNode> children = this.getChildren();
        for (AbstractNode node : children) {
            node.clearResources();
        }
    }

    public String[] getEndpointUris() {
        TreeSet<String> uris = new TreeSet<String>();
        this.appendEndpointUris(uris);
        uris.addAll(this.getCamelContextEndpointUris());
        return uris.toArray(new String[uris.size()]);
    }

    @Override
    public void appendEndpointUris(Set<String> uris) {
        List<AbstractNode> outputs = this.getChildren();
        for (AbstractNode node : outputs) {
            node.appendEndpointUris(uris);
        }
    }

    public Set<String> getCamelContextEndpointUris() {
        return this.camelContextEndpointUris;
    }

    public void setCamelContextEndpointUris(Set<String> camelContextEndpointUris) {
        this.camelContextEndpointUris = camelContextEndpointUris;
    }

    public Map<String, String> getBeans() {
        return this.beans;
    }

    public void setBeans(Map<String, String> beans) {
        this.beans = beans;
    }

    public void addRoutes(List<RouteDefinition> routes) {
        for (RouteDefinition routeDefinition : routes) {
            Route route = new Route(routeDefinition, this);
            this.addChild(route);
        }
    }

    public void addChild(AbstractNode node) {
        this.addChild(node, null);
    }

    public void addChild(AbstractNode child, AbstractNode after) {
        int idx = this.children.indexOf((Object)after);
        this.addChild(child, idx != -1 ? idx + 1 : idx);
    }

    public void addChild(AbstractNode child, int index) {
        if (this.children.contains((Object)child)) {
            if (index >= 0 && index < this.children.size()) {
                Activator.getLogger().warning("WARN: adding child at index: " + index + " when it was already there in " + (Object)((Object)this) + " children: " + this.children);
            }
            return;
        }
        if (index < 0 || index > this.children.size() - 1) {
            this.children.add(child);
        } else {
            this.children.add(index, child);
        }
        if (child.getParent() == null) {
            child.setParent(this);
        }
        this.fireChildAdded(CHILD_ADDED_PROP, (Object)child, new Integer(index));
    }

    public void addChildren(AbstractNode ... nodes) {
        int i = 0;
        while (i < nodes.length) {
            this.addChild(nodes[i]);
            ++i;
        }
    }

    @Override
    public List<AbstractNode> getChildren() {
        return new ArrayList<AbstractNode>(this.children);
    }

    public List<AbstractNode> getSourceNodes() {
        ArrayList<AbstractNode> answer = new ArrayList<AbstractNode>();
        for (AbstractNode child : this.children) {
            if (child.getTargetConnections().size() != 0) continue;
            answer.add(child);
        }
        return answer;
    }

    public boolean removeChild(AbstractNode node) {
        if (node != null && this.children.remove((Object)node)) {
            node.setParent(null);
            this.firePropertyChange(CHILD_REMOVED_PROP, null, (Object)node);
            return true;
        }
        return false;
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        return null;
    }

    public RouteContainer recreateModel() {
        List<RouteDefinition> definitions = this.createRouteDefinitions();
        RouteContainer answer = new RouteContainer();
        answer.beans = this.beans;
        answer.camelContextEndpointUris = this.camelContextEndpointUris;
        answer.autoLayout = this.autoLayout;
        answer.model = this.model;
        answer.addRoutes(definitions);
        return answer;
    }

    public List<RouteDefinition> createRouteDefinitions() {
        ArrayList<RouteDefinition> answer = new ArrayList<RouteDefinition>();
        List<AbstractNode> list = this.getChildren();
        for (AbstractNode node : list) {
            if (node instanceof RouteSupport) {
                RouteSupport route = (RouteSupport)node;
                RouteDefinition routeDef = route.createRouteDefinition();
                answer.add(routeDef);
                continue;
            }
            LOG.warn((Object)("Bad node in RouteContainer is ignored: " + (Object)((Object)node)));
        }
        return answer;
    }

    public String getDebugInfo() {
        StringBuffer sb = new StringBuffer();
        for (AbstractNode r : this.children) {
            if (!(r instanceof RouteSupport)) continue;
            sb.append(((RouteSupport)r).createCamelDefinition().toString());
            sb.append('\n');
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public void layout() {
        if (this.autoLayout || this.getParent() != null && this.getParent().isAutoLayout() || this.getChildren().size() == 0 && this.getLayout().x != 0 && this.getLayout().y != 0) {
            return;
        }
        int x_min = 0;
        int y_min = 0;
        int maxWidth = 100;
        int maxHeight = 50;
        boolean first = true;
        for (AbstractNode node : this.getChildren()) {
            node.layout();
            Rectangle r = node.getLayout();
            if (first) {
                first = false;
                x_min = r.x;
                y_min = r.y;
                maxWidth = r.x + r.width;
                maxHeight = r.y + r.height;
                continue;
            }
            x_min = Math.min(x_min, r.x);
            y_min = Math.min(y_min, r.y);
            maxWidth = Math.max(maxWidth, r.x + r.width);
            maxHeight = Math.max(maxHeight, r.y + r.height);
        }
        x_min = Math.max(0, x_min - 5);
        y_min = Math.max(0, y_min - 5);
        this.setLayout(new Rectangle(x_min, y_min, maxWidth += 100, maxHeight += 100));
    }

    public Set<AbstractNode> getDescendents() {
        LinkedHashSet<AbstractNode> answer = new LinkedHashSet<AbstractNode>();
        this.appendDescendents(answer);
        return answer;
    }

    @Override
    protected void appendDescendents(Set<AbstractNode> answer) {
        List<AbstractNode> list = this.getChildren();
        for (AbstractNode node : list) {
            node.appendDescendents(answer);
        }
        answer.add(this);
    }

    public Set<Endpoint> getEndpoints() {
        Set<AbstractNode> descendents = this.getDescendents();
        LinkedHashSet<Endpoint> answer = new LinkedHashSet<Endpoint>();
        for (AbstractNode node : descendents) {
            if (!(node instanceof Endpoint)) continue;
            answer.add((Endpoint)node);
        }
        return answer;
    }

    public boolean isAutoLayout() {
        return this.autoLayout;
    }

    public void setAutoLayout(boolean autoLayout) {
        this.autoLayout = autoLayout;
    }

    public AbstractNode getNode(String id) {
        Set<AbstractNode> set = this.getDescendents();
        for (AbstractNode abstractNode : set) {
            if (!Objects.equal((Object)id, (Object)abstractNode.getId())) continue;
            return abstractNode;
        }
        return null;
    }

    public XmlModel getModel() {
        return this.model;
    }

    public void setModel(XmlModel model) {
        this.model = model;
    }

    public ValidationHandler validate() {
        if (this.model != null) {
            return this.model.validate();
        }
        return new ValidationHandler();
    }

    public boolean isFailedToParseXml() {
        return this.failedToParseXml;
    }

    public void setFailedToParseXml(boolean failedToParseXml) {
        this.failedToParseXml = failedToParseXml;
    }
}

