/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.AOPDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class AOP
extends AbstractNode {
    public static final String PROPERTY_BEFOREURI = "AOP.BeforeUri";
    public static final String PROPERTY_AFTERURI = "AOP.AfterUri";
    public static final String PROPERTY_AFTERFINALLYURI = "AOP.AfterFinallyUri";
    private String beforeUri;
    private String afterUri;
    private String afterFinallyUri;

    public AOP() {
    }

    public AOP(AOPDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "generic.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "AOPEIP";
    }

    @Override
    public String getCategoryName() {
        return "Miscellaneous";
    }

    public String getBeforeUri() {
        return this.beforeUri;
    }

    public void setBeforeUri(String beforeUri) {
        String oldValue = this.beforeUri;
        this.beforeUri = beforeUri;
        this.firePropertyChange(PROPERTY_BEFOREURI, oldValue, beforeUri);
    }

    public String getAfterUri() {
        return this.afterUri;
    }

    public void setAfterUri(String afterUri) {
        String oldValue = this.afterUri;
        this.afterUri = afterUri;
        this.firePropertyChange(PROPERTY_AFTERURI, oldValue, afterUri);
    }

    public String getAfterFinallyUri() {
        return this.afterFinallyUri;
    }

    public void setAfterFinallyUri(String afterFinallyUri) {
        String oldValue = this.afterFinallyUri;
        this.afterFinallyUri = afterFinallyUri;
        this.firePropertyChange(PROPERTY_AFTERFINALLYURI, oldValue, afterFinallyUri);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descBeforeUri = new TextPropertyDescriptor((Object)PROPERTY_BEFOREURI, Messages.propertyLabelAOPBeforeUri);
        TextPropertyDescriptor descAfterUri = new TextPropertyDescriptor((Object)PROPERTY_AFTERURI, Messages.propertyLabelAOPAfterUri);
        TextPropertyDescriptor descAfterFinallyUri = new TextPropertyDescriptor((Object)PROPERTY_AFTERFINALLYURI, Messages.propertyLabelAOPAfterFinallyUri);
        descriptors.put(PROPERTY_BEFOREURI, (PropertyDescriptor)descBeforeUri);
        descriptors.put(PROPERTY_AFTERURI, (PropertyDescriptor)descAfterUri);
        descriptors.put(PROPERTY_AFTERFINALLYURI, (PropertyDescriptor)descAfterFinallyUri);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_BEFOREURI.equals(id)) {
            this.setBeforeUri(Objects.convertTo(value, String.class));
        } else if (PROPERTY_AFTERURI.equals(id)) {
            this.setAfterUri(Objects.convertTo(value, String.class));
        } else if (PROPERTY_AFTERFINALLYURI.equals(id)) {
            this.setAfterFinallyUri(Objects.convertTo(value, String.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_BEFOREURI.equals(id)) {
            return this.getBeforeUri();
        }
        if (PROPERTY_AFTERURI.equals(id)) {
            return this.getAfterUri();
        }
        if (PROPERTY_AFTERFINALLYURI.equals(id)) {
            return this.getAfterFinallyUri();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        AOPDefinition answer = new AOPDefinition();
        answer.setBeforeUri(this.toXmlPropertyValue(PROPERTY_BEFOREURI, this.getBeforeUri()));
        answer.setAfterUri(this.toXmlPropertyValue(PROPERTY_AFTERURI, this.getAfterUri()));
        answer.setAfterFinallyUri(this.toXmlPropertyValue(PROPERTY_AFTERFINALLYURI, this.getAfterFinallyUri()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return AOPDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof AOPDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof AOPDefinition. Was " + processor.getClass().getName());
        }
        AOPDefinition node = (AOPDefinition)processor;
        this.setBeforeUri(node.getBeforeUri());
        this.setAfterUri(node.getAfterUri());
        this.setAfterFinallyUri(node.getAfterFinallyUri());
    }
}

