/*
 * Decompiled with CFR 0.152.
 */
package com.fusesource.rider.model.generated;

import com.fusesource.rider.model.AbstractNode;
import com.fusesource.rider.model.RouteContainer;
import com.fusesource.rider.model.generated.Messages;
import com.fusesource.rider.model.util.Objects;
import java.util.Map;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Bean
extends AbstractNode {
    public static final String PROPERTY_REF = "Bean.Ref";
    public static final String PROPERTY_METHOD = "Bean.Method";
    public static final String PROPERTY_BEANTYPE = "Bean.BeanType";
    private String ref;
    private String method;
    private String beanType;

    public Bean() {
    }

    public Bean(BeanDefinition definition, RouteContainer parent) {
        super(parent);
        this.loadPropertiesFromCamelDefinition((ProcessorDefinition)definition);
        this.loadChildrenFromCamelDefinition((ProcessorDefinition)definition);
    }

    @Override
    public String getIconName() {
        return "bean.png";
    }

    @Override
    public String getDocumentationFileName() {
        return "beanComp";
    }

    @Override
    public String getCategoryName() {
        return "Endpoints";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        String oldValue = this.ref;
        this.ref = ref;
        this.firePropertyChange(PROPERTY_REF, oldValue, ref);
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        String oldValue = this.method;
        this.method = method;
        this.firePropertyChange(PROPERTY_METHOD, oldValue, method);
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        String oldValue = this.beanType;
        this.beanType = beanType;
        this.firePropertyChange(PROPERTY_BEANTYPE, oldValue, beanType);
    }

    @Override
    protected void addCustomProperties(Map<String, PropertyDescriptor> descriptors) {
        super.addCustomProperties(descriptors);
        TextPropertyDescriptor descRef = new TextPropertyDescriptor((Object)PROPERTY_REF, Messages.propertyLabelBeanRef);
        TextPropertyDescriptor descMethod = new TextPropertyDescriptor((Object)PROPERTY_METHOD, Messages.propertyLabelBeanMethod);
        TextPropertyDescriptor descBeanType = new TextPropertyDescriptor((Object)PROPERTY_BEANTYPE, Messages.propertyLabelBeanBeanType);
        descriptors.put(PROPERTY_REF, (PropertyDescriptor)descRef);
        descriptors.put(PROPERTY_METHOD, (PropertyDescriptor)descMethod);
        descriptors.put(PROPERTY_BEANTYPE, (PropertyDescriptor)descBeanType);
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (PROPERTY_REF.equals(id)) {
            this.setRef(Objects.convertTo(value, String.class));
        } else if (PROPERTY_METHOD.equals(id)) {
            this.setMethod(Objects.convertTo(value, String.class));
        } else if (PROPERTY_BEANTYPE.equals(id)) {
            this.setBeanType(Objects.convertTo(value, String.class));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    @Override
    public Object getPropertyValue(Object id) {
        if (PROPERTY_REF.equals(id)) {
            return this.getRef();
        }
        if (PROPERTY_METHOD.equals(id)) {
            return this.getMethod();
        }
        if (PROPERTY_BEANTYPE.equals(id)) {
            return this.getBeanType();
        }
        return super.getPropertyValue(id);
    }

    @Override
    public ProcessorDefinition createCamelDefinition() {
        BeanDefinition answer = new BeanDefinition();
        answer.setRef(this.toXmlPropertyValue(PROPERTY_REF, this.getRef()));
        answer.setMethod(this.toXmlPropertyValue(PROPERTY_METHOD, this.getMethod()));
        answer.setBeanType(this.toXmlPropertyValue(PROPERTY_BEANTYPE, this.getBeanType()));
        super.savePropertiesToCamelDefinition((ProcessorDefinition)answer);
        return answer;
    }

    @Override
    public Class<?> getCamelDefinitionClass() {
        return BeanDefinition.class;
    }

    @Override
    protected void loadPropertiesFromCamelDefinition(ProcessorDefinition processor) {
        super.loadPropertiesFromCamelDefinition(processor);
        if (!(processor instanceof BeanDefinition)) {
            throw new IllegalArgumentException("ProcessorDefinition not an instanceof BeanDefinition. Was " + processor.getClass().getName());
        }
        BeanDefinition node = (BeanDefinition)processor;
        this.setRef(node.getRef());
        this.setMethod(node.getMethod());
        this.setBeanType(node.getBeanType());
    }
}

